/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.module;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.apache.bifromq.basecluster.AgentHostOptions;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basecrdt.service.CRDTServiceOptions;
import org.apache.bifromq.basecrdt.service.ICRDTService;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficService;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.mqtt.inbox.IMqttBrokerClient;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.apache.bifromq.starter.config.StandaloneConfig;
import org.apache.bifromq.starter.config.model.dist.DistWorkerClientConfig;
import org.apache.bifromq.starter.config.model.inbox.InboxStoreClientConfig;
import org.apache.bifromq.starter.config.model.retain.RetainStoreClientConfig;
import org.apache.bifromq.starter.module.SharedResourceProvider;
import org.apache.bifromq.starter.module.SharedResourcesHolder;

public class CoreServiceModule
extends AbstractModule {
    protected void configure() {
        this.bind(SharedResourcesHolder.class).toProvider(SharedCloseableResourcesProvider.class).in(Singleton.class);
        this.bind(IAgentHost.class).toProvider(AgentHostProvider.class).in(Singleton.class);
        this.bind(ICRDTService.class).toProvider(CRDTServiceProvider.class).in(Singleton.class);
        this.bind(IBaseKVMetaService.class).toProvider(BaseKVMetaServiceProvider.class).in(Singleton.class);
        this.bind(IRPCServiceTrafficService.class).toProvider(RPCServiceTrafficServiceProvider.class).in(Singleton.class);
        this.bind(IDistClient.class).toProvider(DistClientProvider.class).in(Singleton.class);
        this.bind(IBaseKVStoreClient.class).annotatedWith((Annotation)Names.named((String)"distWorkerClient")).toProvider(DistWorkerClientProvider.class).in(Singleton.class);
        this.bind(IInboxClient.class).toProvider(InboxClientProvider.class).in(Singleton.class);
        this.bind(IBaseKVStoreClient.class).annotatedWith((Annotation)Names.named((String)"inboxStoreClient")).toProvider(InboxStoreClientProvider.class).in(Singleton.class);
        this.bind(IRetainClient.class).toProvider(RetainClientProvider.class).in(Singleton.class);
        this.bind(IBaseKVStoreClient.class).annotatedWith((Annotation)Names.named((String)"retainStoreClient")).toProvider(RetainStoreClientProvider.class).in(Singleton.class);
        this.bind(ISessionDictClient.class).toProvider(SessionDictClientProvider.class).in(Singleton.class);
        this.bind(IMqttBrokerClient.class).toProvider(MQTTBrokerClientProvider.class).in(Singleton.class);
    }

    private static class SharedCloseableResourcesProvider
    implements Provider<SharedResourcesHolder> {
        private SharedCloseableResourcesProvider() {
        }

        public SharedResourcesHolder get() {
            return new SharedResourcesHolder();
        }
    }

    private static class AgentHostProvider
    extends SharedResourceProvider<IAgentHost> {
        private final StandaloneConfig config;

        @Inject
        private AgentHostProvider(StandaloneConfig config, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.config = config;
        }

        @Override
        public IAgentHost share() {
            AgentHostOptions agentHostOptions = AgentHostOptions.builder().env(this.config.getClusterConfig().getEnv()).addr(this.config.getClusterConfig().getHost()).port(this.config.getClusterConfig().getPort()).build();
            return IAgentHost.newInstance((AgentHostOptions)agentHostOptions);
        }
    }

    private static class CRDTServiceProvider
    extends SharedResourceProvider<ICRDTService> {
        private final StandaloneConfig config;
        private final IAgentHost agentHost;

        @Inject
        private CRDTServiceProvider(StandaloneConfig config, IAgentHost agentHost, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.config = config;
            this.agentHost = agentHost;
        }

        @Override
        public ICRDTService share() {
            return ICRDTService.newInstance((IAgentHost)this.agentHost, (CRDTServiceOptions)CRDTServiceOptions.builder().build());
        }
    }

    private static class BaseKVMetaServiceProvider
    extends SharedResourceProvider<IBaseKVMetaService> {
        private final ICRDTService crdtService;

        @Inject
        private BaseKVMetaServiceProvider(ICRDTService crdtService, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.crdtService = crdtService;
        }

        @Override
        public IBaseKVMetaService share() {
            return IBaseKVMetaService.newInstance((ICRDTService)this.crdtService);
        }
    }

    private static class RPCServiceTrafficServiceProvider
    extends SharedResourceProvider<IRPCServiceTrafficService> {
        private final ICRDTService crdtService;

        @Inject
        private RPCServiceTrafficServiceProvider(ICRDTService crdtService, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.crdtService = crdtService;
        }

        @Override
        public IRPCServiceTrafficService share() {
            return IRPCServiceTrafficService.newInstance((ICRDTService)this.crdtService);
        }
    }

    private static class DistClientProvider
    extends SharedResourceProvider<IDistClient> {
        private final StandaloneConfig config;
        private final EventLoopGroup eventLoopGroup;
        private final SslContext sslContext;
        private final IRPCServiceTrafficService trafficService;

        @Inject
        private DistClientProvider(StandaloneConfig config, @Named(value="rpcClientEventLoop") EventLoopGroup eventLoopGroup, @Named(value="rpcClientSSLContext") Optional<SslContext> sslContext, IRPCServiceTrafficService trafficService, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.config = config;
            this.eventLoopGroup = eventLoopGroup;
            this.sslContext = sslContext.orElse(null);
            this.trafficService = trafficService;
        }

        @Override
        public IDistClient share() {
            return IDistClient.newBuilder().workerThreads(this.config.getDistServiceConfig().getClient().getWorkerThreads()).trafficService(this.trafficService).eventLoopGroup(this.eventLoopGroup).sslContext(this.sslContext).build();
        }
    }

    private static class DistWorkerClientProvider
    extends SharedResourceProvider<IBaseKVStoreClient> {
        private final StandaloneConfig config;
        private final EventLoopGroup eventLoopGroup;
        private final IRPCServiceTrafficService trafficService;
        private final IBaseKVMetaService metaService;
        private final SslContext rpcClientSSLContext;

        @Inject
        private DistWorkerClientProvider(StandaloneConfig config, IRPCServiceTrafficService trafficService, IBaseKVMetaService metaService, @Named(value="rpcClientSSLContext") Optional<SslContext> rpcClientSSLContext, @Named(value="rpcClientEventLoop") EventLoopGroup eventLoopGroup, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.config = config;
            this.trafficService = trafficService;
            this.metaService = metaService;
            this.rpcClientSSLContext = rpcClientSSLContext.orElse(null);
            this.eventLoopGroup = eventLoopGroup;
        }

        @Override
        public IBaseKVStoreClient share() {
            DistWorkerClientConfig workerConfig = this.config.getDistServiceConfig().getWorkerClient();
            return IBaseKVStoreClient.newBuilder().clusterId("dist.worker").trafficService(this.trafficService).metaService(this.metaService).workerThreads(workerConfig.getWorkerThreads()).eventLoopGroup(this.eventLoopGroup).sslContext(this.rpcClientSSLContext).queryPipelinesPerStore(workerConfig.getQueryPipelinePerStore()).build();
        }
    }

    private static class InboxClientProvider
    extends SharedResourceProvider<IInboxClient> {
        private final EventLoopGroup eventLoopGroup;
        private final SslContext sslContext;
        private final IRPCServiceTrafficService trafficService;

        @Inject
        private InboxClientProvider(@Named(value="rpcClientEventLoop") EventLoopGroup eventLoopGroup, @Named(value="rpcClientSSLContext") Optional<SslContext> sslContext, IRPCServiceTrafficService trafficService, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.eventLoopGroup = eventLoopGroup;
            this.sslContext = sslContext.orElse(null);
            this.trafficService = trafficService;
        }

        @Override
        public IInboxClient share() {
            return IInboxClient.newBuilder().trafficService(this.trafficService).eventLoopGroup(this.eventLoopGroup).sslContext(this.sslContext).build();
        }
    }

    private static class InboxStoreClientProvider
    extends SharedResourceProvider<IBaseKVStoreClient> {
        private final StandaloneConfig config;
        private final EventLoopGroup eventLoopGroup;
        private final IRPCServiceTrafficService trafficService;
        private final IBaseKVMetaService metaService;
        private final SslContext rpcClientSSLContext;

        @Inject
        private InboxStoreClientProvider(StandaloneConfig config, IRPCServiceTrafficService trafficService, IBaseKVMetaService metaService, @Named(value="rpcClientSSLContext") Optional<SslContext> rpcClientSSLContext, @Named(value="rpcClientEventLoop") EventLoopGroup eventLoopGroup, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.config = config;
            this.trafficService = trafficService;
            this.metaService = metaService;
            this.rpcClientSSLContext = rpcClientSSLContext.orElse(null);
            this.eventLoopGroup = eventLoopGroup;
        }

        @Override
        public IBaseKVStoreClient share() {
            InboxStoreClientConfig storeClientConfig = this.config.getInboxServiceConfig().getStoreClient();
            return IBaseKVStoreClient.newBuilder().clusterId("inbox.store").trafficService(this.trafficService).metaService(this.metaService).workerThreads(storeClientConfig.getWorkerThreads()).eventLoopGroup(this.eventLoopGroup).sslContext(this.rpcClientSSLContext).queryPipelinesPerStore(storeClientConfig.getQueryPipelinePerStore()).build();
        }
    }

    private static class RetainClientProvider
    extends SharedResourceProvider<IRetainClient> {
        private final EventLoopGroup eventLoopGroup;
        private final SslContext sslContext;
        private final IRPCServiceTrafficService trafficService;

        @Inject
        private RetainClientProvider(@Named(value="rpcClientEventLoop") EventLoopGroup eventLoopGroup, @Named(value="rpcClientSSLContext") Optional<SslContext> sslContext, IRPCServiceTrafficService trafficService, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.eventLoopGroup = eventLoopGroup;
            this.sslContext = sslContext.orElse(null);
            this.trafficService = trafficService;
        }

        @Override
        public IRetainClient share() {
            return IRetainClient.newBuilder().trafficService(this.trafficService).eventLoopGroup(this.eventLoopGroup).sslContext(this.sslContext).build();
        }
    }

    private static class RetainStoreClientProvider
    extends SharedResourceProvider<IBaseKVStoreClient> {
        private final StandaloneConfig config;
        private final EventLoopGroup eventLoopGroup;
        private final IRPCServiceTrafficService trafficService;
        private final IBaseKVMetaService metaService;
        private final SslContext rpcClientSSLContext;

        @Inject
        private RetainStoreClientProvider(StandaloneConfig config, @Named(value="rpcClientEventLoop") EventLoopGroup eventLoopGroup, IRPCServiceTrafficService trafficService, IBaseKVMetaService metaService, @Named(value="rpcClientSSLContext") Optional<SslContext> rpcClientSSLContext, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.config = config;
            this.eventLoopGroup = eventLoopGroup;
            this.trafficService = trafficService;
            this.metaService = metaService;
            this.rpcClientSSLContext = rpcClientSSLContext.orElse(null);
        }

        @Override
        public IBaseKVStoreClient share() {
            RetainStoreClientConfig clientConfig = this.config.getRetainServiceConfig().getStoreClient();
            return IBaseKVStoreClient.newBuilder().clusterId("retain.store").trafficService(this.trafficService).metaService(this.metaService).eventLoopGroup(this.eventLoopGroup).workerThreads(clientConfig.getWorkerThreads()).sslContext(this.rpcClientSSLContext).queryPipelinesPerStore(clientConfig.getQueryPipelinePerStore()).build();
        }
    }

    private static class SessionDictClientProvider
    extends SharedResourceProvider<ISessionDictClient> {
        private final StandaloneConfig config;
        private final EventLoopGroup eventLoopGroup;
        private final SslContext sslContext;
        private final IRPCServiceTrafficService trafficService;

        @Inject
        private SessionDictClientProvider(StandaloneConfig config, @Named(value="rpcClientEventLoop") EventLoopGroup eventLoopGroup, @Named(value="rpcClientSSLContext") Optional<SslContext> sslContext, IRPCServiceTrafficService trafficService, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.config = config;
            this.eventLoopGroup = eventLoopGroup;
            this.sslContext = sslContext.orElse(null);
            this.trafficService = trafficService;
        }

        @Override
        public ISessionDictClient share() {
            return ISessionDictClient.newBuilder().workerThreads(this.config.getSessionDictServiceConfig().getClient().getWorkerThreads()).trafficService(this.trafficService).eventLoopGroup(this.eventLoopGroup).sslContext(this.sslContext).build();
        }
    }

    private static class MQTTBrokerClientProvider
    extends SharedResourceProvider<IMqttBrokerClient> {
        private final StandaloneConfig config;
        private final EventLoopGroup eventLoopGroup;
        private final SslContext sslContext;
        private final IRPCServiceTrafficService trafficService;

        @Inject
        private MQTTBrokerClientProvider(StandaloneConfig config, @Named(value="rpcClientEventLoop") EventLoopGroup eventLoopGroup, @Named(value="rpcClientSSLContext") Optional<SslContext> sslContext, IRPCServiceTrafficService trafficService, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.config = config;
            this.eventLoopGroup = eventLoopGroup;
            this.sslContext = sslContext.orElse(null);
            this.trafficService = trafficService;
        }

        @Override
        public IMqttBrokerClient share() {
            return IMqttBrokerClient.newBuilder().workerThreads(this.config.getMqttServiceConfig().getClient().getWorkerThreads()).trafficService(this.trafficService).eventLoopGroup(this.eventLoopGroup).sslContext(this.sslContext).build();
        }
    }
}

