/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.apache.polaris.core.entity.Identifiable;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntityType;

public class PolarisEntityCore
implements Identifiable {
    protected final long catalogId;
    protected final long id;
    protected final long parentId;
    protected final int typeCode;
    protected final String name;
    protected final int entityVersion;

    PolarisEntityCore(Builder<?, ?> builder) {
        this.catalogId = builder.catalogId;
        this.id = builder.id;
        this.parentId = builder.parentId;
        this.typeCode = builder.typeCode;
        this.name = builder.name;
        this.entityVersion = builder.entityVersion == 0 ? 1 : builder.entityVersion;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public String getName() {
        return this.name;
    }

    public int getEntityVersion() {
        return this.entityVersion;
    }

    @Override
    public long getCatalogId() {
        return this.catalogId;
    }

    @JsonIgnore
    public PolarisEntityType getType() {
        return PolarisEntityType.fromCode(this.typeCode);
    }

    @JsonIgnore
    public boolean cannotBeDroppedOrRenamed() {
        return this.typeCode == PolarisEntityType.CATALOG_ROLE.getCode() && this.name.equals(PolarisEntityConstants.getNameOfCatalogAdminRole()) || this.typeCode == PolarisEntityType.PRINCIPAL_ROLE.getCode() && this.name.equals(PolarisEntityConstants.getNameOfPrincipalServiceAdminRole());
    }

    @JsonIgnore
    public boolean isTopLevel() {
        return this.getType().isTopLevel();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolarisEntityCore)) {
            return false;
        }
        PolarisEntityCore that = (PolarisEntityCore)o;
        return this.catalogId == that.catalogId && this.id == that.id && this.parentId == that.parentId && this.typeCode == that.typeCode && this.entityVersion == that.entityVersion && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.catalogId, this.id, this.parentId, this.typeCode, this.name, this.entityVersion);
    }

    public String toString() {
        return "PolarisEntityCore{catalogId=" + this.catalogId + ", id=" + this.id + ", parentId=" + this.parentId + ", typeCode=" + this.typeCode + ", name='" + this.name + "', entityVersion=" + this.entityVersion + "}";
    }

    public static class Builder<T extends PolarisEntityCore, B extends Builder<T, B>> {
        private long catalogId;
        private long id;
        private long parentId;
        private int typeCode;
        private String name;
        private int entityVersion;

        B self() {
            return (B)this;
        }

        public B catalogId(long catalogId) {
            this.catalogId = catalogId;
            return this.self();
        }

        public B id(long id) {
            this.id = id;
            return this.self();
        }

        public B parentId(long parentId) {
            this.parentId = parentId;
            return this.self();
        }

        public B typeCode(int typeCode) {
            this.typeCode = typeCode;
            return this.self();
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B entityVersion(int entityVersion) {
            this.entityVersion = entityVersion;
            return this.self();
        }

        public Builder() {
        }

        public Builder(PolarisEntityCore entityCore) {
            this.catalogId = entityCore.catalogId;
            this.id = entityCore.id;
            this.parentId = entityCore.parentId;
            this.typeCode = entityCore.typeCode;
            this.name = entityCore.name;
            this.entityVersion = entityCore.entityVersion;
        }

        public PolarisEntityCore build() {
            return new PolarisEntityCore(this);
        }
    }
}

