/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc.models;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.polaris.core.entity.PolarisEvent;
import org.apache.polaris.persistence.relational.jdbc.models.ModelEvent;
import org.immutables.value.Generated;

@Generated(from="ModelEvent", generator="Immutables")
public final class ImmutableModelEvent
implements ModelEvent {
    private final String catalogId;
    private final String eventId;
    @Nullable
    private final String requestId;
    private final String eventType;
    private final long timestampMs;
    @Nullable
    private final String principalName;
    private final PolarisEvent.ResourceType resourceType;
    private final String resourceIdentifier;
    private final String additionalProperties;
    private transient int hashCode;

    private ImmutableModelEvent(String catalogId, String eventId, @Nullable String requestId, String eventType, long timestampMs, @Nullable String principalName, PolarisEvent.ResourceType resourceType, String resourceIdentifier, String additionalProperties) {
        this.catalogId = catalogId;
        this.eventId = eventId;
        this.requestId = requestId;
        this.eventType = eventType;
        this.timestampMs = timestampMs;
        this.principalName = principalName;
        this.resourceType = resourceType;
        this.resourceIdentifier = resourceIdentifier;
        this.additionalProperties = additionalProperties;
    }

    @Override
    public String getCatalogId() {
        return this.catalogId;
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    @Override
    @Nullable
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    @Override
    public long getTimestampMs() {
        return this.timestampMs;
    }

    @Override
    @Nullable
    public String getPrincipalName() {
        return this.principalName;
    }

    @Override
    public PolarisEvent.ResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    @Override
    public String getAdditionalProperties() {
        return this.additionalProperties;
    }

    public final ImmutableModelEvent withCatalogId(String value) {
        String newValue = Objects.requireNonNull(value, "catalogId");
        if (this.catalogId.equals(newValue)) {
            return this;
        }
        return new ImmutableModelEvent(newValue, this.eventId, this.requestId, this.eventType, this.timestampMs, this.principalName, this.resourceType, this.resourceIdentifier, this.additionalProperties);
    }

    public final ImmutableModelEvent withEventId(String value) {
        String newValue = Objects.requireNonNull(value, "eventId");
        if (this.eventId.equals(newValue)) {
            return this;
        }
        return new ImmutableModelEvent(this.catalogId, newValue, this.requestId, this.eventType, this.timestampMs, this.principalName, this.resourceType, this.resourceIdentifier, this.additionalProperties);
    }

    public final ImmutableModelEvent withRequestId(@Nullable String value) {
        if (Objects.equals(this.requestId, value)) {
            return this;
        }
        return new ImmutableModelEvent(this.catalogId, this.eventId, value, this.eventType, this.timestampMs, this.principalName, this.resourceType, this.resourceIdentifier, this.additionalProperties);
    }

    public final ImmutableModelEvent withEventType(String value) {
        String newValue = Objects.requireNonNull(value, "eventType");
        if (this.eventType.equals(newValue)) {
            return this;
        }
        return new ImmutableModelEvent(this.catalogId, this.eventId, this.requestId, newValue, this.timestampMs, this.principalName, this.resourceType, this.resourceIdentifier, this.additionalProperties);
    }

    public final ImmutableModelEvent withTimestampMs(long value) {
        if (this.timestampMs == value) {
            return this;
        }
        return new ImmutableModelEvent(this.catalogId, this.eventId, this.requestId, this.eventType, value, this.principalName, this.resourceType, this.resourceIdentifier, this.additionalProperties);
    }

    public final ImmutableModelEvent withPrincipalName(@Nullable String value) {
        if (Objects.equals(this.principalName, value)) {
            return this;
        }
        return new ImmutableModelEvent(this.catalogId, this.eventId, this.requestId, this.eventType, this.timestampMs, value, this.resourceType, this.resourceIdentifier, this.additionalProperties);
    }

    public final ImmutableModelEvent withResourceType(PolarisEvent.ResourceType value) {
        PolarisEvent.ResourceType newValue = Objects.requireNonNull(value, "resourceType");
        if (this.resourceType == newValue) {
            return this;
        }
        return new ImmutableModelEvent(this.catalogId, this.eventId, this.requestId, this.eventType, this.timestampMs, this.principalName, newValue, this.resourceIdentifier, this.additionalProperties);
    }

    public final ImmutableModelEvent withResourceIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "resourceIdentifier");
        if (this.resourceIdentifier.equals(newValue)) {
            return this;
        }
        return new ImmutableModelEvent(this.catalogId, this.eventId, this.requestId, this.eventType, this.timestampMs, this.principalName, this.resourceType, newValue, this.additionalProperties);
    }

    public final ImmutableModelEvent withAdditionalProperties(String value) {
        String newValue = Objects.requireNonNull(value, "additionalProperties");
        if (this.additionalProperties.equals(newValue)) {
            return this;
        }
        return new ImmutableModelEvent(this.catalogId, this.eventId, this.requestId, this.eventType, this.timestampMs, this.principalName, this.resourceType, this.resourceIdentifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModelEvent && this.equalsByValue((ImmutableModelEvent)another);
    }

    private boolean equalsByValue(ImmutableModelEvent another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.catalogId.equals(another.catalogId) && this.eventId.equals(another.eventId) && Objects.equals(this.requestId, another.requestId) && this.eventType.equals(another.eventType) && this.timestampMs == another.timestampMs && Objects.equals(this.principalName, another.principalName) && this.resourceType.equals((Object)another.resourceType) && this.resourceIdentifier.equals(another.resourceIdentifier) && this.additionalProperties.equals(another.additionalProperties);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.catalogId.hashCode();
        h += (h << 5) + this.eventId.hashCode();
        h += (h << 5) + Objects.hashCode(this.requestId);
        h += (h << 5) + this.eventType.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.timestampMs);
        h += (h << 5) + Objects.hashCode(this.principalName);
        h += (h << 5) + this.resourceType.hashCode();
        h += (h << 5) + this.resourceIdentifier.hashCode();
        h += (h << 5) + this.additionalProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModelEvent").omitNullValues().add("catalogId", (Object)this.catalogId).add("eventId", (Object)this.eventId).add("requestId", (Object)this.requestId).add("eventType", (Object)this.eventType).add("timestampMs", this.timestampMs).add("principalName", (Object)this.principalName).add("resourceType", (Object)this.resourceType).add("resourceIdentifier", (Object)this.resourceIdentifier).add("additionalProperties", (Object)this.additionalProperties).toString();
    }

    public static ImmutableModelEvent copyOf(ModelEvent instance) {
        if (instance instanceof ImmutableModelEvent) {
            return (ImmutableModelEvent)instance;
        }
        return ImmutableModelEvent.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableModelEvent.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ModelEvent", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CATALOG_ID = 1L;
        private static final long INIT_BIT_EVENT_ID = 2L;
        private static final long INIT_BIT_EVENT_TYPE = 4L;
        private static final long INIT_BIT_TIMESTAMP_MS = 8L;
        private static final long INIT_BIT_RESOURCE_TYPE = 16L;
        private static final long INIT_BIT_RESOURCE_IDENTIFIER = 32L;
        private static final long INIT_BIT_ADDITIONAL_PROPERTIES = 64L;
        private long initBits = 127L;
        private String catalogId;
        private String eventId;
        private String requestId;
        private String eventType;
        private long timestampMs;
        private String principalName;
        private PolarisEvent.ResourceType resourceType;
        private String resourceIdentifier;
        private String additionalProperties;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModelEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.catalogId(instance.getCatalogId());
            this.eventId(instance.getEventId());
            String requestIdValue = instance.getRequestId();
            if (requestIdValue != null) {
                this.requestId(requestIdValue);
            }
            this.eventType(instance.getEventType());
            this.timestampMs(instance.getTimestampMs());
            String principalNameValue = instance.getPrincipalName();
            if (principalNameValue != null) {
                this.principalName(principalNameValue);
            }
            this.resourceType(instance.getResourceType());
            this.resourceIdentifier(instance.getResourceIdentifier());
            this.additionalProperties(instance.getAdditionalProperties());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder catalogId(String catalogId) {
            this.catalogId = Objects.requireNonNull(catalogId, "catalogId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder eventId(String eventId) {
            this.eventId = Objects.requireNonNull(eventId, "eventId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder requestId(@Nullable String requestId) {
            this.requestId = requestId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder eventType(String eventType) {
            this.eventType = Objects.requireNonNull(eventType, "eventType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timestampMs(long timestampMs) {
            this.timestampMs = timestampMs;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder principalName(@Nullable String principalName) {
            this.principalName = principalName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder resourceType(PolarisEvent.ResourceType resourceType) {
            this.resourceType = Objects.requireNonNull(resourceType, "resourceType");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = Objects.requireNonNull(resourceIdentifier, "resourceIdentifier");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder additionalProperties(String additionalProperties) {
            this.additionalProperties = Objects.requireNonNull(additionalProperties, "additionalProperties");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 127L;
            this.catalogId = null;
            this.eventId = null;
            this.requestId = null;
            this.eventType = null;
            this.timestampMs = 0L;
            this.principalName = null;
            this.resourceType = null;
            this.resourceIdentifier = null;
            this.additionalProperties = null;
            return this;
        }

        public ImmutableModelEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableModelEvent(this.catalogId, this.eventId, this.requestId, this.eventType, this.timestampMs, this.principalName, this.resourceType, this.resourceIdentifier, this.additionalProperties);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("catalogId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("eventId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("eventType");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("timestampMs");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("resourceType");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("resourceIdentifier");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("additionalProperties");
            }
            return "Cannot build ModelEvent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

