/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;

public class DropContinuousQueryStatement
extends Statement
implements IConfigStatement {
    private final String cqId;

    public DropContinuousQueryStatement(String cqId) {
        this.statementType = StatementType.DROP_CONTINUOUS_QUERY;
        this.cqId = cqId;
    }

    public String getCqId() {
        return this.cqId;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    @Override
    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitDropContinuousQuery(this, context);
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.USE_CQ.ordinal()), PrivilegeType.USE_CQ);
    }
}

