/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.memory;

import java.util.TreeSet;
import org.apache.iotdb.commons.memory.IMemoryBlock;
import org.apache.iotdb.commons.memory.MemoryBlockType;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.conf.DataNodeMemoryConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.TimeIndexLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(TsFileResourceManager.class);
    private static final DataNodeMemoryConfig MEMORY_CONFIG = IoTDBDescriptor.getInstance().getMemoryConfig();
    private final IMemoryBlock memoryBlock;
    private final TreeSet<TsFileResource> sealedTsFileResources = new TreeSet(TsFileResource::compareIndexDegradePriority);
    private long degradedTimeIndexNum = 0L;

    private TsFileResourceManager() {
        this.memoryBlock = MEMORY_CONFIG.getTimeIndexMemoryManager().exactAllocate("TimeIndex", MemoryBlockType.DYNAMIC);
    }

    @TestOnly
    public void setTimeIndexMemoryThreshold(long timeIndexMemoryThreshold) {
        this.memoryBlock.setTotalMemorySizeInBytes(timeIndexMemoryThreshold);
    }

    public long getPriorityQueueSize() {
        return this.sealedTsFileResources.size();
    }

    public synchronized void registerSealedTsFileResource(TsFileResource tsFileResource) {
        if (!this.sealedTsFileResources.contains(tsFileResource)) {
            this.sealedTsFileResources.add(tsFileResource);
            this.memoryBlock.forceAllocateWithoutLimitation(tsFileResource.calculateRamSize());
            this.chooseTsFileResourceToDegrade();
        }
    }

    public synchronized void removeTsFileResource(TsFileResource tsFileResource) {
        if (this.sealedTsFileResources.contains(tsFileResource)) {
            this.sealedTsFileResources.remove(tsFileResource);
            if (TimeIndexLevel.valueOf(tsFileResource.getTimeIndexType()) == TimeIndexLevel.FILE_TIME_INDEX) {
                this.memoryBlock.release(tsFileResource.calculateRamSize());
                --this.degradedTimeIndexNum;
            } else {
                this.memoryBlock.release(tsFileResource.calculateRamSize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDegradeTsFileResource(TsFileResource resource) {
        if (TimeIndexLevel.valueOf(resource.getTimeIndexType()) == TimeIndexLevel.FILE_TIME_INDEX) {
            return;
        }
        logger.debug("Force degrade tsfile resource {}", (Object)resource.getTsFilePath());
        TsFileResourceManager tsFileResourceManager = this;
        synchronized (tsFileResourceManager) {
            if (!this.sealedTsFileResources.remove(resource)) {
                resource.degradeTimeIndex();
                return;
            }
            long memoryReduce = resource.degradeTimeIndex();
            ++this.degradedTimeIndexNum;
            this.releaseTimeIndexMemCost(memoryReduce);
            this.sealedTsFileResources.add(resource);
        }
    }

    private void releaseTimeIndexMemCost(long memCost) {
        this.memoryBlock.release(memCost);
    }

    private void chooseTsFileResourceToDegrade() {
        while (this.memoryBlock.getUsedMemoryInBytes() > this.memoryBlock.getTotalMemorySizeInBytes()) {
            TsFileResource tsFileResource = this.sealedTsFileResources.pollFirst();
            if (tsFileResource == null || TimeIndexLevel.valueOf(tsFileResource.getTimeIndexType()) == TimeIndexLevel.FILE_TIME_INDEX) {
                logger.debug("Can't degrade time index any more because all time index are file level.");
                this.sealedTsFileResources.add(tsFileResource);
                return;
            }
            long memoryReduce = tsFileResource.degradeTimeIndex();
            logger.debug("Degrade tsfile resource {}", (Object)tsFileResource.getTsFilePath());
            ++this.degradedTimeIndexNum;
            this.releaseTimeIndexMemCost(memoryReduce);
            this.sealedTsFileResources.add(tsFileResource);
        }
    }

    public long getDegradedTimeIndexNum() {
        return this.degradedTimeIndexNum;
    }

    public long getTimeIndexMemoryThreshold() {
        return this.memoryBlock.getTotalMemorySizeInBytes();
    }

    public long getTotalTimeIndexMemCost() {
        return this.memoryBlock.getUsedMemoryInBytes();
    }

    @TestOnly
    public synchronized void clear() {
        this.sealedTsFileResources.clear();
        this.memoryBlock.setUsedMemoryInBytes(0L);
        this.degradedTimeIndexNum = 0L;
    }

    public static TsFileResourceManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static class InstanceHolder {
        private static final TsFileResourceManager INSTANCE = new TsFileResourceManager();

        private InstanceHolder() {
        }
    }
}

