/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.pipe.payload;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.table.AbstractTablePlan;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeDeleteDevicesPlan
extends AbstractTablePlan {
    private byte[] patternBytes;
    private byte[] filterBytes;
    private byte[] modBytes;

    public PipeDeleteDevicesPlan() {
        super(ConfigPhysicalPlanType.PipeDeleteDevices);
    }

    public PipeDeleteDevicesPlan(String database, String tableName, @Nonnull byte[] patternBytes, @Nonnull byte[] filterBytes, @Nonnull byte[] modBytes) {
        super(ConfigPhysicalPlanType.PipeDeleteDevices, database, tableName);
        this.patternBytes = patternBytes;
        this.filterBytes = filterBytes;
        this.modBytes = modBytes;
    }

    public byte[] getPatternBytes() {
        return this.patternBytes;
    }

    public byte[] getFilterBytes() {
        return this.filterBytes;
    }

    public byte[] getModBytes() {
        return this.modBytes;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        super.serializeImpl(stream);
        ReadWriteIOUtils.write((int)this.patternBytes.length, (OutputStream)stream);
        stream.write(this.patternBytes);
        ReadWriteIOUtils.write((int)this.filterBytes.length, (OutputStream)stream);
        stream.write(this.filterBytes);
        ReadWriteIOUtils.write((int)this.modBytes.length, (OutputStream)stream);
        stream.write(this.modBytes);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        super.deserializeImpl(buffer);
        this.patternBytes = new byte[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
        buffer.get(this.patternBytes);
        this.filterBytes = new byte[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
        buffer.get(this.filterBytes);
        this.modBytes = new byte[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
        buffer.get(this.modBytes);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Arrays.equals(this.patternBytes, ((PipeDeleteDevicesPlan)obj).patternBytes) && Arrays.equals(this.filterBytes, ((PipeDeleteDevicesPlan)obj).filterBytes) && Arrays.equals(this.modBytes, ((PipeDeleteDevicesPlan)obj).modBytes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.patternBytes), Arrays.hashCode(this.filterBytes), Arrays.hashCode(this.modBytes));
    }
}

