/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata.idcolumn;

import org.apache.tsfile.file.metadata.IDeviceID;

public class TwoLevelDBExtractor
implements IDeviceID.TreeDeviceIdColumnValueExtractor {
    private final int treeDBLength;

    public TwoLevelDBExtractor(int treeDBLength) {
        this.treeDBLength = treeDBLength;
    }

    @Override
    public Object extract(IDeviceID treeDeviceId, int idColumnIndex) {
        String firstSegment = (String)treeDeviceId.segment(0);
        int firstSegmentLength = firstSegment.length();
        if (firstSegmentLength < this.treeDBLength) {
            return null;
        }
        if (firstSegmentLength == this.treeDBLength) {
            return idColumnIndex == 0 ? treeDeviceId.segment(1) : null;
        }
        return idColumnIndex == 0 ? firstSegment.substring(this.treeDBLength + 1) : treeDeviceId.segment(idColumnIndex);
    }
}

