/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public abstract class AbstractBitwiseColumnTransformer
extends UnaryColumnTransformer {
    protected final long rightValue;

    public AbstractBitwiseColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, long rightValue) {
        super(returnType, childColumnTransformer);
        this.rightValue = rightValue;
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                this.transform(column, columnBuilder, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                this.transform(column, columnBuilder, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    protected abstract void transform(Column var1, ColumnBuilder var2, int var3);
}

