/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.fuseki.access.SecurityContextAllowAll;
import org.apache.jena.fuseki.access.SecurityContextAllowNone;
import org.apache.jena.fuseki.access.SecurityContextView;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecutionAdapter;
import org.apache.jena.tdb1.sys.TDBInternal;

public interface SecurityContext {
    public static final SecurityContext NONE = new SecurityContextAllowNone();
    public static final SecurityContext ALL = new SecurityContextAllowAll();
    public static final Node allGraphs = NodeFactory.createURI("urn:jena:accessAllGraphs");
    public static final Node allNamedGraphs = NodeFactory.createURI("urn:jena:accessAllNamedGraphs");
    public static final Node allNamedGraphsStr = NodeFactory.createLiteralString("*");
    public static final Node allGraphsStr = NodeFactory.createLiteralString("**");

    public static SecurityContext ALL_NG(DatasetGraph dsg) {
        List<Node> names = Iter.toList(dsg.listGraphNodes());
        return new SecurityContextView(names);
    }

    public Collection<Node> visibleGraphs();

    default public Collection<String> visibleGraphNames() {
        if (this.visibleGraphs() == null) {
            return null;
        }
        return this.visibleGraphs().stream().filter(Node::isURI).map(Node::getURI).collect(Collectors.toList());
    }

    public boolean visableDefaultGraph();

    @Deprecated(forRemoval=true)
    default public QueryExecution createQueryExecution(String queryString, DatasetGraph dsg) {
        return this.createQueryExecution(QueryFactory.create(queryString), dsg);
    }

    @Deprecated(forRemoval=true)
    default public QueryExecution createQueryExecution(Query query2, DatasetGraph dsg) {
        return QueryExecutionAdapter.adapt(this.createQueryExec(query2, dsg));
    }

    public QueryExec createQueryExec(Query var1, DatasetGraph var2);

    public Predicate<Quad> predicateQuad();

    default public void filterTDB(DatasetGraph dsg, QueryExec qExec) {
        if (!TDBInternal.isTDB1(dsg) || !org.apache.jena.tdb2.sys.TDBInternal.isTDB2(dsg)) {
            throw new IllegalArgumentException("Not a TDB database");
        }
        throw new UnsupportedOperationException();
    }
}

