/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet.security;

import jakarta.servlet.HttpConstraintElement;
import jakarta.servlet.HttpMethodConstraintElement;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.annotation.ServletSecurity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.security.ConstraintAware;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintSecurityHandler
extends SecurityHandler
implements ConstraintAware {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityHandler.class);
    private static final String OMISSION_SUFFIX = ".omission";
    private static final String ALL_METHODS = "*";
    public static final String ANY_KNOWN_ROLE = "*";
    public static final String ANY_ROLE = "**";
    private final List<ConstraintMapping> _constraintMappings = new CopyOnWriteArrayList<ConstraintMapping>();
    private final List<ConstraintMapping> _durableConstraintMappings = new CopyOnWriteArrayList<ConstraintMapping>();
    private final Set<String> _roles = new CopyOnWriteArraySet<String>();
    private final PathMappings<Map<String, Constraint>> _constraintsByPathAndMethod = new PathMappings();
    private boolean _denyUncoveredMethods = false;

    @Override
    protected Constraint getConstraint(String pathInContext, Request request) {
        MatchedResource<Map<String, Constraint>> resource = this._constraintsByPathAndMethod.getMatched(pathInContext);
        if (resource == null) {
            return null;
        }
        Map<String, Constraint> mappings = resource.getResource();
        if (mappings == null) {
            return null;
        }
        String httpMethod = request.getMethod();
        Constraint constraint = mappings.get(httpMethod);
        if (constraint == null) {
            constraint = mappings.get("*");
            for (Map.Entry<String, Constraint> entry : mappings.entrySet()) {
                if (entry.getKey() == null || !entry.getKey().endsWith(OMISSION_SUFFIX) || entry.getKey().contains(httpMethod)) continue;
                constraint = this.combineServletConstraints(constraint, entry.getValue());
            }
            if (constraint == null && this.isDenyUncoveredHttpMethods()) {
                constraint = Constraint.FORBIDDEN;
            }
        }
        return constraint;
    }

    public static Constraint createConstraint(String name, HttpConstraintElement element) {
        return ConstraintSecurityHandler.createConstraint(name, element.getRolesAllowed(), element.getEmptyRoleSemantic(), element.getTransportGuarantee());
    }

    public static Constraint createConstraint(String name, String[] rolesAllowed, ServletSecurity.EmptyRoleSemantic permitOrDeny, ServletSecurity.TransportGuarantee transport) {
        Constraint.Builder constraint = new Constraint.Builder();
        if (rolesAllowed == null || rolesAllowed.length == 0) {
            if (permitOrDeny.equals((Object)ServletSecurity.EmptyRoleSemantic.DENY)) {
                constraint.name(name + "-Deny");
                constraint.authorization(Constraint.Authorization.FORBIDDEN);
            } else {
                constraint.name(name + "-Permit");
                constraint.authorization(Constraint.Authorization.ALLOWED);
            }
        } else {
            constraint.authorization(Constraint.Authorization.SPECIFIC_ROLE);
            constraint.roles(rolesAllowed);
            constraint.name(name + "-RolesAllowed");
        }
        constraint.transport(ServletSecurity.TransportGuarantee.CONFIDENTIAL.equals((Object)transport) ? Constraint.Transport.SECURE : Constraint.Transport.ANY);
        return constraint.build();
    }

    public static List<ConstraintMapping> removeConstraintMappingsForPath(String pathSpec, List<ConstraintMapping> constraintMappings) {
        if (pathSpec == null || "".equals(pathSpec.trim()) || constraintMappings == null || constraintMappings.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ConstraintMapping> mappings = new ArrayList<ConstraintMapping>();
        for (ConstraintMapping mapping : constraintMappings) {
            if (pathSpec.equals(mapping.getPathSpec())) continue;
            mappings.add(mapping);
        }
        return mappings;
    }

    public static List<ConstraintMapping> createConstraintsWithMappingsForPath(String name, String pathSpec, ServletSecurityElement securityElement) {
        ArrayList<ConstraintMapping> mappings = new ArrayList<ConstraintMapping>();
        ConstraintMapping httpConstraintMapping = null;
        if (securityElement.getEmptyRoleSemantic() != ServletSecurity.EmptyRoleSemantic.PERMIT || securityElement.getRolesAllowed().length != 0 || securityElement.getTransportGuarantee() != ServletSecurity.TransportGuarantee.NONE) {
            Constraint httpConstraint = ConstraintSecurityHandler.createConstraint(name, securityElement);
            httpConstraintMapping = new ConstraintMapping();
            httpConstraintMapping.setPathSpec(pathSpec);
            httpConstraintMapping.setConstraint(httpConstraint);
            mappings.add(httpConstraintMapping);
        }
        ArrayList<String> methodOmissions = new ArrayList<String>();
        Collection<HttpMethodConstraintElement> methodConstraintElements = securityElement.getHttpMethodConstraints();
        if (methodConstraintElements != null) {
            for (HttpMethodConstraintElement methodConstraintElement : methodConstraintElements) {
                Constraint methodConstraint = ConstraintSecurityHandler.createConstraint(name, methodConstraintElement);
                ConstraintMapping mapping = new ConstraintMapping();
                mapping.setConstraint(methodConstraint);
                mapping.setPathSpec(pathSpec);
                if (methodConstraintElement.getMethodName() != null) {
                    mapping.setMethod(methodConstraintElement.getMethodName());
                    methodOmissions.add(methodConstraintElement.getMethodName());
                }
                mappings.add(mapping);
            }
        }
        if (methodOmissions.size() > 0 && httpConstraintMapping != null) {
            httpConstraintMapping.setMethodOmissions(methodOmissions.toArray(new String[0]));
        }
        return mappings;
    }

    @Override
    public List<ConstraintMapping> getConstraintMappings() {
        return this._constraintMappings;
    }

    @Override
    public Set<String> getKnownRoles() {
        return this._roles;
    }

    public void setConstraintMappings(List<ConstraintMapping> constraintMappings) {
        this.setConstraintMappings(constraintMappings, null);
    }

    public void setConstraintMappings(ConstraintMapping[] constraintMappings) {
        this.setConstraintMappings(Arrays.asList(constraintMappings), null);
    }

    @Override
    public void setConstraintMappings(List<ConstraintMapping> constraintMappings, Set<String> roles) {
        this._constraintMappings.clear();
        this._constraintMappings.addAll(constraintMappings);
        this._durableConstraintMappings.clear();
        if (this.isInDurableState()) {
            this._durableConstraintMappings.addAll(constraintMappings);
        }
        if (roles == null) {
            roles = new HashSet<String>();
            for (ConstraintMapping cm : constraintMappings) {
                Set<String> cmr = cm.getConstraint().getRoles();
                if (cmr == null) continue;
                for (String r : cmr) {
                    if ("*".equals(r)) continue;
                    roles.add(r);
                }
            }
        }
        this.setRoles(roles);
        if (this.isStarted()) {
            this._constraintMappings.forEach(this::processConstraintMapping);
        }
    }

    public void setRoles(Set<String> roles) {
        this._roles.clear();
        this._roles.addAll(roles);
    }

    @Override
    public void addConstraintMapping(ConstraintMapping mapping) {
        this._constraintMappings.add(mapping);
        if (this.isInDurableState()) {
            this._durableConstraintMappings.add(mapping);
        }
        if (mapping.getConstraint() != null && mapping.getConstraint().getRoles() != null) {
            for (String role : mapping.getConstraint().getRoles()) {
                if ("*".equals(role) || ANY_ROLE.equals(role)) continue;
                this.addKnownRole(role);
            }
        }
        if (this.isStarted()) {
            this.processConstraintMapping(mapping);
        }
    }

    @Override
    public void addKnownRole(String role) {
        this._roles.add(role);
    }

    @Override
    protected void doStart() throws Exception {
        this._constraintsByPathAndMethod.reset();
        this._constraintMappings.forEach(this::processConstraintMapping);
        this.checkPathsWithUncoveredHttpMethods();
        Context context2 = ContextHandler.getCurrentContext();
        if (context2 instanceof ServletContextHandler.ServletScopedContext) {
            ServletContextHandler.ServletScopedContext servletScopedContext = (ServletContextHandler.ServletScopedContext)context2;
            ServletContextHandler.ServletContextApi servletContext = servletScopedContext.getServletContext();
            Enumeration<String> names = servletContext.getInitParameterNames();
            while (names != null && names.hasMoreElements()) {
                String name = names.nextElement();
                if (!name.startsWith("org.eclipse.jetty.security.") || this.getParameter(name) != null) continue;
                this.setParameter(name, servletContext.getInitParameter(name));
            }
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._constraintsByPathAndMethod.reset();
        this._constraintMappings.clear();
        this._constraintMappings.addAll(this._durableConstraintMappings);
    }

    protected Constraint combineServletConstraints(Constraint constraintA, Constraint constraintB) {
        Constraint.Authorization authorization;
        if (constraintA == null) {
            return constraintB == null ? Constraint.ALLOWED_ANY_TRANSPORT : constraintB;
        }
        if (constraintB == null) {
            return constraintA;
        }
        Constraint.Authorization authorizationA = constraintA.getAuthorization();
        if (authorizationA == Constraint.Authorization.INHERIT) {
            authorizationA = Constraint.Authorization.ALLOWED;
        }
        Set<String> roles = null;
        Constraint.Authorization authorizationB = constraintB.getAuthorization();
        if (authorizationB == null) {
            authorization = authorizationA;
        } else {
            switch (authorizationB) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case FORBIDDEN: {
                    authorization = Constraint.Authorization.FORBIDDEN;
                    break;
                }
                case ALLOWED: {
                    if (authorizationA == Constraint.Authorization.FORBIDDEN) {
                        authorization = Constraint.Authorization.FORBIDDEN;
                        break;
                    }
                    authorization = Constraint.Authorization.ALLOWED;
                    break;
                }
                case ANY_USER: {
                    if (authorizationA == Constraint.Authorization.FORBIDDEN || authorizationA == Constraint.Authorization.ALLOWED) {
                        authorization = authorizationA;
                        break;
                    }
                    authorization = Constraint.Authorization.ANY_USER;
                    break;
                }
                case KNOWN_ROLE: {
                    if (authorizationA == Constraint.Authorization.KNOWN_ROLE || authorizationA == Constraint.Authorization.SPECIFIC_ROLE) {
                        authorization = Constraint.Authorization.KNOWN_ROLE;
                        break;
                    }
                    authorization = authorizationA;
                    break;
                }
                case SPECIFIC_ROLE: {
                    if (authorizationA == Constraint.Authorization.SPECIFIC_ROLE) {
                        roles = Stream.concat(constraintA.getRoles().stream(), constraintB.getRoles().stream()).collect(Collectors.toSet());
                    }
                    authorization = authorizationA;
                    break;
                }
                case INHERIT: {
                    authorization = authorizationA;
                }
            }
        }
        Constraint.Authorization authorization2 = authorization;
        Constraint.Transport transportA = constraintA.getTransport();
        Constraint.Transport transportB = constraintB.getTransport();
        Constraint.Transport transport = Constraint.Transport.SECURE.equals((Object)transportA) && Constraint.Transport.SECURE.equals((Object)transportB) ? Constraint.Transport.SECURE : Constraint.Transport.ANY;
        return Constraint.from(constraintA.getName() + "|" + constraintB.getName(), transport, authorization2, roles);
    }

    protected void processConstraintMapping(ConstraintMapping mapping) {
        Constraint constraint;
        Constraint allMethodsConstraint;
        Map<String, Constraint> mappings = this._constraintsByPathAndMethod.get(PathSpec.from(mapping.getPathSpec()));
        if (mappings == null) {
            mappings = new HashMap<String, Constraint>();
            this._constraintsByPathAndMethod.put(mapping.getPathSpec(), mappings);
        }
        if ((allMethodsConstraint = mappings.get("*")) != null && allMethodsConstraint.getAuthorization() == Constraint.Authorization.FORBIDDEN) {
            return;
        }
        if (mapping.getMethodOmissions() != null && mapping.getMethodOmissions().length > 0) {
            this.processConstraintMappingWithMethodOmissions(mapping, mappings);
            return;
        }
        String httpMethod = mapping.getMethod();
        if (httpMethod == null) {
            httpMethod = "*";
        }
        if ((constraint = mappings.get(httpMethod)) == null) {
            constraint = allMethodsConstraint;
        }
        if (constraint != null && constraint.getAuthorization() == Constraint.Authorization.FORBIDDEN) {
            return;
        }
        if ((constraint = this.combineServletConstraints(constraint, mapping.getConstraint())).getAuthorization() == Constraint.Authorization.FORBIDDEN && httpMethod.equals("*")) {
            mappings.clear();
            mappings.put("*", constraint);
        } else {
            mappings.put(httpMethod, constraint);
        }
    }

    protected void processConstraintMappingWithMethodOmissions(ConstraintMapping mapping, Map<String, Constraint> mappings) {
        String[] omissions = mapping.getMethodOmissions();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < omissions.length; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(omissions[i]);
        }
        sb.append(OMISSION_SUFFIX);
        mappings.put(sb.toString(), mapping.getConstraint());
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, DumpableCollection.from("roles", this._roles), DumpableCollection.from("constraints", this._constraintMappings));
    }

    @Override
    public void setDenyUncoveredHttpMethods(boolean deny) {
        this._denyUncoveredMethods = deny;
    }

    @Override
    public boolean isDenyUncoveredHttpMethods() {
        return this._denyUncoveredMethods;
    }

    @Override
    public boolean checkPathsWithUncoveredHttpMethods() {
        Set<String> paths = this.getPathsWithUncoveredHttpMethods();
        if (paths != null && !paths.isEmpty()) {
            LOG.warn("{} has uncovered HTTP methods for the following paths: {}", (Object)ContextHandler.getCurrentContext(), (Object)paths);
            return true;
        }
        return false;
    }

    public Set<String> getPathsWithUncoveredHttpMethods() {
        if (this._denyUncoveredMethods) {
            return Collections.emptySet();
        }
        HashSet<String> uncoveredPaths = new HashSet<String>();
        for (MappedResource<Map<String, Constraint>> mappedResource : this._constraintsByPathAndMethod) {
            String path = mappedResource.getPathSpec().getDeclaration();
            Map<String, Constraint> methodMappings = mappedResource.getResource();
            if (methodMappings.get("*") != null) continue;
            boolean hasOmissions = this.omissionsExist(methodMappings);
            for (String method : methodMappings.keySet()) {
                if (method.endsWith(OMISSION_SUFFIX)) {
                    Set<String> omittedMethods = this.getOmittedMethods(method);
                    for (String m : omittedMethods) {
                        if (methodMappings.containsKey(m)) continue;
                        uncoveredPaths.add(path);
                    }
                    continue;
                }
                if (hasOmissions) continue;
                uncoveredPaths.add(path);
            }
        }
        return uncoveredPaths;
    }

    protected boolean omissionsExist(Map<String, Constraint> methodMappings) {
        if (methodMappings == null) {
            return false;
        }
        for (String m : methodMappings.keySet()) {
            if (!m.endsWith(OMISSION_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    protected Set<String> getOmittedMethods(String omission) {
        if (omission == null || !omission.endsWith(OMISSION_SUFFIX)) {
            return Collections.emptySet();
        }
        String[] strings = omission.split("\\.");
        return new HashSet<String>(Arrays.asList(strings).subList(0, strings.length - 1));
    }

    private boolean isInDurableState() {
        ServletContextHandler contextHandler = ServletContextHandler.getCurrentServletContextHandler();
        Server server = this.getServer();
        return contextHandler == null && server == null || contextHandler != null && !contextHandler.isRunning() || contextHandler == null && !server.isRunning();
    }
}

