/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.ImportTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.Scope;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class StaticImport {
    public static List<ErrorDescription> run(HintContext ctx) {
        Element enclosingEl;
        CompilationInfo info = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        Element e = info.getTrees().getElement(treePath);
        EnumSet<ElementKind> supportedTypes = EnumSet.of(ElementKind.METHOD, ElementKind.ENUM_CONSTANT, ElementKind.FIELD);
        if (e == null || !e.getModifiers().contains((Object)Modifier.STATIC) || !supportedTypes.contains((Object)e.getKind())) {
            return null;
        }
        if (ElementKind.METHOD == e.getKind()) {
            TreePath mitp = treePath.getParentPath();
            if (mitp == null || mitp.getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
                return null;
            }
            if (((MethodInvocationTree)mitp.getLeaf()).getMethodSelect() != treePath.getLeaf()) {
                return null;
            }
            List<? extends Tree> typeArgs = ((MethodInvocationTree)mitp.getLeaf()).getTypeArguments();
            if (typeArgs != null && !typeArgs.isEmpty()) {
                return null;
            }
        }
        if ((enclosingEl = e.getEnclosingElement()) == null) {
            return null;
        }
        String sn = e.getSimpleName().toString();
        if (SourceVersion.isKeyword(sn)) {
            return null;
        }
        TreePath cc = StaticImport.getContainingClass(treePath);
        if (cc == null) {
            return null;
        }
        Element klass = info.getTrees().getElement(cc);
        if (klass == null || klass.getKind() != ElementKind.CLASS) {
            return null;
        }
        String fqn = null;
        String fqn1 = StaticImport.getFqn(info, e);
        if (!StaticImport.isSubTypeOrInnerOfSubType(info, klass, enclosingEl) && !StaticImport.isStaticallyImported(info, fqn1)) {
            if (StaticImport.hasMethodNameClash(info, klass, sn) || StaticImport.hasStaticImportSimpleNameClash(info, sn)) {
                return null;
            }
            fqn = fqn1;
        }
        Scope currentScope = info.getTrees().getScope(treePath);
        TypeMirror enclosingType = e.getEnclosingElement().asType();
        if (enclosingType == null || enclosingType.getKind() != TypeKind.DECLARED || !info.getTrees().isAccessible(currentScope, e, (DeclaredType)enclosingType)) {
            return null;
        }
        String desc = NbBundle.getMessage(StaticImport.class, "ERR_StaticImport");
        ErrorDescription ed = ErrorDescriptionFactory.forTree(ctx, treePath, desc, new FixImpl(TreePathHandle.create(treePath, info), fqn, sn).toEditorFix());
        if (ctx.isCanceled()) {
            return null;
        }
        return Collections.singletonList(ed);
    }

    private static boolean supportsStaticImports(CompilationInfo info) {
        return info.getSourceVersion().compareTo(SourceVersion.RELEASE_5) >= 0;
    }

    private static boolean hasMethodWithSimpleName(CompilationInfo info, Element element, final String sn) {
        Iterable<? extends Element> members = info.getElementUtilities().getMembers(element.asType(), new ElementUtilities.ElementAcceptor(){

            @Override
            public boolean accept(Element e, TypeMirror type) {
                return e.getKind() == ElementKind.METHOD && e.getSimpleName().toString().equals(sn);
            }
        });
        return members.iterator().hasNext();
    }

    private static boolean hasStaticImportSimpleNameClash(CompilationInfo info, String simpleName) {
        for (ImportTree importTree : info.getCompilationUnit().getImports()) {
            if (!importTree.isStatic()) continue;
            String q = importTree.getQualifiedIdentifier().toString();
            if (q.endsWith(".*")) {
                TypeElement ie = info.getElements().getTypeElement(q.substring(0, q.length() - 2));
                if (ie == null) continue;
                for (Element element : ie.getEnclosedElements()) {
                    String sn1;
                    Set<Modifier> modifiers = element.getModifiers();
                    if (element.getKind() != ElementKind.METHOD || !modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE) || !simpleName.equals(sn1 = element.getSimpleName().toString())) continue;
                    return true;
                }
                continue;
            }
            int endIndex = q.lastIndexOf(".");
            if (endIndex == -1 || endIndex >= q.length() - 1 || !q.substring(endIndex).equals(simpleName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSubTypeOrInnerOfSubType(CompilationInfo info, Element t1, Element t2) {
        boolean isSubtype = info.getTypes().isSubtype(t1.asType(), t2.asType());
        boolean isInnerClass = t1.getEnclosingElement().getKind() == ElementKind.CLASS;
        return isSubtype || isInnerClass && info.getTypes().isSubtype(t1.getEnclosingElement().asType(), t2.asType());
    }

    private static boolean hasMethodNameClash(CompilationInfo info, Element klass, String simpleName) {
        assert (klass != null);
        assert (klass.getKind() == ElementKind.CLASS);
        if (StaticImport.hasMethodWithSimpleName(info, klass, simpleName)) {
            return true;
        }
        Element klassEnclosing = klass.getEnclosingElement();
        return klassEnclosing != null && klassEnclosing.getKind() == ElementKind.CLASS && StaticImport.hasMethodWithSimpleName(info, klassEnclosing, simpleName);
    }

    private static String getFqn(CompilationInfo info, Element e) {
        return info.getElementUtilities().getElementName(e.getEnclosingElement(), true) + "." + e.getSimpleName();
    }

    private static TreePath getContainingClass(TreePath tp) {
        while (tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
            tp = tp.getParentPath();
        }
        return tp;
    }

    private static boolean isStaticallyImported(CompilationInfo info, String fqn) {
        for (ImportTree importTree : info.getCompilationUnit().getImports()) {
            if (!importTree.isStatic()) continue;
            String q = importTree.getQualifiedIdentifier().toString();
            if (q.endsWith(".*") && fqn.startsWith(q.substring(0, q.length() - 1))) {
                return true;
            }
            if (!q.equals(fqn)) continue;
            return true;
        }
        return false;
    }

    public static final class FixImpl
    extends JavaFix {
        private final String fqn;
        private final String sn;

        public FixImpl(TreePathHandle handle, String fqn, String sn) {
            super(handle, "\uffffa");
            this.fqn = fqn;
            this.sn = sn;
        }

        @Override
        public String getText() {
            if (this.fqn == null) {
                return NbBundle.getMessage(StaticImport.class, "HINT_StaticImport", this.sn);
            }
            return NbBundle.getMessage(StaticImport.class, "HINT_StaticImport2", this.fqn);
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath treePath = ctx.getPath();
            TreePath mitp = treePath.getParentPath();
            if (mitp == null) {
                return;
            }
            Element e = copy.getTrees().getElement(treePath);
            if (e == null || !e.getModifiers().contains((Object)Modifier.STATIC)) {
                return;
            }
            TreeMaker make = copy.getTreeMaker();
            copy.rewrite(treePath.getLeaf(), make.Identifier(this.sn));
            if (this.fqn == null) {
                return;
            }
            CompilationUnitTree cut = (CompilationUnitTree)copy.resolveRewriteTarget(copy.getCompilationUnit());
            CompilationUnitTree nue = GeneratorUtilities.get(copy).addImports(cut, Collections.singleton(e));
            copy.rewrite(cut, nue);
        }
    }
}

