/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.mysql;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParserContext;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.parser.PeekingReader;
import org.flywaydb.core.internal.parser.StatementType;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;

public class MySQLParser
extends Parser {
    private static final char ALTERNATIVE_SINGLE_LINE_COMMENT = '#';
    private static final Pattern STORED_PROGRAM_REGEX = Pattern.compile("^CREATE\\s(((DEFINER\\s(\\w+\\s)?@\\s(\\w+\\s)?)?(PROCEDURE|FUNCTION|EVENT))|TRIGGER)", 2);
    private static final StatementType STORED_PROGRAM_STATEMENT = new StatementType();

    public MySQLParser(Configuration configuration, ParsingContext parsingContext) {
        super(configuration, parsingContext, 8);
    }

    protected void resetDelimiter(ParserContext context) {
    }

    protected Token handleKeyword(PeekingReader reader, ParserContext context, int pos, int line, int col, String keyword) throws IOException {
        if ("DELIMITER".equalsIgnoreCase(keyword)) {
            String text = "";
            while (text.isEmpty()) {
                text = reader.readUntilExcluding('\n', '\r').trim();
                reader.swallow(1);
            }
            return new Token(TokenType.NEW_DELIMITER, pos, line, col, text, text, context.getParensDepth());
        }
        return super.handleKeyword(reader, context, pos, line, col, keyword);
    }

    protected char getIdentifierQuote() {
        return '`';
    }

    protected char getAlternativeStringLiteralQuote() {
        return '\"';
    }

    protected boolean isSingleLineComment(String peek, ParserContext context, int col) {
        return super.isSingleLineComment(peek, context, col) || peek.charAt(0) == '#' && !this.isDelimiter(peek, context, col, 0);
    }

    protected Token handleStringLiteral(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        reader.swallow();
        reader.swallowUntilIncludingWithEscape('\'', true, '\\');
        return new Token(TokenType.STRING, pos, line, col, null, null, context.getParensDepth());
    }

    protected Token handleAlternativeStringLiteral(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        reader.swallow();
        reader.swallowUntilIncludingWithEscape('\"', true, '\\');
        return new Token(TokenType.STRING, pos, line, col, null, null, context.getParensDepth());
    }

    protected Token handleCommentDirective(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        reader.swallow(2);
        String text = reader.readUntilExcluding(new String[]{"*/"});
        reader.swallow(2);
        return new Token(TokenType.MULTI_LINE_COMMENT_DIRECTIVE, pos, line, col, text, text, context.getParensDepth());
    }

    protected boolean isCommentDirective(String text) {
        return text.length() >= 8 && text.charAt(0) == '/' && text.charAt(1) == '*' && text.charAt(2) == '!' && Character.isDigit(text.charAt(3)) && Character.isDigit(text.charAt(4)) && Character.isDigit(text.charAt(5)) && Character.isDigit(text.charAt(6)) && Character.isDigit(text.charAt(7));
    }

    protected StatementType detectStatementType(String simplifiedStatement, ParserContext context, PeekingReader reader) {
        if (STORED_PROGRAM_REGEX.matcher(simplifiedStatement).matches()) {
            return STORED_PROGRAM_STATEMENT;
        }
        return super.detectStatementType(simplifiedStatement, context, reader);
    }

    protected boolean shouldAdjustBlockDepth(ParserContext context, List<Token> tokens, Token token) {
        return token.getParensDepth() == 0;
    }

    protected void adjustBlockDepth(ParserContext context, List<Token> tokens, Token keyword, PeekingReader reader) {
        String keywordText = keyword.getText();
        int parensDepth = keyword.getParensDepth();
        if ("BEGIN".equalsIgnoreCase(keywordText) && context.getStatementType() == STORED_PROGRAM_STATEMENT) {
            context.increaseBlockDepth("");
        }
        if ("CASE".equalsIgnoreCase(keywordText) && !MySQLParser.lastTokenIs(tokens, (int)parensDepth, (String)"END")) {
            context.increaseBlockDepth("");
        }
        if (!(context.getBlockDepth() <= 0 || !MySQLParser.lastTokenIs(tokens, (int)parensDepth, (String)"END") || "IF".equalsIgnoreCase(keywordText) || "LOOP".equalsIgnoreCase(keywordText) || "REPEAT".equalsIgnoreCase(keywordText) || "WHILE".equalsIgnoreCase(keywordText))) {
            context.decreaseBlockDepth();
        }
    }
}

