/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.runtime;

import java.lang.reflect.Method;
import org.apache.nifi.util.NiFiBootstrapPropertiesLoader;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertiesProvider {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesProvider.class);
    private static final String LOADER_CLASS = "org.apache.nifi.properties.NiFiPropertiesLoader";
    private static final String GET_METHOD = "get";

    PropertiesProvider() {
    }

    static NiFiProperties readProperties() {
        NiFiBootstrapPropertiesLoader bootstrapPropertiesLoader = new NiFiBootstrapPropertiesLoader();
        String propertiesFilePath = bootstrapPropertiesLoader.getDefaultApplicationPropertiesFilePath();
        logger.info("Loading Application Properties [{}]", (Object)propertiesFilePath);
        return NiFiProperties.createBasicNiFiProperties((String)propertiesFilePath);
    }

    static NiFiProperties readProperties(ClassLoader propertiesClassLoader) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(propertiesClassLoader);
        try {
            Class<?> loaderClass = Class.forName(LOADER_CLASS, true, propertiesClassLoader);
            Object loader = loaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method getMethod = loaderClass.getMethod(GET_METHOD, new Class[0]);
            NiFiProperties niFiProperties = (NiFiProperties)getMethod.invoke(loader, new Object[0]);
            return niFiProperties;
        }
        catch (Exception e) {
            throw new IllegalStateException("Application Properties loading failed", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }
}

