/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.CLICompleter;
import org.apache.nifi.toolkit.cli.api.Command;
import org.apache.nifi.toolkit.cli.api.CommandGroup;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.api.Session;
import org.apache.nifi.toolkit.cli.impl.client.NiFiClientFactory;
import org.apache.nifi.toolkit.cli.impl.client.NiFiRegistryClientFactory;
import org.apache.nifi.toolkit.cli.impl.command.CommandFactory;
import org.apache.nifi.toolkit.cli.impl.command.CommandProcessor;
import org.apache.nifi.toolkit.cli.impl.context.StandardContext;
import org.apache.nifi.toolkit.cli.impl.session.InMemorySession;
import org.apache.nifi.toolkit.cli.impl.session.PersistentSession;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class CLIMain {
    public static final String SHELL_NAME = "nifi-registry";
    public static final String PROMPT = "#> ";
    public static final String BANNER_FILE = "nifi-banner.txt";
    public static final String SESSION_PERSISTENCE_FILE = ".nifi-cli.config";

    public static void main(String[] args) throws IOException {
        if (args == null || args.length == 0) {
            CLIMain.runInteractiveCLI();
        } else {
            try {
                int returnCode = CLIMain.runSingleCommand(args);
                System.exit(returnCode);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    private static void runInteractiveCLI() throws IOException {
        try (Terminal terminal = TerminalBuilder.builder().name(SHELL_NAME).system(true).nativeSignals(true).signalHandler(Terminal.SignalHandler.SIG_IGN).build();){
            PrintStream output = new PrintStream(terminal.output(), true);
            try {
                CLIMain.printHeader(BANNER_FILE, output);
                Context context = CLIMain.createContext(output, true);
                Map<String, Command> topLevelCommands = CommandFactory.createTopLevelCommands(context);
                Map<String, CommandGroup> commandGroups = CommandFactory.createCommandGroups(context);
                CommandProcessor commandProcessor = new CommandProcessor(topLevelCommands, commandGroups, context);
                CLICompleter completer = new CLICompleter(topLevelCommands.values(), commandGroups.values());
                LineReader reader = LineReaderBuilder.builder().appName(SHELL_NAME).terminal(terminal).completer((Completer)completer).build();
                reader.setOpt(LineReader.Option.AUTO_FRESH_LINE);
                reader.unsetOpt(LineReader.Option.INSERT_TAB);
                while (true) {
                    try {
                        while (true) {
                            String line;
                            if (StringUtils.isBlank((CharSequence)(line = reader.readLine(PROMPT)))) {
                                continue;
                            }
                            ParsedLine parsedLine = reader.getParsedLine();
                            String[] parsedArgs = parsedLine.words().toArray(new String[parsedLine.words().size()]);
                            commandProcessor.process(parsedArgs);
                        }
                    }
                    catch (UserInterruptException line) {
                        continue;
                    }
                    catch (EndOfFileException e) {
                        output.close();
                        return;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static int runSingleCommand(String[] args) {
        Context context = CLIMain.createContext(System.out, false);
        Map<String, Command> topLevelCommands = CommandFactory.createTopLevelCommands(context);
        Map<String, CommandGroup> commandGroups = CommandFactory.createCommandGroups(context);
        CommandProcessor commandProcessor = new CommandProcessor(topLevelCommands, commandGroups, context);
        return commandProcessor.process(args);
    }

    private static Context createContext(PrintStream output, boolean isInteractive) {
        Session session;
        block7: {
            String userHomeValue = System.getProperty("user.home");
            File userHome = Paths.get(userHomeValue, new String[0]).toFile();
            if (!(userHome.exists() && userHome.canRead() && userHome.canWrite())) {
                session = new InMemorySession();
                if (isInteractive) {
                    output.println();
                    output.println("Unable to create session from " + userHomeValue + ", falling back to in-memory session");
                    output.println();
                }
            } else {
                InMemorySession inMemorySession = new InMemorySession();
                File sessionState = new File(userHome.getAbsolutePath(), SESSION_PERSISTENCE_FILE);
                try {
                    if (!sessionState.exists()) {
                        sessionState.createNewFile();
                    }
                    PersistentSession persistentSession = new PersistentSession(sessionState, inMemorySession);
                    persistentSession.loadSession();
                    session = persistentSession;
                    if (isInteractive) {
                        output.println();
                        output.println("Session loaded from " + sessionState.getAbsolutePath());
                        output.println();
                    }
                }
                catch (Exception e) {
                    session = inMemorySession;
                    if (!isInteractive) break block7;
                    output.println();
                    output.println("Unable to load session from " + sessionState.getAbsolutePath() + ", falling back to in-memory session");
                    output.println();
                }
            }
        }
        NiFiClientFactory niFiClientFactory = new NiFiClientFactory();
        NiFiRegistryClientFactory nifiRegClientFactory = new NiFiRegistryClientFactory();
        return new StandardContext.Builder().output(output).session(session).nifiClientFactory(niFiClientFactory).nifiRegistryClientFactory(nifiRegClientFactory).interactive(isInteractive).build();
    }

    protected static void printHeader(String bannerFile, PrintStream output) throws IOException {
        try (InputStream bannerInput = CLIMain.class.getClassLoader().getResourceAsStream(bannerFile);){
            String bannerContent = IOUtils.toString((InputStream)bannerInput, (Charset)StandardCharsets.UTF_8);
            output.println(bannerContent);
            output.println();
            output.println("Type 'help' to see a list of available commands, use tab to auto-complete.");
            output.println();
        }
    }
}

