/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.command;

import java.io.IOException;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.Status;
import org.apache.nifi.minifi.bootstrap.command.CommandRunner;
import org.apache.nifi.minifi.bootstrap.service.CurrentPortProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiCommandSender;
import org.slf4j.Logger;

public class EnvRunner
implements CommandRunner {
    protected static final String ENV_CMD = "ENV";
    private final MiNiFiCommandSender miNiFiCommandSender;
    private final CurrentPortProvider currentPortProvider;

    public EnvRunner(MiNiFiCommandSender miNiFiCommandSender, CurrentPortProvider currentPortProvider) {
        this.miNiFiCommandSender = miNiFiCommandSender;
        this.currentPortProvider = currentPortProvider;
    }

    @Override
    public int runCommand(String[] args) {
        return this.env();
    }

    private int env() {
        Integer port = this.currentPortProvider.getCurrentPort();
        if (port == null) {
            RunMiNiFi.CMD_LOGGER.error("Apache MiNiFi is not currently running");
            return Status.MINIFI_NOT_RUNNING.getStatusCode();
        }
        try {
            this.miNiFiCommandSender.sendCommand(ENV_CMD, port, new String[0]).ifPresent(arg_0 -> ((Logger)RunMiNiFi.CMD_LOGGER).info(arg_0));
        }
        catch (IOException e) {
            RunMiNiFi.CMD_LOGGER.error("Failed to get ENV response from MiNiFi");
            RunMiNiFi.DEFAULT_LOGGER.error("Exception:", (Throwable)e);
            return Status.ERROR.getStatusCode();
        }
        return Status.OK.getStatusCode();
    }
}

