/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.oauth2;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.oauth2.OAuth2AuthenticationProvider;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;

public class OAuth2Negotiator
implements SaslNegotiator {
    public static final String MECHANISM = "XOAUTH2";
    private static final String BEARER_PREFIX = "Bearer ";
    private final NamedAddressSpace _addressSpace;
    private final OAuth2AuthenticationProvider<?> _authenticationProvider;
    private volatile State _state = State.INITIAL;

    public OAuth2Negotiator(OAuth2AuthenticationProvider<?> authenticationProvider, NamedAddressSpace addressSpace) {
        this._authenticationProvider = authenticationProvider;
        this._addressSpace = addressSpace;
    }

    @Override
    public AuthenticationResult handleResponse(byte[] response) {
        if (this._state == State.COMPLETE) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, new IllegalStateException("Multiple Authentications not permitted."));
        }
        if (this._state == State.INITIAL && (response == null || response.length == 0)) {
            this._state = State.CHALLENGE_SENT;
            return new AuthenticationResult(new byte[0], AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        this._state = State.COMPLETE;
        if (response == null || response.length == 0) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, new IllegalArgumentException("Invalid OAuth2 client response."));
        }
        Map<String, String> responsePairs = this.splitResponse(response);
        String auth = responsePairs.get("auth");
        if (auth != null) {
            if (auth.startsWith(BEARER_PREFIX)) {
                return this._authenticationProvider.authenticateViaAccessToken(auth.substring(BEARER_PREFIX.length()), this._addressSpace);
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, new IllegalArgumentException("The 'auth' part of response does not not begin with the expected prefix"));
        }
        return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, new IllegalArgumentException("The mandatory 'auth' part of the response was absent."));
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getAttemptedAuthenticationId() {
        return null;
    }

    private Map<String, String> splitResponse(byte[] response) {
        String[] splitResponse = new String(response, StandardCharsets.US_ASCII).split("\u0001");
        HashMap<String, String> responseItems = new HashMap<String, String>(splitResponse.length);
        for (String nameValue : splitResponse) {
            String[] nameValueSplit;
            if (nameValue.length() <= 0 || (nameValueSplit = nameValue.split("=", 2)).length != 2) continue;
            responseItems.put(nameValueSplit[0], nameValueSplit[1]);
        }
        return responseItems;
    }

    static enum State {
        INITIAL,
        CHALLENGE_SENT,
        COMPLETE;

    }
}

