/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.qpid.server.security.access.config.AclRulePredicates;
import org.apache.qpid.server.security.access.config.AclRulePredicatesBuilder;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.config.Property;
import org.apache.qpid.server.security.access.config.RulePredicate;
import org.apache.qpid.server.security.access.firewall.FirewallRuleFactory;
import org.apache.qpid.server.security.access.plugins.AclRule;
import org.apache.qpid.server.security.access.plugins.RuleOutcome;

public class Rule {
    public static final String ALL = "all";
    public static final String OWNER = "owner";
    private final String _identity;
    private final LegacyOperation _operation;
    private final ObjectType _object;
    private final AclRulePredicates _predicates;
    private final RuleOutcome _ruleOutcome;
    private final RulePredicate _rulePredicate;
    private final boolean _isOwner;
    private final boolean _isAll;

    public Rule(AclRule rule) {
        this(rule.getIdentity(), rule.getOperation(), rule.getObjectType(), new AclRulePredicatesBuilder(rule.getAttributes()).build(), rule.getOutcome());
    }

    Rule(String identity, LegacyOperation operation, ObjectType object, AclRulePredicates predicates, RuleOutcome ruleOutcome) {
        this._identity = Objects.requireNonNull(identity);
        this._operation = Objects.requireNonNull(operation);
        this._object = Objects.requireNonNull(object);
        this._ruleOutcome = Objects.requireNonNull(ruleOutcome);
        this._predicates = Objects.requireNonNull(predicates);
        this._rulePredicate = Objects.requireNonNull(predicates.asSinglePredicate());
        this._isOwner = OWNER.equalsIgnoreCase(identity);
        this._isAll = ALL.equalsIgnoreCase(identity);
    }

    public boolean isForAll() {
        return this._isAll;
    }

    public boolean isForOwner() {
        return this._isOwner;
    }

    public boolean isForOwnerOrAll() {
        return this._isOwner || this._isAll;
    }

    public String getIdentity() {
        return this._identity;
    }

    AclRulePredicates getPredicates() {
        return this._predicates;
    }

    public RuleOutcome getOutcome() {
        return this._ruleOutcome;
    }

    public boolean matches(LegacyOperation actionOperation, ObjectType actionObjectType, ObjectProperties actionObjectProperties, Subject subject) {
        return this.operationsMatch(actionOperation) && this.objectTypesMatch(actionObjectType) && this.predicatesMatch(actionOperation, actionObjectProperties, subject);
    }

    public boolean predicatesMatch(LegacyOperation operation, ObjectProperties objectProperties, Subject subject) {
        return this._rulePredicate.matches(operation, objectProperties, subject);
    }

    public boolean anyPropertiesMatch() {
        return this._rulePredicate.matchesAny();
    }

    private boolean operationsMatch(LegacyOperation actionOperation) {
        return LegacyOperation.ALL == this.getOperation() || this.getOperation() == actionOperation;
    }

    private boolean objectTypesMatch(ObjectType actionObjectType) {
        return ObjectType.ALL == this.getObjectType() || this.getObjectType() == actionObjectType;
    }

    public LegacyOperation getOperation() {
        return this._operation;
    }

    public ObjectType getObjectType() {
        return this._object;
    }

    public Map<Property, Object> getAttributes() {
        return this._predicates.getParsedProperties();
    }

    public AclRule asAclRule() {
        return new AclRuleImpl(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == this.getClass()) {
            Rule rule = (Rule)o;
            return this.getIdentity().equalsIgnoreCase(rule.getIdentity()) && this.getOperation() == rule.getOperation() && this.getObjectType() == rule.getObjectType() && this.getPredicates().equals(rule.getPredicates()) && this.getOutcome() == rule.getOutcome();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getIdentity(), this.getOperation(), this.getObjectType(), this.getPredicates(), this.getOutcome()});
    }

    public String toString() {
        return "Rule[identity='" + this._identity + "'action=Action[operation=" + String.valueOf((Object)this._operation) + ", object=" + String.valueOf((Object)this._object) + ", predicates=" + String.valueOf(this._predicates) + "], permission=" + String.valueOf((Object)this._ruleOutcome) + "]";
    }

    private static final class AclRuleImpl
    implements AclRule {
        private final Rule _rule;

        AclRuleImpl(Rule rule) {
            this._rule = Objects.requireNonNull(rule);
        }

        @Override
        public String getIdentity() {
            return this._rule.getIdentity();
        }

        @Override
        public ObjectType getObjectType() {
            return this._rule.getObjectType();
        }

        @Override
        public LegacyOperation getOperation() {
            return this._rule.getOperation();
        }

        @Override
        public Map<Property, Object> getAttributes() {
            return this._rule.getAttributes();
        }

        @Override
        public RuleOutcome getOutcome() {
            return this._rule.getOutcome();
        }
    }

    public static final class Builder {
        private String _identity = "all";
        private LegacyOperation _operation = LegacyOperation.ALL;
        private ObjectType _object = ObjectType.ALL;
        private RuleOutcome _outcome = RuleOutcome.DENY_LOG;
        private final AclRulePredicatesBuilder _aclRulePredicatesBuilder = new AclRulePredicatesBuilder();

        public Builder withIdentity(String identity) {
            this._identity = Objects.requireNonNull(identity);
            return this;
        }

        public Builder withOperation(LegacyOperation operation) {
            this._operation = Objects.requireNonNull(operation);
            return this;
        }

        public Builder withObject(ObjectType object) {
            this._object = Objects.requireNonNull(object);
            return this;
        }

        public Builder withOutcome(RuleOutcome outcome) {
            this._outcome = Objects.requireNonNull(outcome);
            return this;
        }

        public Builder withPredicate(String key, String value) {
            this._aclRulePredicatesBuilder.parse(key, value);
            return this;
        }

        public Builder withPredicate(Property key, String value) {
            this._aclRulePredicatesBuilder.put(key, value);
            return this;
        }

        public Builder withPredicate(String key, Set<String> values) {
            this._aclRulePredicatesBuilder.parse(key, values);
            return this;
        }

        public Builder withOwner() {
            this._identity = Rule.OWNER;
            return this;
        }

        public Builder withPredicates(ObjectProperties properties) {
            for (Map.Entry<Property, Object> entry : properties.getAll().entrySet()) {
                this._aclRulePredicatesBuilder.put(entry.getKey(), entry.getValue().toString());
            }
            for (String name : properties.getAttributeNames()) {
                this._aclRulePredicatesBuilder.put(Property.ATTRIBUTES, name);
            }
            return this;
        }

        public Rule build() {
            this.validate();
            return new Rule(this._identity, this._operation, this._object, this._aclRulePredicatesBuilder.build(), this._outcome);
        }

        public Rule build(FirewallRuleFactory firewallRuleFactory) {
            this.validate();
            return new Rule(this._identity, this._operation, this._object, this._aclRulePredicatesBuilder.build(firewallRuleFactory), this._outcome);
        }

        private void validate() {
            if (!this._object.isSupported(this._operation)) {
                throw new IllegalArgumentException(String.format("Operation %s  is not allowed for %s", new Object[]{this._operation, this._object}));
            }
        }
    }
}

