# dgrid Documentation

This folder contains the official dgrid documentation. It includes
information on dgrid's core components, mixins, and extensions that are
available to further expand dgrid's functionality.

## Components

* Core Components
    * [List](components/core-components/List.md)
    * [Grid](components/core-components/Grid.md)
    * [GridFromHtml](components/core-components/GridFromHtml.md)
    * [OnDemandList and OnDemandGrid](components/core-components/OnDemandList-and-OnDemandGrid.md)
* Mixins
    * [Keyboard](components/mixins/Keyboard.md)
    * [ColumnSet](components/mixins/ColumnSet.md)
    * [Selection](components/mixins/Selection.md)
    * [Selector](components/mixins/Selector.md)
    * [CellSelection](components/mixins/CellSelection.md)
    * [Editor](components/mixins/Editor.md)
    * [Tree](components/mixins/Tree.md)
* Extensions
    * [ColumnReorder](components/extensions/ColumnReorder.md)
    * [ColumnResizer](components/extensions/ColumnResizer.md)
    * [ColumnHider](components/extensions/ColumnHider.md)
    * [CompoundColumns](components/extensions/CompoundColumns.md)
    * [Pagination](components/extensions/Pagination.md)
    * [SingleQuery](components/extensions/SingleQuery.md)
    * [DijitRegistry](components/extensions/DijitRegistry.md)
    * [DnD](components/extensions/DnD.md)
* Utilities
    * [touch](components/utilities/touch.md)
    * [misc](components/utilities/misc.md)

## Usage

* [Working with Events](usage/Working-with-Events.md)
* [Working with Widgets](usage/Working-with-Widgets.md)
* [Styling dgrid](usage/Styling-dgrid.md)
* [Customizing Skins](usage/Customizing-Skins.md)
* [Limitations](usage/Limitations.md)

## Upgrading dgrid

* [0.4 Migration Guide](migrating/0.4-Migration.md)
* Migrating from 0.4 to 1.0 is generally straightforward;
  see the [dgrid 1.0 Release Notes](https://github.com/SitePen/dgrid/releases/tag/v1.0.0).

## Migrating from dojox/grid

* [API Comparison](migrating/API-Comparison.md)
* [Usage Comparison](migrating/Usage-Comparison.md)

## Tutorials

Various tutorials are available on [dgrid.io](http://dgrid.io/#tutorials).
