/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.VersionedWriteLoggable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;

public enum DbOperationType implements VersionedWriteLoggable
{
    NONE(0),
    CREATE(1),
    REMOVE(2),
    TRUNCATE(3),
    RENAME(4),
    UPDATE_CONFIG(5);

    private static final int LAST_FORMAT_CHANGE = 8;
    private byte value;

    private DbOperationType(byte value) {
        this.value = value;
    }

    public static DbOperationType readTypeFromLog(ByteBuffer entryBuffer, int entryVersion) {
        byte opVal = entryBuffer.get();
        switch (opVal) {
            case 1: {
                return CREATE;
            }
            case 2: {
                return REMOVE;
            }
            case 3: {
                return TRUNCATE;
            }
            case 4: {
                return RENAME;
            }
            case 5: {
                return UPDATE_CONFIG;
            }
        }
        return NONE;
    }

    @Override
    public int getLastFormatChange() {
        return 8;
    }

    @Override
    public Collection<VersionedWriteLoggable> getEmbeddedLoggables() {
        return Collections.emptyList();
    }

    @Override
    public int getLogSize() {
        return this.getLogSize(14, false);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        this.writeToLog(logBuffer, 14, false);
    }

    @Override
    public int getLogSize(int logVersion, boolean forReplication) {
        return 1;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer, int logVersion, boolean forReplication) {
        logBuffer.put(this.value);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        this.value = itemBuffer.get();
    }

    @Override
    public boolean hasReplicationFormat() {
        return false;
    }

    @Override
    public boolean isReplicationFormatWorthwhile(ByteBuffer logBuffer, int srcVersion, int destVersion) {
        return false;
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<DbOp val=\"").append(this).append("\"/>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof DbOperationType)) {
            return false;
        }
        return this.value == ((DbOperationType)other).value;
    }

    public static boolean isWriteConfigType(DbOperationType opType) {
        return opType == CREATE || opType == UPDATE_CONFIG;
    }
}

