/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.kerberos;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.security.auth.sasl.AbstractSaslServerNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosNegotiator
extends AbstractSaslServerNegotiator
implements SaslNegotiator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KerberosNegotiator.class);
    private final SaslServer _saslServer;
    private final AuthenticationProvider<?> _authenticationProvider;
    private final SaslException _exception;

    public KerberosNegotiator(AuthenticationProvider<?> authenticationProvider, String localFQDN) {
        this._authenticationProvider = authenticationProvider;
        SaslServer saslServer = null;
        SaslException exception = null;
        try {
            saslServer = Sasl.createSaslServer("GSSAPI", "AMQP", localFQDN, null, new GssApiCallbackHandler());
        }
        catch (SaslException e) {
            exception = e;
            LOGGER.warn("Creation of SASL server for mechanism '{}' failed.", (Object)"GSSAPI", (Object)e);
        }
        this._exception = exception;
        this._saslServer = saslServer;
    }

    @Override
    protected Exception getSaslServerCreationException() {
        return this._exception;
    }

    @Override
    protected SaslServer getSaslServer() {
        return this._saslServer;
    }

    @Override
    protected AuthenticationProvider<?> getAuthenticationProvider() {
        return this._authenticationProvider;
    }

    @Override
    public String getAttemptedAuthenticationId() {
        return null;
    }

    private static class GssApiCallbackHandler
    implements CallbackHandler {
        private GssApiCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback);
                }
                ((AuthorizeCallback)callback).setAuthorized(true);
            }
        }
    }
}

