/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.lock;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.lock.AdaptiveBackOffSpinLock;

public class BackOffSpinLock
implements AdaptiveBackOffSpinLock {
    private AtomicBoolean putMessageSpinLock = new AtomicBoolean(true);
    private int optimalDegree = 1000;
    private static final int INITIAL_DEGREE = 1000;
    private static final int MAX_OPTIMAL_DEGREE = 10000;
    private final List<AtomicInteger> numberOfRetreat = new ArrayList<AtomicInteger>(2);

    public BackOffSpinLock() {
        this.numberOfRetreat.add(new AtomicInteger(0));
        this.numberOfRetreat.add(new AtomicInteger(0));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void lock() {
        spinDegree = this.optimalDegree;
        while (true) lbl-1000:
        // 4 sources

        {
            for (i = 0; i < spinDegree; ++i) {
                if (!this.putMessageSpinLock.compareAndSet(true, false)) continue;
                return;
            }
            this.numberOfRetreat.get(LocalTime.now().getSecond() % 2).getAndIncrement();
            try {
                Thread.sleep(0L);
                ** continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void unlock() {
        this.putMessageSpinLock.compareAndSet(false, true);
    }

    @Override
    public void update(MessageStoreConfig messageStoreConfig) {
        this.optimalDegree = messageStoreConfig.getSpinLockCollisionRetreatOptimalDegree();
    }

    public int getOptimalDegree() {
        return this.optimalDegree;
    }

    public void setOptimalDegree(int optimalDegree) {
        this.optimalDegree = optimalDegree;
    }

    public boolean isAdapt() {
        return this.optimalDegree < 10000;
    }

    public synchronized void adapt(boolean isRise) {
        if (isRise) {
            if (this.optimalDegree * 2 <= 10000) {
                this.optimalDegree *= 2;
            } else if (this.optimalDegree + 1000 <= 10000) {
                this.optimalDegree += 1000;
            }
        } else if (this.optimalDegree >= 2000) {
            this.optimalDegree -= 1000;
        }
    }

    public int getNumberOfRetreat(int pos) {
        return this.numberOfRetreat.get(pos).get();
    }

    public void setNumberOfRetreat(int pos, int size) {
        this.numberOfRetreat.get(pos).set(size);
    }
}

