/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.http.HttpClientRequest;
import com.netflix.config.DynamicPropertyFactory;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.tracing.zipkin.TracingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpClientRequestWrapper
extends HttpClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientRequestWrapper.class);
    private Invocation invocation;

    HttpClientRequestWrapper() {
    }

    HttpClientRequestWrapper(Invocation invocation) {
        this.invocation = invocation;
    }

    HttpClientRequestWrapper invocation(Invocation invocation) {
        this.invocation = invocation;
        return this;
    }

    public void header(String name, String value) {
        this.invocation.addContext(name, value);
    }

    public String method() {
        return this.invocation.getOperationMeta().getHttpMethod();
    }

    public String path() {
        if (DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.tracing.workWithThirdParty", false).get()) {
            try {
                return TracingConfiguration.createRequestPath(this.invocation);
            }
            catch (Exception e) {
                LOG.warn("generate rest path failed: {}", (Object)e.getMessage());
            }
        }
        return this.invocation.getOperationMeta().getOperationPath();
    }

    public String url() {
        return this.invocation.getEndpoint().getEndpoint();
    }

    public String header(String name) {
        return (String)this.invocation.getContext().get(name);
    }

    public Object unwrap() {
        return this.invocation;
    }
}

