/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.sis.metadata.CacheKey;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataColumn;
import org.apache.sis.metadata.NilReasonMap;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.SpecialCases;
import org.apache.sis.metadata.TreeNodeChildren;
import org.apache.sis.metadata.TreeTableView;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.internal.shared.Unsafe;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.apache.sis.xml.NilReason;
import org.apache.sis.xml.bind.lan.LocaleAndCharset;
import org.opengis.annotation.Obligation;

class TreeNode
implements TreeTable.Node {
    private static final Collection<TreeTable.Node> LEAF = Set.of();
    final TreeTableView table;
    private final TreeNode parent;
    final Object metadata;
    final Class<?> baseType;
    private transient CharSequence name;
    private transient Collection<TreeTable.Node> children;
    transient Object cachedValue;
    transient boolean canUseCache;

    TreeNode(TreeTableView table, Object metadata, Class<?> baseType) {
        this.table = table;
        this.parent = null;
        this.metadata = metadata;
        this.baseType = baseType;
    }

    private TreeNode(TreeNode parent, Object metadata, Class<?> baseType) {
        this.table = parent.table;
        this.parent = parent;
        this.metadata = metadata;
        this.baseType = baseType;
        if (!this.isMetadata(baseType)) {
            this.children = LEAF;
        }
    }

    final boolean isMetadata(Class<?> type) {
        return this.table.standard.isMetadata(type);
    }

    private CacheKey key() {
        return new CacheKey(this.metadata.getClass(), this.baseType);
    }

    void appendIdentifier(StringBuilder buffer) {
        buffer.append(Classes.getShortClassName((Object)this.metadata));
    }

    String getIdentifier() {
        Class type = this.table.standard.getInterface(this.key());
        String id = Types.getStandardName(type);
        return id != null ? id : Classes.getShortName(type);
    }

    Integer getIndex() {
        return null;
    }

    CharSequence getName() {
        return CharSequences.camelCaseToSentence((CharSequence)Classes.getShortName(this.table.standard.getInterface(this.key()))).toString();
    }

    Obligation getObligation() {
        return null;
    }

    CharSequence getRemarks() {
        return null;
    }

    NilReason getNilReason() {
        return null;
    }

    private Object getNonNilValue() {
        if (!this.canUseCache) {
            this.cachedValue = this.getUserObject();
        }
        this.canUseCache = false;
        if (this.table.valuePolicy.acceptNilValues() && NilReason.forObject(this.cachedValue) != null) {
            return null;
        }
        return this.cachedValue;
    }

    public Object getUserObject() {
        return this.metadata;
    }

    void setUserObject(Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.unmodifiableCellValue(TableColumn.VALUE));
    }

    void setNilReason(NilReason value) {
        throw new UnsupportedOperationException(this.unmodifiableCellValue(MetadataColumn.NIL_REASON));
    }

    boolean isWritable() {
        return false;
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && ((TreeNode)other).metadata == this.metadata && ((TreeNode)other).baseType == this.baseType;
    }

    public int hashCode() {
        return System.identityHashCode(this.metadata) ^ Objects.hashCode(this.baseType);
    }

    public final TreeTable.Node getParent() {
        return this.parent;
    }

    public final boolean isLeaf() {
        return this.children == LEAF;
    }

    public final Collection<TreeTable.Node> getChildren() {
        if (!this.isLeaf()) {
            Object value = this.getNonNilValue();
            if (value == null) {
                this.children = null;
                return LEAF;
            }
            if (this.children == null || ((TreeNodeChildren)this.children).metadata != value) {
                PropertyAccessor accessor = this.table.standard.getAccessor(new CacheKey(value.getClass(), this.baseType), true);
                this.children = new TreeNodeChildren(this, value, accessor);
            }
        }
        return this.children;
    }

    public final TreeTable.Node newChild() throws UnsupportedOperationException {
        if (this.isLeaf()) {
            throw new UnsupportedOperationException(Errors.format((short)125, (Object)this));
        }
        return new NewChild();
    }

    private TreeNodeChildren getCompactChildren() {
        Collection<TreeTable.Node> children;
        if (this.table.valuePolicy == ValueExistencePolicy.COMPACT && (children = this.getChildren()) instanceof TreeNodeChildren) {
            return (TreeNodeChildren)children;
        }
        return null;
    }

    public final <V> V getValue(TableColumn<V> column) {
        Object value = null;
        ArgumentChecks.ensureNonNull((String)"column", column);
        if (column == TableColumn.IDENTIFIER) {
            value = this.getIdentifier();
        } else if (column == TableColumn.INDEX) {
            value = this.getIndex();
        } else if (column == TableColumn.NAME) {
            if (this.name == null) {
                this.name = this.getName();
            }
            value = this.name;
        } else if (column == TableColumn.TYPE) {
            TreeNodeChildren children = this.getCompactChildren();
            if (children == null || (value = children.getParentType()) == null) {
                value = this.baseType;
            }
        } else if (column == TableColumn.VALUE) {
            if (this.isLeaf()) {
                value = this.getNonNilValue();
            } else {
                TreeNodeChildren children = this.getCompactChildren();
                if (children != null) {
                    value = children.getParentTitle();
                }
            }
        } else if (column == MetadataColumn.OBLIGATION) {
            value = this.getObligation();
        } else if (column == MetadataColumn.NIL_REASON) {
            value = this.getNilReason();
        } else if (column == TableColumn.REMARKS) {
            value = this.getRemarks();
        }
        return (V)column.getElementType().cast(value);
    }

    public final <V> void setValue(TableColumn<V> column, V value) throws UnsupportedOperationException {
        ArgumentChecks.ensureNonNull((String)"column", column);
        if (column == TableColumn.VALUE) {
            ArgumentChecks.ensureNonNull((String)"value", value);
            TreeNodeChildren children = this.getCompactChildren();
            if (children == null || !children.setParentTitle(value)) {
                this.setUserObject(value);
            }
        } else if (column == MetadataColumn.NIL_REASON) {
            this.setNilReason((NilReason)value);
        } else {
            if (this.table.getColumns().contains(column)) {
                throw new UnsupportedOperationException(this.unmodifiableCellValue(column));
            }
            throw new IllegalArgumentException(Errors.format((short)59, (Object)"column", column));
        }
    }

    private String unmodifiableCellValue(TableColumn<?> column) {
        return Errors.format((short)184, this.getValue(TableColumn.NAME), (Object)column.getHeader());
    }

    public final boolean isEditable(TableColumn<?> column) {
        ArgumentChecks.ensureNonNull((String)"column", column);
        return column == TableColumn.VALUE && this.isWritable();
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder(60);
        this.appendStringTo(buffer);
        return buffer.toString();
    }

    final void appendStringTo(StringBuilder buffer) {
        this.appendIdentifier(buffer.append("Node["));
        buffer.append(" : ").append(Classes.getShortName(this.baseType)).append(']');
    }

    private final class NewChild
    implements TreeTable.Node {
        private int indexInData = -1;
        private TreeNode delegate;

        private NewChild() {
        }

        private TreeNode delegate() throws IllegalStateException {
            if (this.delegate != null) {
                return this.delegate;
            }
            throw new IllegalStateException(Errors.format((short)113, (Object)(this.indexInData < 0 ? TableColumn.IDENTIFIER : TableColumn.VALUE).getHeader()));
        }

        private TreeNodeChildren getSiblings() {
            return (TreeNodeChildren)TreeNode.this.getChildren();
        }

        public <V> void setValue(TableColumn<V> column, V value) {
            if (this.delegate == null) {
                if (column == TableColumn.IDENTIFIER) {
                    ArgumentChecks.ensureNonNull((String)"value", value);
                    this.indexInData = this.getSiblings().accessor.indexOf((String)value, true);
                    return;
                }
                if (column == TableColumn.VALUE) {
                    ArgumentChecks.ensureNonNull((String)"value", value);
                    if (this.indexInData < 0) {
                        throw new IllegalStateException(Errors.format((short)113, (Object)TableColumn.IDENTIFIER.getHeader()));
                    }
                    TreeNodeChildren siblings = this.getSiblings();
                    int indexInList = siblings.isCollectionOrMap(this.indexInData) ? CollectionsExt.size((Object)siblings.valueAt(this.indexInData)) : -1;
                    if (!siblings.add(this.indexInData, value)) {
                        throw new IllegalArgumentException(Errors.format((short)42, value));
                    }
                    this.delegate = siblings.childAt(this.indexInData, indexInList);
                    return;
                }
            }
            this.delegate().setValue(column, value);
        }

        public TreeTable.Node getParent() {
            return TreeNode.this;
        }

        public boolean isLeaf() {
            return this.delegate().isLeaf();
        }

        public Collection<TreeTable.Node> getChildren() {
            return this.delegate().getChildren();
        }

        public TreeTable.Node newChild() {
            return this.delegate().newChild();
        }

        public <V> V getValue(TableColumn<V> column) {
            return this.delegate().getValue(column);
        }

        public boolean isEditable(TableColumn<?> column) {
            return this.delegate().isEditable(column);
        }

        public Object getUserObject() {
            return this.delegate().getUserObject();
        }
    }

    static final class CollectionElement
    extends Element {
        final int indexInList;

        CollectionElement(TreeNode parent, Object metadata, PropertyAccessor accessor, int indexInData, int indexInList) {
            super(parent, metadata, accessor, indexInData);
            this.indexInList = indexInList;
        }

        @Override
        void appendIdentifier(StringBuilder buffer) {
            super.appendIdentifier(buffer);
            buffer.append('[').append(this.indexInList).append(']');
        }

        @Override
        Integer getIndex() {
            return this.indexInList;
        }

        @Override
        CharSequence getName() {
            CharSequence name = super.getName();
            int size = CollectionsExt.size((Object)super.getUserObject());
            if (size >= 2) {
                name = Vocabulary.formatInternational((short)148, (Object[])new Object[]{name, this.indexInList + 1, size});
            }
            return name;
        }

        @Override
        public Object getUserObject() {
            Object collection = super.getUserObject();
            Set values = collection instanceof Collection ? (Set)collection : ((Map)collection).entrySet();
            if (this.indexInList == 0 && this.table.valuePolicy.substituteByNullElement(values)) {
                return null;
            }
            try {
                if (values instanceof List) {
                    return ((List)((Object)values)).get(this.indexInList);
                }
                Iterator it = values.iterator();
                for (int i = 0; i < this.indexInList; ++i) {
                    it.next();
                }
                return it.next();
            }
            catch (IndexOutOfBoundsException | NullPointerException | NoSuchElementException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        void setUserObject(Object value) {
            this.cachedValue = null;
            this.canUseCache = false;
            Collection values = (Collection)super.getUserObject();
            if (!(values instanceof List)) {
                throw new UnsupportedOperationException(Errors.format((short)199, (Object)"setValue"));
            }
            Class targetType = values instanceof CheckedContainer ? ((CheckedContainer)values).getElementType() : this.baseType;
            value = ObjectConverters.convert((Object)value, (Class)targetType);
            try {
                Unsafe.set((List)((List)values), (int)this.indexInList, (Object)value);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        NilReason getNilReason() {
            if (this.cachedValue == null) {
                this.cachedValue = this.getUserObject();
            }
            return NilReason.forObject(this.cachedValue);
        }

        @Override
        void setNilReason(NilReason value) {
            this.setUserObject(value != null ? value.createNilObject(this.baseType) : null);
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && ((CollectionElement)other).indexInList == this.indexInList;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.indexInList;
        }
    }

    static class Element
    extends TreeNode {
        private final PropertyAccessor accessor;
        private transient NilReasonMap nilReasons;
        private final int indexInData;
        final Function<TreeNode, TreeTable.Node> decorator;

        Element(TreeNode parent, Object metadata, PropertyAccessor accessor, int indexInData) {
            super(parent, metadata, accessor.type(indexInData, TypeValuePolicy.ELEMENT_TYPE));
            this.accessor = accessor;
            this.indexInData = indexInData;
            this.decorator = SpecialCases.isLocaleAndCharset(accessor, indexInData) ? LocaleAndCharset::new : null;
        }

        @Override
        void appendIdentifier(StringBuilder buffer) {
            super.appendIdentifier(buffer);
            buffer.append('.').append(this.accessor.name(this.indexInData, KeyNamePolicy.JAVABEANS_PROPERTY));
        }

        @Override
        final String getIdentifier() {
            return this.accessor.name(this.indexInData, KeyNamePolicy.UML_IDENTIFIER);
        }

        @Override
        CharSequence getName() {
            Class<?> type;
            Object value;
            String identifier = this.getIdentifier();
            if (identifier.equalsIgnoreCase(Classes.getShortName((Class)this.baseType)) && (value = this.getUserObject()) != null && (type = this.standardSubType(Classes.getLeafInterfaces(value.getClass(), (Class)this.baseType))) != null && type != Void.TYPE) {
                identifier = Classes.getShortName(type);
            }
            identifier = SpecialCases.rename(identifier);
            return CharSequences.camelCaseToSentence((CharSequence)identifier).toString();
        }

        private Class<?> standardSubType(Class<?>[] subtypes) {
            Class<?> type = null;
            for (Class<?> c : subtypes) {
                if (!this.baseType.isAssignableFrom(c)) continue;
                if (!this.isMetadata(c)) {
                    c = this.standardSubType(c.getInterfaces());
                }
                if (type == null) {
                    type = c;
                    continue;
                }
                if (type == c) continue;
                return Void.TYPE;
            }
            return type;
        }

        private NilReasonMap nilReasons() {
            if (this.nilReasons == null) {
                this.nilReasons = new NilReasonMap(this.metadata, this.accessor, KeyNamePolicy.UML_IDENTIFIER);
            }
            return this.nilReasons;
        }

        @Override
        void setNilReason(NilReason value) {
            this.cachedValue = null;
            this.canUseCache = false;
            this.nilReasons().setReflectively(this.indexInData, value);
        }

        @Override
        NilReason getNilReason() {
            if (this.cachedValue == null) {
                this.cachedValue = this.getUserObject();
            }
            return this.nilReasons().getNilReason(this.indexInData, this.cachedValue);
        }

        @Override
        Obligation getObligation() {
            return this.accessor.obligation(this.indexInData);
        }

        @Override
        final CharSequence getRemarks() {
            return this.accessor.remarks(this.indexInData, this.metadata);
        }

        @Override
        public Object getUserObject() {
            return this.accessor.get(this.indexInData, this.metadata);
        }

        @Override
        void setUserObject(Object value) {
            this.cachedValue = null;
            this.canUseCache = false;
            this.accessor.set(this.indexInData, this.metadata, value, 0);
        }

        @Override
        final boolean isWritable() {
            return this.accessor.isWritable(this.indexInData);
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && ((Element)other).indexInData == this.indexInData;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ 31 * this.indexInData;
        }
    }
}

