/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

public final class Slf4jLogFactory
extends LogFactory {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Marker MARKER = MarkerFactory.getMarker((String)"COMMONS-LOGGING");
    private final ConcurrentMap<String, Log> loggers = new ConcurrentHashMap<String, Log>();
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public Log getInstance(Class<?> clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String name) {
        return this.loggers.computeIfAbsent(name, n -> {
            Logger logger = LoggerFactory.getLogger((String)n);
            return logger instanceof LocationAwareLogger ? new Slf4jLocationAwareLog((LocationAwareLogger)logger) : new Slf4jLog(logger);
        });
    }

    public void release() {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        try {
            factory.getClass().getMethod("stop", new Class[0]).invoke((Object)factory, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }

    private static final class Slf4jLocationAwareLog
    implements Log {
        private static final String FQCN = Slf4jLocationAwareLog.class.getName();
        private final LocationAwareLogger logger;

        public Slf4jLocationAwareLog(LocationAwareLogger logger) {
            this.logger = logger;
        }

        public void debug(Object message) {
            this.log(10, message, null);
        }

        public void debug(Object message, Throwable t) {
            this.log(10, message, t);
        }

        public void error(Object message) {
            this.log(40, message, null);
        }

        public void error(Object message, Throwable t) {
            this.log(40, message, t);
        }

        public void fatal(Object message) {
            this.error(message);
        }

        public void fatal(Object message, Throwable t) {
            this.error(message, t);
        }

        public void info(Object message) {
            this.log(20, message, null);
        }

        public void info(Object message, Throwable t) {
            this.log(20, message, t);
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled(MARKER);
        }

        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled(MARKER);
        }

        public boolean isFatalEnabled() {
            return this.isErrorEnabled();
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled(MARKER);
        }

        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled(MARKER);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled(MARKER);
        }

        private void log(int level, Object message, Throwable t) {
            this.logger.log(MARKER, FQCN, level, String.valueOf(message), EMPTY_OBJECT_ARRAY, t);
        }

        public void trace(Object message) {
            this.log(0, message, null);
        }

        public void trace(Object message, Throwable t) {
            this.log(0, message, t);
        }

        public void warn(Object message) {
            this.log(30, message, null);
        }

        public void warn(Object message, Throwable t) {
            this.log(30, message, t);
        }
    }

    private static class Slf4jLog
    implements Log {
        private final Logger logger;

        public Slf4jLog(Logger logger) {
            this.logger = logger;
        }

        public void debug(Object message) {
            this.logger.debug(MARKER, String.valueOf(message));
        }

        public void debug(Object message, Throwable t) {
            this.logger.debug(MARKER, String.valueOf(message), t);
        }

        public void error(Object message) {
            this.logger.error(MARKER, String.valueOf(message));
        }

        public void error(Object message, Throwable t) {
            this.logger.debug(MARKER, String.valueOf(message), t);
        }

        public void fatal(Object message) {
            this.error(message);
        }

        public void fatal(Object message, Throwable t) {
            this.error(message, t);
        }

        public void info(Object message) {
            this.logger.info(MARKER, String.valueOf(message));
        }

        public void info(Object message, Throwable t) {
            this.logger.info(MARKER, String.valueOf(message), t);
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled(MARKER);
        }

        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled(MARKER);
        }

        public boolean isFatalEnabled() {
            return this.isErrorEnabled();
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled(MARKER);
        }

        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled(MARKER);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled(MARKER);
        }

        public void trace(Object message) {
            this.logger.trace(MARKER, String.valueOf(message));
        }

        public void trace(Object message, Throwable t) {
            this.logger.trace(MARKER, String.valueOf(message), t);
        }

        public void warn(Object message) {
            this.logger.warn(MARKER, String.valueOf(message));
        }

        public void warn(Object message, Throwable t) {
            this.logger.warn(MARKER, String.valueOf(message), t);
        }
    }
}

