/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.alerts;

import com.google.gxp.compiler.alerts.Alert;
import com.google.gxp.compiler.alerts.AlertPolicy;
import com.google.gxp.compiler.alerts.AlertSet;
import com.google.gxp.compiler.alerts.AlertSink;

public class AlertCounter
implements AlertSink {
    private final int[] counts = new int[Alert.Severity.values().length];
    private final AlertSink delegate;
    private final AlertPolicy policy;

    public AlertCounter(AlertSink delegate, AlertPolicy policy) {
        this.delegate = delegate;
        this.policy = policy;
    }

    @Override
    public void add(Alert alert) {
        this.countAlert(alert);
        this.delegate.add(alert);
    }

    @Override
    public void addAll(AlertSet alertSet) {
        for (Alert alert : alertSet) {
            this.countAlert(alert);
        }
        this.delegate.addAll(alertSet);
    }

    public int getInfoCount() {
        return this.counts[Alert.Severity.INFO.ordinal()];
    }

    public int getWarningCount() {
        return this.counts[Alert.Severity.WARNING.ordinal()];
    }

    public int getErrorCount() {
        return this.counts[Alert.Severity.ERROR.ordinal()];
    }

    private void countAlert(Alert alert) {
        Alert.Severity severity = this.policy.getSeverity(alert);
        int n = severity.ordinal();
        this.counts[n] = this.counts[n] + 1;
    }
}

