/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.schema;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.com.google.common.collect.Sets;
import com.google.gxp.compiler.alerts.Alert;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.alerts.common.IOError;
import com.google.gxp.compiler.alerts.common.SaxAlert;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.schema.AttributeElement;
import com.google.gxp.compiler.schema.AttributeValidator;
import com.google.gxp.compiler.schema.DocType;
import com.google.gxp.compiler.schema.ElementBuilder;
import com.google.gxp.compiler.schema.ElementValidator;
import com.google.gxp.compiler.schema.Schema;
import com.google.gxp.compiler.schema.SchemaRef;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class SchemaParser {
    public static final SchemaParser INSTANCE = new SchemaParser();

    private SchemaParser() {
    }

    private Schema parse(FileRef input) throws IOException, SAXException {
        InputStream inputStream = input.openInputStream();
        InputSource inputSource = new InputSource(inputStream);
        SaxEventHandler eventHandler = new SaxEventHandler(input);
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler(eventHandler);
        xmlReader.parse(inputSource);
        inputStream.close();
        return eventHandler.getSchema();
    }

    public static Schema getSchema(FileRef input, AlertSink alertSink) {
        SourcePosition pos = new SourcePosition(input);
        try {
            return Preconditions.checkNotNull(INSTANCE.parse(input));
        }
        catch (SAXException saxException) {
            alertSink.add(new SaxAlert(pos, Alert.Severity.ERROR, saxException));
            return null;
        }
        catch (IOException iox) {
            alertSink.add(new IOError(pos, iox));
            return null;
        }
    }

    private static class SaxEventHandler
    implements ContentHandler {
        private boolean done = false;
        private FileRef source;
        private String schemaName;
        private String schemaContentType;
        private String schemaNamespaceUri;
        private String schemaTagPrefix;
        private String schemaCppType;
        private String schemaCppAppender;
        private List<String> schemaCppImports = Lists.newArrayList();
        private String schemaJavaType;
        private String schemaJavaAppender;
        private List<String> schemaJavaImports = Lists.newArrayList();
        private String schemaJavaScriptType;
        private boolean schemaDefaultsToSgml;
        private String schemaSgmlContentType;
        private List<SchemaRef> schemaAllowedSchemaRefs = Lists.newArrayList();
        private Map<String, ElementBuilder> elementBuilders = Maps.newHashMap();
        private int lineNumber = 0;
        private int columnNumber = 0;
        private int depth = 0;
        private boolean sawAttrs = false;
        private Map<String, DocType> docTypeMap = Maps.newHashMap();
        private Map<String, PatternElement> patterns = Maps.newHashMap();

        public SaxEventHandler(FileRef source) {
            this.source = Preconditions.checkNotNull(source);
        }

        Schema getSchema() {
            if (!this.done) {
                throw new IllegalStateException();
            }
            return new Schema(this.getSourcePosition(), "<schema>", this.schemaName, this.schemaNamespaceUri, this.schemaContentType, this.schemaDefaultsToSgml, this.schemaSgmlContentType, this.schemaTagPrefix, this.schemaCppType, this.schemaCppAppender, this.schemaCppImports, this.schemaJavaType, this.schemaJavaAppender, this.schemaJavaImports, this.schemaJavaScriptType, this.elementBuilders.values(), this.schemaAllowedSchemaRefs, null);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        private SourcePosition getSourcePosition() {
            if (this.lineNumber > 0 && this.columnNumber > 0) {
                return new SourcePosition(this.source, this.lineNumber, this.columnNumber);
            }
            return new SourcePosition(this.source);
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
            this.done = true;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            throw new Error("TODO(laurence): implement");
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            throw new Error("TODO(laurence): implement");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            ++this.depth;
            Map<String, String> attrMap = this.parseAttributes(attrs);
            if (localName.equals("schema")) {
                if (this.depth != 1) {
                    throw new IllegalStateException("Nested <schema>.");
                }
                this.schemaName = attrMap.remove("name");
                this.schemaContentType = attrMap.remove("content-type");
                this.schemaNamespaceUri = attrMap.remove("namespace");
                this.schemaTagPrefix = attrMap.remove("tag-prefix");
                this.schemaCppType = attrMap.remove("cpp-type");
                this.schemaCppAppender = attrMap.remove("cpp-appender");
                String cppImportsStr = attrMap.remove("cpp-imports");
                if (cppImportsStr != null) {
                    for (String cppImport : SaxEventHandler.split(cppImportsStr)) {
                        this.schemaCppImports.add(cppImport);
                    }
                }
                this.schemaJavaType = attrMap.remove("java-type");
                this.schemaJavaAppender = attrMap.remove("java-appender");
                String javaImportsStr = attrMap.remove("java-imports");
                if (javaImportsStr != null) {
                    for (String javaImport : SaxEventHandler.split(javaImportsStr)) {
                        this.schemaJavaImports.add(javaImport);
                    }
                }
                this.schemaJavaScriptType = attrMap.remove("javascript-type");
                this.schemaDefaultsToSgml = "true".equals(attrMap.remove("default-to-sgml"));
                this.schemaSgmlContentType = attrMap.remove("sgml-content-type");
                String allowedContentTypes = attrMap.remove("allowed-content-types");
                if (allowedContentTypes != null) {
                    for (String allowedContentType : SaxEventHandler.split(allowedContentTypes)) {
                        this.schemaAllowedSchemaRefs.add(new SchemaRef(allowedContentType));
                    }
                }
                SaxEventHandler.assertNoMoreAttrs(attrMap);
            } else {
                if (this.depth != 2) {
                    throw new IllegalStateException("<" + localName + "> must be child of schema");
                }
                if (localName.equals("doctype")) {
                    DocType docType = this.createDocType(attrMap);
                    this.docTypeMap.put(docType.getName(), docType);
                } else if (localName.equals("element")) {
                    if (this.sawAttrs) {
                        throw new IllegalStateException("<element> cannot appear after <attribute>");
                    }
                    ElementBuilder elementBuilder = this.createElementBuilder(attrMap);
                    this.elementBuilders.put(elementBuilder.getName(), elementBuilder);
                } else if (localName.equals("pattern")) {
                    PatternElement patternElement = this.createPattern(attrMap);
                    this.patterns.put(patternElement.getName(), patternElement);
                } else if (localName.equals("attribute")) {
                    this.sawAttrs = true;
                    AttributeElement attrElement = this.createAttributeElement(attrMap);
                    Set<String> exceptElementNames = attrElement.getExceptElementNames();
                    Set<String> elementNames = attrElement.getElementNames();
                    if (exceptElementNames.isEmpty()) {
                        for (String elementName : elementNames) {
                            this.elementBuilders.get(elementName).add(attrElement);
                        }
                    } else {
                        if (!elementNames.isEmpty()) {
                            throw new RuntimeException("can't specify both elements and except-elements");
                        }
                        for (String elementName : this.elementBuilders.keySet()) {
                            if (exceptElementNames.contains(elementName)) continue;
                            this.elementBuilders.get(elementName).add(attrElement);
                        }
                    }
                } else {
                    throw new IllegalArgumentException("unrecognized tag <" + localName + ">");
                }
            }
        }

        private DocType createDocType(Map<String, String> attrMap) {
            String name = attrMap.remove("name");
            String publicId = attrMap.remove("public-id");
            String systemId = attrMap.remove("system-id");
            String sgmlPublicId = attrMap.remove("sgml-public-id");
            String sgmlSystemId = attrMap.remove("sgml-system-id");
            SaxEventHandler.assertNoMoreAttrs(attrMap);
            return new DocType(name, publicId, systemId, sgmlPublicId, sgmlSystemId);
        }

        private ElementBuilder createElementBuilder(Map<String, String> attrMap) {
            String name = attrMap.remove("name");
            String flagNames = attrMap.remove("flags");
            String contentType = attrMap.remove("content");
            String docTypeNames = attrMap.remove("doctypes");
            SaxEventHandler.assertNoMoreAttrs(attrMap);
            EnumSet<ElementValidator.Flag> flags = EnumSet.noneOf(ElementValidator.Flag.class);
            if (flagNames != null) {
                for (String flagName : SaxEventHandler.split(flagNames)) {
                    flags.add(ElementValidator.Flag.valueOf(SaxEventHandler.xmlToEnum(flagName)));
                }
            }
            HashSet<DocType> docTypes = Sets.newHashSet();
            if (docTypeNames != null) {
                for (String docTypeName : SaxEventHandler.split(docTypeNames)) {
                    if (!this.docTypeMap.containsKey(docTypeName)) {
                        throw new IllegalArgumentException("can't find definition for doctype named \"" + docTypeName + "\".");
                    }
                    docTypes.add(this.docTypeMap.get(docTypeName));
                }
            }
            return new ElementBuilder(name, flags, contentType, docTypes);
        }

        private PatternElement createPattern(Map<String, String> attrMap) {
            String name = attrMap.remove("name");
            String regex = attrMap.remove("regex");
            SaxEventHandler.assertNoMoreAttrs(attrMap);
            return new PatternElement(name, regex);
        }

        private AttributeElement createAttributeElement(Map<String, String> attrMap) {
            String name = attrMap.remove("name");
            String elementNames = attrMap.remove("elements");
            String exceptElementNames = attrMap.remove("except-elements");
            String contentType = attrMap.remove("content");
            String patternName = attrMap.remove("pattern");
            String regex = attrMap.remove("regex");
            String flagNames = attrMap.remove("flags");
            String defaultValue = attrMap.remove("default");
            String example = attrMap.remove("example");
            SaxEventHandler.assertNoMoreAttrs(attrMap);
            if (patternName != null) {
                if (regex != null) {
                    throw new RuntimeException();
                }
                regex = this.patterns.get(patternName).getRegex();
            }
            Pattern pattern = regex == null ? null : Pattern.compile(regex);
            EnumSet<AttributeValidator.Flag> flags = EnumSet.noneOf(AttributeValidator.Flag.class);
            if (flagNames != null) {
                for (String flagName : SaxEventHandler.split(flagNames)) {
                    flags.add(AttributeValidator.Flag.valueOf(SaxEventHandler.xmlToEnum(flagName)));
                }
            }
            return new AttributeElement(name, contentType, pattern, flags, defaultValue, example, Sets.newHashSet(SaxEventHandler.split(elementNames)), Sets.newHashSet(SaxEventHandler.split(exceptElementNames)));
        }

        private Map<String, String> parseAttributes(Attributes attrs) {
            HashMap<String, String> attrMap = Maps.newHashMap();
            int n = attrs.getLength();
            for (int i = 0; i < n; ++i) {
                attrMap.put(attrs.getLocalName(i), attrs.getValue(i));
            }
            return attrMap;
        }

        private static void assertNoMoreAttrs(Map<String, ?> attrMap) {
            if (!attrMap.isEmpty()) {
                throw new RuntimeException("Unknown attrs: " + attrMap.keySet());
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            --this.depth;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            for (int i = start; i < start + length; ++i) {
                if (Character.isWhitespace(ch[i])) continue;
                throw new RuntimeException("illegal content: '" + ch[i] + "'");
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            throw new Error("TODO(laurence): implement");
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            throw new Error("TODO(laurence): implement");
        }

        private static String[] split(String s) {
            if (s == null) {
                return new String[0];
            }
            return s.split("\\s+");
        }

        private static String xmlToEnum(String s) {
            if (s.matches("[-a-z]+")) {
                return s.toUpperCase().replace("-", "_");
            }
            throw new RuntimeException("Illegal value " + s);
        }

        private static class PatternElement {
            private final String name;
            private final String regex;

            public String getName() {
                return this.name;
            }

            public String getRegex() {
                return this.regex;
            }

            PatternElement(String name, String regex) {
                this.name = name;
                this.regex = regex;
            }
        }
    }
}

