/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.base.Import;
import com.google.gxp.compiler.base.ImportVisitor;
import com.google.gxp.compiler.base.Node;

public class CppLibraryImport
extends Import {
    private final String libraryName;

    public CppLibraryImport(Node fromNode, String libraryName) {
        super(fromNode);
        this.libraryName = Preconditions.checkNotNull(libraryName);
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    @Override
    public <T> T acceptVisitor(ImportVisitor<T> visitor) {
        return visitor.visitCppLibraryImport(this);
    }

    @Override
    public String getTarget() {
        return "<" + this.getLibraryName() + ">";
    }

    public boolean equals(Object that) {
        return that instanceof CppLibraryImport && this.equals((CppLibraryImport)that);
    }

    public boolean equals(CppLibraryImport that) {
        return this.getLibraryName().equals(that.getLibraryName());
    }
}

