/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.create;

import org.directwebremoting.extend.AbstractCreator;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;

public class NewCreator
extends AbstractCreator
implements Creator {
    private Class<?> clazz;

    public void setClass(String classname) {
        try {
            this.clazz = LocalUtil.classForName(classname);
            if (this.getJavascript() == null) {
                this.setJavascript(this.clazz.getSimpleName());
            }
        }
        catch (ExceptionInInitializerError ex) {
            throw new IllegalArgumentException("Error loading class: " + classname, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Class not found: " + classname, ex);
        }
    }

    @Override
    public Class<?> getType() {
        return this.clazz;
    }

    @Override
    public Object getInstance() throws InstantiationException {
        try {
            return this.clazz.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new InstantiationException("Illegal Access to default constructor on " + this.clazz.getName());
        }
    }

    public void setClassName(String className) {
        this.setClass(className);
    }

    public String getClassName() {
        return this.getType().getName();
    }
}

