/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml.print;

import java.util.function.Consumer;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseGenericPrintElement;
import net.sf.jasperreports.engine.util.JRValueStringUtils;
import net.sf.jasperreports.engine.xml.print.ReportElementLoader;
import net.sf.jasperreports.engine.xml.print.XmlLoader;

public class GenericElementLoader {
    private static final GenericElementLoader INSTANCE = new GenericElementLoader();

    public static GenericElementLoader instance() {
        return INSTANCE;
    }

    public void loadGenericElement(XmlLoader xmlLoader, JasperPrint jasperPrint, Consumer<? super JRGenericPrintElement> consumer) {
        JRBaseGenericPrintElement genericElement = new JRBaseGenericPrintElement(jasperPrint.getDefaultStyleProvider());
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "reportElement": {
                    ReportElementLoader.instance().loadReportElement(xmlLoader, jasperPrint, genericElement);
                    break;
                }
                case "genericElementType": {
                    this.loadType(xmlLoader, genericElement);
                    break;
                }
                case "genericElementParameter": {
                    this.loadParameter(xmlLoader, genericElement);
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
        consumer.accept(genericElement);
    }

    protected void loadType(XmlLoader xmlLoader, JRBaseGenericPrintElement genericElement) {
        String namespace = xmlLoader.getAttribute("namespace");
        String name = xmlLoader.getAttribute("name");
        xmlLoader.endElement();
        JRGenericElementType type = new JRGenericElementType(namespace, name);
        genericElement.setGenericType(type);
    }

    private void loadParameter(XmlLoader xmlLoader, JRBaseGenericPrintElement genericElement) {
        String name = xmlLoader.getAttribute("name");
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "genericElementParameterValue": {
                    String valueClass = xmlLoader.getAttribute("class");
                    String valueText = xmlLoader.loadText(true);
                    Object value = JRValueStringUtils.deserialize(valueClass, valueText);
                    genericElement.setParameterValue(name, value);
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
    }
}

