/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.aot;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedClasses;
import org.springframework.core.log.LogMessage;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.javapoet.TypeName;
import org.springframework.javapoet.TypeSpec;
import org.springframework.test.context.aot.AotTestAttributes;

class AotTestAttributesCodeGenerator {
    private static final Log logger = LogFactory.getLog(AotTestAttributesCodeGenerator.class);
    private static final TypeName MAP_TYPE = ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class});
    private static final String GENERATED_SUFFIX = "Generated";
    static final String GENERATED_ATTRIBUTES_CLASS_NAME = AotTestAttributes.class.getName() + "__Generated";
    static final String GENERATED_ATTRIBUTES_METHOD_NAME = "getAttributes";
    private final Map<String, String> attributes;
    private final GeneratedClass generatedClass;

    AotTestAttributesCodeGenerator(Map<String, String> attributes, GeneratedClasses generatedClasses) {
        this.attributes = attributes;
        this.generatedClass = generatedClasses.addForFeature(GENERATED_SUFFIX, this::generateType);
    }

    GeneratedClass getGeneratedClass() {
        return this.generatedClass;
    }

    private void generateType(TypeSpec.Builder type) {
        logger.debug((Object)LogMessage.format((String)"Generating AOT test attributes in %s", (Object)this.generatedClass.getName().reflectionName()));
        type.addJavadoc("Generated map for {@link $T}.", new Object[]{AotTestAttributes.class});
        type.addModifiers(new Modifier[]{Modifier.PUBLIC});
        type.addMethod(this.generateMethod());
    }

    private MethodSpec generateMethod() {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)GENERATED_ATTRIBUTES_METHOD_NAME);
        method.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        method.returns(MAP_TYPE);
        method.addCode(this.generateCode());
        return method.build();
    }

    private CodeBlock generateCode() {
        CodeBlock.Builder code = CodeBlock.builder();
        code.addStatement("$T map = new $T<>()", new Object[]{MAP_TYPE, HashMap.class});
        this.attributes.forEach((key, value) -> {
            logger.trace((Object)LogMessage.format((String)"Storing AOT test attribute: %s = %s", (Object)key, (Object)value));
            code.addStatement("map.put($S, $S)", new Object[]{key, value});
        });
        code.addStatement("return map", new Object[0]);
        return code.build();
    }
}

