/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import jakarta.resource.spi.ResourceAdapter;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.core.mdb.BaseMdbContainer;
import org.apache.openejb.core.mdb.MdbContainer;
import org.apache.openejb.core.mdb.MdbPoolContainer;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.Pool;

public class MdbContainerFactory {
    private Object id;
    private SecurityService securityService;
    private ResourceAdapter resourceAdapter;
    private Class messageListenerInterface;
    private Class activationSpecClass;
    private int instanceLimit;
    private boolean failOnUnknownActivationSpec;
    private Duration accessTimeout;
    private Duration closeTimeout;
    private Pool.Builder poolBuilder = new Pool.Builder();
    private int callbackThreads = 5;
    private boolean useOneSchedulerThreadByBean = false;
    private int evictionThreads = 1;
    private boolean pool;
    private Properties properties = new Properties();

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public Class getMessageListenerInterface() {
        return this.messageListenerInterface;
    }

    public void setMessageListenerInterface(Class messageListenerInterface) {
        this.messageListenerInterface = messageListenerInterface;
    }

    public Class getActivationSpecClass() {
        return this.activationSpecClass;
    }

    public void setActivationSpecClass(Class activationSpecClass) {
        this.activationSpecClass = activationSpecClass;
    }

    public int getInstanceLimit() {
        return this.instanceLimit;
    }

    @Deprecated
    public void setInstanceLimit(int instanceLimit) {
        this.setMaxSize(instanceLimit);
    }

    public void setMaxSize(int max) {
        this.instanceLimit = max;
        this.poolBuilder.setPoolSize(max);
    }

    public void setMinSize(int min) {
        this.poolBuilder.setMinSize(min);
    }

    public boolean isFailOnUnknownActivationSpec() {
        return this.failOnUnknownActivationSpec;
    }

    public void setFailOnUnknownActivationSpec(boolean failOnUnknownActivationSpec) {
        this.failOnUnknownActivationSpec = failOnUnknownActivationSpec;
    }

    public Duration getAccessTimeout() {
        return this.accessTimeout;
    }

    public void setAccessTimeout(Duration accessTimeout) {
        this.accessTimeout = accessTimeout;
    }

    public Duration getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(Duration closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public Pool.Builder getPoolBuilder() {
        return this.poolBuilder;
    }

    public void setPoolBuilder(Pool.Builder poolBuilder) {
        this.poolBuilder = poolBuilder;
    }

    public int getCallbackThreads() {
        return this.callbackThreads;
    }

    public void setCallbackThreads(int callbackThreads) {
        this.callbackThreads = callbackThreads;
    }

    public boolean isUseOneSchedulerThreadByBean() {
        return this.useOneSchedulerThreadByBean;
    }

    public void setUseOneSchedulerThreadByBean(boolean useOneSchedulerThreadByBean) {
        this.useOneSchedulerThreadByBean = useOneSchedulerThreadByBean;
    }

    public int getEvictionThreads() {
        return this.evictionThreads;
    }

    public void setEvictionThreads(int evictionThreads) {
        this.evictionThreads = evictionThreads;
    }

    public void setStrictPooling(boolean strict) {
        this.poolBuilder.setStrictPooling(strict);
    }

    public void setMaxAge(Duration maxAge) {
        this.poolBuilder.setMaxAge(maxAge);
    }

    public void setIdleTimeout(Duration idleTimeout) {
        this.poolBuilder.setIdleTimeout(idleTimeout);
    }

    public void setSweepInterval(Duration interval) {
        this.poolBuilder.setSweepInterval(interval);
    }

    public void setReplaceAged(boolean replaceAged) {
        this.poolBuilder.setReplaceAged(replaceAged);
    }

    public void setReplaceFlushed(boolean replaceFlushed) {
        this.poolBuilder.setReplaceFlushed(replaceFlushed);
    }

    public void setGarbageCollection(boolean garbageCollection) {
        this.poolBuilder.setGarbageCollection(garbageCollection);
    }

    public void setMaxAgeOffset(double maxAgeOffset) {
        this.poolBuilder.setMaxAgeOffset(maxAgeOffset);
    }

    public boolean isPool() {
        return this.pool;
    }

    public void setPool(boolean pool) {
        this.pool = pool;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public BaseMdbContainer create() {
        if (this.pool) {
            MdbPoolContainer mdbPoolContainer = new MdbPoolContainer(this.id, this.securityService, this.resourceAdapter, this.messageListenerInterface, this.activationSpecClass, this.failOnUnknownActivationSpec, this.accessTimeout, this.closeTimeout, this.poolBuilder, this.callbackThreads, this.useOneSchedulerThreadByBean, this.evictionThreads);
            mdbPoolContainer.getProperties().putAll((Map<?, ?>)this.getProperties());
            return mdbPoolContainer;
        }
        MdbContainer mdbContainer = new MdbContainer(this.id, this.securityService, this.resourceAdapter, this.messageListenerInterface, this.activationSpecClass, this.instanceLimit, this.failOnUnknownActivationSpec);
        mdbContainer.getProperties().putAll((Map<?, ?>)this.getProperties());
        return mdbContainer;
    }
}

