/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.metrics;

import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

public class MicroProfileMetricsRecorder
implements MetricsRecorder {
    private static final Metadata TIMEOUT_EXECUTION_DURATION_METADATA = Metadata.builder().withName("ft.timeout.executionDuration").withUnit("nanoseconds").build();
    private static final Metadata BULKHEAD_RUNNING_DURATION_METADATA = Metadata.builder().withName("ft.bulkhead.runningDuration").withUnit("nanoseconds").build();
    private static final Metadata BULKHEAD_WAITING_DURATION_METADATA = Metadata.builder().withName("ft.bulkhead.waitingDuration").withUnit("nanoseconds").build();
    private static final Tag RESULT_VALUE_RETURNED = new Tag("result", "valueReturned");
    private static final Tag RESULT_EXCEPTION_THROWN = new Tag("result", "exceptionThrown");
    private static final Tag FALLBACK_APPLIED = new Tag("fallback", "applied");
    private static final Tag FALLBACK_NOT_APPLIED = new Tag("fallback", "notApplied");
    private static final Tag FALLBACK_NOT_DEFINED = new Tag("fallback", "notDefined");
    private static final Tag RETRIED_TRUE = new Tag("retried", "true");
    private static final Tag RETRIED_FALSE = new Tag("retried", "false");
    private static final Tag RETRY_RESULT_VALUE_RETURNED = new Tag("retryResult", "valueReturned");
    private static final Tag RETRY_RESULT_EXCEPTION_NOT_RETRYABLE = new Tag("retryResult", "exceptionNotRetryable");
    private static final Tag RETRY_RESULT_MAX_RETRIES_REACHED = new Tag("retryResult", "maxRetriesReached");
    private static final Tag RETRY_RESULT_MAX_DURATION_REACHED = new Tag("retryResult", "maxDurationReached");
    private static final Tag TIMED_OUT_TRUE = new Tag("timedOut", "true");
    private static final Tag TIMED_OUT_FALSE = new Tag("timedOut", "false");
    private static final Tag CIRCUIT_BREAKER_RESULT_SUCCESS = new Tag("circuitBreakerResult", "success");
    private static final Tag CIRCUIT_BREAKER_RESULT_FAILURE = new Tag("circuitBreakerResult", "failure");
    private static final Tag CIRCUIT_BREAKER_RESULT_CB_OPEN = new Tag("circuitBreakerResult", "circuitBreakerOpen");
    private static final Tag CIRCUIT_BREAKER_STATE_CLOSED = new Tag("state", "closed");
    private static final Tag CIRCUIT_BREAKER_STATE_OPEN = new Tag("state", "open");
    private static final Tag CIRCUIT_BREAKER_STATE_HALF_OPEN = new Tag("state", "halfOpen");
    private static final Tag BULKHEAD_RESULT_ACCEPTED = new Tag("bulkheadResult", "accepted");
    private static final Tag BULKHEAD_RESULT_REJECTED = new Tag("bulkheadResult", "rejected");
    private static final Tag RATE_LIMIT_RESULT_PERMITTED = new Tag("rateLimitResult", "permitted");
    private static final Tag RATE_LIMIT_RESULT_REJECTED = new Tag("rateLimitResult", "rejected");
    private final MetricRegistry registry;
    private final Tag methodTag;

    public MicroProfileMetricsRecorder(MetricRegistry registry, MeteredOperation operation) {
        this.registry = registry;
        this.methodTag = new Tag("method", operation.name());
        this.registerMetrics(operation);
    }

    private void registerMetrics(MeteredOperation operation) {
        if (operation.hasFallback()) {
            this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, RESULT_VALUE_RETURNED, FALLBACK_NOT_APPLIED}).getCount();
            this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, RESULT_VALUE_RETURNED, FALLBACK_APPLIED}).getCount();
            this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, RESULT_EXCEPTION_THROWN, FALLBACK_NOT_APPLIED}).getCount();
            this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, RESULT_EXCEPTION_THROWN, FALLBACK_APPLIED}).getCount();
        } else {
            this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, RESULT_VALUE_RETURNED, FALLBACK_NOT_DEFINED}).getCount();
            this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, RESULT_EXCEPTION_THROWN, FALLBACK_NOT_DEFINED}).getCount();
        }
        if (operation.hasRetry()) {
            this.registry.counter("ft.retry.retries.total", new Tag[]{this.methodTag}).getCount();
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_FALSE, RETRY_RESULT_VALUE_RETURNED}).getCount();
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_FALSE, RETRY_RESULT_EXCEPTION_NOT_RETRYABLE}).getCount();
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_FALSE, RETRY_RESULT_MAX_RETRIES_REACHED}).getCount();
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_FALSE, RETRY_RESULT_MAX_DURATION_REACHED}).getCount();
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_TRUE, RETRY_RESULT_VALUE_RETURNED}).getCount();
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_TRUE, RETRY_RESULT_EXCEPTION_NOT_RETRYABLE}).getCount();
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_TRUE, RETRY_RESULT_MAX_RETRIES_REACHED}).getCount();
            this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, RETRIED_TRUE, RETRY_RESULT_MAX_DURATION_REACHED}).getCount();
        }
        if (operation.hasTimeout()) {
            this.registry.counter("ft.timeout.calls.total", new Tag[]{this.methodTag, TIMED_OUT_TRUE}).getCount();
            this.registry.counter("ft.timeout.calls.total", new Tag[]{this.methodTag, TIMED_OUT_FALSE}).getCount();
            this.registry.histogram(TIMEOUT_EXECUTION_DURATION_METADATA, new Tag[]{this.methodTag}).getCount();
        }
        if (operation.hasCircuitBreaker()) {
            this.registry.counter("ft.circuitbreaker.calls.total", new Tag[]{this.methodTag, CIRCUIT_BREAKER_RESULT_SUCCESS}).getCount();
            this.registry.counter("ft.circuitbreaker.calls.total", new Tag[]{this.methodTag, CIRCUIT_BREAKER_RESULT_FAILURE}).getCount();
            this.registry.counter("ft.circuitbreaker.calls.total", new Tag[]{this.methodTag, CIRCUIT_BREAKER_RESULT_CB_OPEN}).getCount();
            this.registry.counter("ft.circuitbreaker.opened.total", new Tag[]{this.methodTag}).getCount();
        }
        if (operation.hasBulkhead()) {
            this.registry.counter("ft.bulkhead.calls.total", new Tag[]{this.methodTag, BULKHEAD_RESULT_ACCEPTED}).getCount();
            this.registry.counter("ft.bulkhead.calls.total", new Tag[]{this.methodTag, BULKHEAD_RESULT_REJECTED}).getCount();
            this.registry.histogram(BULKHEAD_RUNNING_DURATION_METADATA, new Tag[]{this.methodTag}).getCount();
            if (operation.isAsynchronous()) {
                this.registry.histogram(BULKHEAD_WAITING_DURATION_METADATA, new Tag[]{this.methodTag}).getCount();
            }
        }
        if (operation.hasRateLimit()) {
            this.registry.counter("ft.ratelimit.calls.total", new Tag[]{this.methodTag, RATE_LIMIT_RESULT_PERMITTED}).getCount();
            this.registry.counter("ft.ratelimit.calls.total", new Tag[]{this.methodTag, RATE_LIMIT_RESULT_REJECTED}).getCount();
        }
    }

    private void registerGauge(BooleanSupplier supplier, String name, String unit, Tag ... tags) {
        this.registerGauge(() -> supplier.getAsBoolean() ? 1L : 0L, name, unit, tags);
    }

    private void registerGauge(LongSupplier supplier, String name, String unit, Tag ... tags) {
        Metadata metadata = Metadata.builder().withName(name).withUnit(unit).build();
        this.registry.gauge(metadata, supplier::getAsLong, tags);
    }

    @Override
    public void executionFinished(boolean succeeded, boolean fallbackDefined, boolean fallbackApplied) {
        Tag resultTag;
        Tag tag = resultTag = succeeded ? RESULT_VALUE_RETURNED : RESULT_EXCEPTION_THROWN;
        Tag fallbackTag = fallbackDefined ? (fallbackApplied ? FALLBACK_APPLIED : FALLBACK_NOT_APPLIED) : FALLBACK_NOT_DEFINED;
        this.registry.counter("ft.invocations.total", new Tag[]{this.methodTag, resultTag, fallbackTag}).inc();
    }

    @Override
    public void retryAttempted() {
        this.registry.counter("ft.retry.retries.total", new Tag[]{this.methodTag}).inc();
    }

    @Override
    public void retryValueReturned(boolean retried) {
        this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, retried ? RETRIED_TRUE : RETRIED_FALSE, RETRY_RESULT_VALUE_RETURNED}).inc();
    }

    @Override
    public void retryExceptionNotRetryable(boolean retried) {
        this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, retried ? RETRIED_TRUE : RETRIED_FALSE, RETRY_RESULT_EXCEPTION_NOT_RETRYABLE}).inc();
    }

    @Override
    public void retryMaxRetriesReached(boolean retried) {
        this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, retried ? RETRIED_TRUE : RETRIED_FALSE, RETRY_RESULT_MAX_RETRIES_REACHED}).inc();
    }

    @Override
    public void retryMaxDurationReached(boolean retried) {
        this.registry.counter("ft.retry.calls.total", new Tag[]{this.methodTag, retried ? RETRIED_TRUE : RETRIED_FALSE, RETRY_RESULT_MAX_DURATION_REACHED}).inc();
    }

    @Override
    public void timeoutFinished(boolean timedOut, long time) {
        this.registry.counter("ft.timeout.calls.total", new Tag[]{this.methodTag, timedOut ? TIMED_OUT_TRUE : TIMED_OUT_FALSE}).inc();
        this.registry.histogram(TIMEOUT_EXECUTION_DURATION_METADATA, new Tag[]{this.methodTag}).update(time);
    }

    @Override
    public void circuitBreakerFinished(CircuitBreakerEvents.Result result) {
        Tag circuitBreakerResultTag = null;
        switch (result) {
            case SUCCESS: {
                circuitBreakerResultTag = CIRCUIT_BREAKER_RESULT_SUCCESS;
                break;
            }
            case FAILURE: {
                circuitBreakerResultTag = CIRCUIT_BREAKER_RESULT_FAILURE;
                break;
            }
            case PREVENTED: {
                circuitBreakerResultTag = CIRCUIT_BREAKER_RESULT_CB_OPEN;
            }
        }
        this.registry.counter("ft.circuitbreaker.calls.total", new Tag[]{this.methodTag, circuitBreakerResultTag}).inc();
    }

    @Override
    public void circuitBreakerMovedToOpen() {
        this.registry.counter("ft.circuitbreaker.opened.total", new Tag[]{this.methodTag}).inc();
    }

    @Override
    public void registerCircuitBreakerIsClosed(BooleanSupplier supplier) {
        this.registerGauge(supplier, "ft.circuitbreaker.state.current", "none", this.methodTag, CIRCUIT_BREAKER_STATE_CLOSED);
    }

    @Override
    public void registerCircuitBreakerIsOpen(BooleanSupplier supplier) {
        this.registerGauge(supplier, "ft.circuitbreaker.state.current", "none", this.methodTag, CIRCUIT_BREAKER_STATE_OPEN);
    }

    @Override
    public void registerCircuitBreakerIsHalfOpen(BooleanSupplier supplier) {
        this.registerGauge(supplier, "ft.circuitbreaker.state.current", "none", this.methodTag, CIRCUIT_BREAKER_STATE_HALF_OPEN);
    }

    @Override
    public void registerCircuitBreakerTimeSpentInClosed(LongSupplier supplier) {
        this.registerGauge(supplier, "ft.circuitbreaker.state.total", "nanoseconds", this.methodTag, CIRCUIT_BREAKER_STATE_CLOSED);
    }

    @Override
    public void registerCircuitBreakerTimeSpentInOpen(LongSupplier supplier) {
        this.registerGauge(supplier, "ft.circuitbreaker.state.total", "nanoseconds", this.methodTag, CIRCUIT_BREAKER_STATE_OPEN);
    }

    @Override
    public void registerCircuitBreakerTimeSpentInHalfOpen(LongSupplier supplier) {
        this.registerGauge(supplier, "ft.circuitbreaker.state.total", "nanoseconds", this.methodTag, CIRCUIT_BREAKER_STATE_HALF_OPEN);
    }

    @Override
    public void bulkheadDecisionMade(boolean accepted) {
        Tag bulkheadResultTag = accepted ? BULKHEAD_RESULT_ACCEPTED : BULKHEAD_RESULT_REJECTED;
        this.registry.counter("ft.bulkhead.calls.total", new Tag[]{this.methodTag, bulkheadResultTag}).inc();
    }

    @Override
    public void registerBulkheadExecutionsRunning(LongSupplier supplier) {
        this.registerGauge(supplier, "ft.bulkhead.executionsRunning", "none", this.methodTag);
    }

    @Override
    public void registerBulkheadExecutionsWaiting(LongSupplier supplier) {
        this.registerGauge(supplier, "ft.bulkhead.executionsWaiting", "none", this.methodTag);
    }

    @Override
    public void updateBulkheadRunningDuration(long time) {
        this.registry.histogram(BULKHEAD_RUNNING_DURATION_METADATA, new Tag[]{this.methodTag}).update(time);
    }

    @Override
    public void updateBulkheadWaitingDuration(long time) {
        this.registry.histogram(BULKHEAD_WAITING_DURATION_METADATA, new Tag[]{this.methodTag}).update(time);
    }

    @Override
    public void rateLimitDecisionMade(boolean permitted) {
        Tag rateLimitResultTag = permitted ? RATE_LIMIT_RESULT_PERMITTED : RATE_LIMIT_RESULT_REJECTED;
        this.registry.counter("ft.ratelimit.calls.total", new Tag[]{this.methodTag, rateLimitResultTag}).inc();
    }
}

