/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi.openid.storage;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.RandomStringUtils;

public abstract class OpenIdStorageHandler {
    protected static final String PREFIX = "openid.";
    public static final String REQUEST_KEY = "REQUEST";
    public static final String STATE_KEY = "STATE";
    public static final String NONCE_KEY = "NONCE";

    public abstract String get(HttpServletRequest var1, HttpServletResponse var2, String var3);

    public abstract void set(HttpServletRequest var1, HttpServletResponse var2, String var3, String var4);

    public abstract void delete(HttpServletRequest var1, HttpServletResponse var2, String var3);

    public String getStoredState(HttpServletRequest request, HttpServletResponse response) {
        return this.get(request, response, STATE_KEY);
    }

    public String createNewState(HttpServletRequest request, HttpServletResponse response) {
        String state = RandomStringUtils.random((int)10, (boolean)true, (boolean)true);
        this.set(request, response, STATE_KEY, state);
        return state;
    }

    public String getStoredNonce(HttpServletRequest request, HttpServletResponse response) {
        return this.get(request, response, NONCE_KEY);
    }

    public String createNewNonce(HttpServletRequest request, HttpServletResponse response) {
        String nonce = RandomStringUtils.random((int)10, (boolean)true, (boolean)true);
        this.set(request, response, NONCE_KEY, nonce);
        return nonce;
    }
}

