/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.metrics.WicketMetricsSettings;
import org.aspectj.lang.ProceedingJoinPoint;

public class WicketMetrics {
    private static String filterName;
    private static final String APPLICATION_ERROR = "The application couldn't be resolved, please ensure to apply \"<aspect name=\"org.apache.wicket.metrics.aspects.WicketFilterInitAspect\" />\" to your aspects";
    public static final MetaDataKey<MetricRegistry> METRIC_REGISTRY;
    public static final MetaDataKey<WicketMetricsSettings> METRIC_SETTINGS;

    public Object measureTime(String name, ProceedingJoinPoint joinPoint) throws Throwable {
        return this.measureTime(name, joinPoint, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object measureTime(String name, ProceedingJoinPoint joinPoint, boolean renderClass) throws Throwable {
        WicketMetricsSettings settings = WicketMetrics.getSettings();
        MetricRegistry registry = WicketMetrics.getMetricRegistry();
        if (settings.isEnabled()) {
            Timer.Context context = registry.timer(settings.getPrefix() + name + (renderClass ? this.renderClassName(joinPoint) : "")).time();
            try {
                Object object = this.proceedSilent(joinPoint);
                return object;
            }
            finally {
                this.stopQuietly(context);
            }
        }
        return this.proceedSilent(joinPoint);
    }

    public void stopQuietly(Timer.Context context) {
        if (context != null) {
            context.stop();
        }
    }

    public Object count(String name, ProceedingJoinPoint joinPoint, CounterOperation counterOperation, Long value) throws Throwable {
        WicketMetricsSettings settings = WicketMetrics.getSettings();
        MetricRegistry registry = WicketMetrics.getMetricRegistry();
        if (settings.isEnabled()) {
            Counter counter = registry.counter(settings.getPrefix() + name + this.renderClassName(joinPoint));
            if (counterOperation == CounterOperation.INC) {
                counter.inc(value.longValue());
            } else {
                counter.dec(value.longValue());
            }
        }
        return this.proceedSilent(joinPoint);
    }

    public Object mark(String name, ProceedingJoinPoint joinPoint) throws Throwable {
        WicketMetricsSettings settings = WicketMetrics.getSettings();
        MetricRegistry registry = WicketMetrics.getMetricRegistry();
        if (settings.isEnabled()) {
            registry.meter(settings.getPrefix() + name + this.renderClassName(joinPoint)).mark();
        }
        return this.proceedSilent(joinPoint);
    }

    private Object proceedSilent(ProceedingJoinPoint joinPoint) throws Throwable {
        return joinPoint != null ? joinPoint.proceed() : null;
    }

    public String renderClassName(ProceedingJoinPoint joinPoint) {
        return joinPoint != null && joinPoint.getTarget() != null ? "/" + joinPoint.getTarget().getClass().getName().replace('.', '_') : "";
    }

    public static synchronized MetricRegistry getMetricRegistry() {
        Application application = Application.get((String)WicketMetrics.getFilterName());
        if (application == null) {
            throw new WicketRuntimeException(APPLICATION_ERROR);
        }
        MetricRegistry metricRegistry = (MetricRegistry)application.getMetaData(METRIC_REGISTRY);
        if (metricRegistry == null) {
            metricRegistry = new MetricRegistry();
            application.setMetaData(METRIC_REGISTRY, (Object)metricRegistry);
        }
        return metricRegistry;
    }

    public static synchronized WicketMetricsSettings getSettings() {
        Application application = Application.get((String)WicketMetrics.getFilterName());
        if (application == null) {
            throw new WicketRuntimeException(APPLICATION_ERROR);
        }
        WicketMetricsSettings wicketMetricsSettings = (WicketMetricsSettings)application.getMetaData(METRIC_SETTINGS);
        if (wicketMetricsSettings == null) {
            wicketMetricsSettings = new WicketMetricsSettings();
            wicketMetricsSettings.setPrefix(WicketMetrics.getFilterName());
            application.setMetaData(METRIC_SETTINGS, (Object)wicketMetricsSettings);
        }
        return wicketMetricsSettings;
    }

    public static String getFilterName() {
        return filterName;
    }

    public static void setFilterName(String filterName) {
        WicketMetrics.filterName = filterName;
    }

    static {
        METRIC_REGISTRY = new MetaDataKey<MetricRegistry>(){
            private static final long serialVersionUID = 1L;
        };
        METRIC_SETTINGS = new MetaDataKey<WicketMetricsSettings>(){
            private static final long serialVersionUID = 1L;
        };
    }

    public static enum CounterOperation {
        INC,
        DEC;

    }
}

