/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.Serializable;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.DelegatingPageStore;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.pageStore.SerializedPage;
import org.apache.wicket.pageStore.crypt.ICrypter;
import org.apache.wicket.util.lang.Args;

public class CryptingPageStore
extends DelegatingPageStore {
    private static final MetaDataKey<SessionData> KEY = new MetaDataKey<SessionData>(){
        private static final long serialVersionUID = 1L;
    };
    private final ICrypter crypter;
    private final Application application;

    public CryptingPageStore(IPageStore delegate, Application application) {
        super(delegate);
        this.application = (Application)Args.notNull((Object)application, (String)"application");
        this.crypter = this.newCrypter();
    }

    @Override
    public boolean supportsVersioning() {
        return true;
    }

    @Override
    public boolean canBeAsynchronous(IPageContext context) {
        this.getSessionData(context);
        return this.getDelegate().canBeAsynchronous(context);
    }

    private SessionData getSessionData(IPageContext context) {
        return context.getSessionData(KEY, () -> new SessionData(this.crypter.generateKey(this.application.getSecuritySettings().getRandomSupplier().getRandom())));
    }

    protected ICrypter newCrypter() {
        return this.application.getStoreSettings().getCrypter().get();
    }

    @Override
    public IManageablePage getPage(IPageContext context, int id) {
        IManageablePage page = this.getDelegate().getPage(context, id);
        if (page != null) {
            if (!(page instanceof SerializedPage)) {
                throw new WicketRuntimeException("CryptingPageStore expects serialized pages");
            }
            SerializedPage serializedPage = (SerializedPage)page;
            byte[] encrypted = serializedPage.getData();
            byte[] decrypted = this.getSessionData(context).decrypt(encrypted, this.crypter);
            page = new SerializedPage(page.getPageId(), serializedPage.getPageType(), decrypted);
        }
        return page;
    }

    @Override
    public void addPage(IPageContext context, IManageablePage page) {
        if (!(page instanceof SerializedPage)) {
            throw new WicketRuntimeException("CryptingPageStore works with serialized pages only");
        }
        SerializedPage serializedPage = (SerializedPage)page;
        byte[] decrypted = serializedPage.getData();
        byte[] encrypted = this.getSessionData(context).encrypt(decrypted, this.crypter, this.application.getSecuritySettings().getRandomSupplier().getRandom());
        page = new SerializedPage(page.getPageId(), serializedPage.getPageType(), encrypted);
        this.getDelegate().addPage(context, page);
    }

    private static class SessionData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final SecretKey key;

        public SessionData(SecretKey key) {
            Args.notNull((Object)key, (String)"key");
            this.key = key;
        }

        public byte[] encrypt(byte[] decrypted, ICrypter crypter, SecureRandom random) {
            return crypter.encrypt(decrypted, this.key, random);
        }

        public byte[] decrypt(byte[] encrypted, ICrypter crypter) {
            return crypter.decrypt(encrypted, this.key);
        }
    }
}

