/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command.store.protobuf;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.protobuf.BaseMessage;
import org.apache.activemq.protobuf.Buffer;

abstract class QueueEntryPBBase<T>
extends BaseMessage<T> {
    private long f_queueKey = 0L;
    private boolean b_queueKey;
    private long f_queueSeq = 0L;
    private boolean b_queueSeq;
    private long f_messageKey = 0L;
    private boolean b_messageKey;
    private int f_size = 0;
    private boolean b_size;
    private Buffer f_attachment = null;
    private boolean b_attachment;
    private int f_redeliveries = 0;
    private boolean b_redeliveries;
    private long f_expiration = 0L;
    private boolean b_expiration;
    private Buffer f_messageLocator = null;
    private boolean b_messageLocator;
    private List<Buffer> f_sender;

    QueueEntryPBBase() {
    }

    public boolean hasQueueKey() {
        return this.b_queueKey;
    }

    public long getQueueKey() {
        return this.f_queueKey;
    }

    public T setQueueKey(long queueKey) {
        this.loadAndClear();
        this.b_queueKey = true;
        this.f_queueKey = queueKey;
        return (T)this;
    }

    public void clearQueueKey() {
        this.loadAndClear();
        this.b_queueKey = false;
        this.f_queueKey = 0L;
    }

    public boolean hasQueueSeq() {
        return this.b_queueSeq;
    }

    public long getQueueSeq() {
        return this.f_queueSeq;
    }

    public T setQueueSeq(long queueSeq) {
        this.loadAndClear();
        this.b_queueSeq = true;
        this.f_queueSeq = queueSeq;
        return (T)this;
    }

    public void clearQueueSeq() {
        this.loadAndClear();
        this.b_queueSeq = false;
        this.f_queueSeq = 0L;
    }

    public boolean hasMessageKey() {
        return this.b_messageKey;
    }

    public long getMessageKey() {
        return this.f_messageKey;
    }

    public T setMessageKey(long messageKey) {
        this.loadAndClear();
        this.b_messageKey = true;
        this.f_messageKey = messageKey;
        return (T)this;
    }

    public void clearMessageKey() {
        this.loadAndClear();
        this.b_messageKey = false;
        this.f_messageKey = 0L;
    }

    public boolean hasSize() {
        return this.b_size;
    }

    public int getSize() {
        return this.f_size;
    }

    public T setSize(int size) {
        this.loadAndClear();
        this.b_size = true;
        this.f_size = size;
        return (T)this;
    }

    public void clearSize() {
        this.loadAndClear();
        this.b_size = false;
        this.f_size = 0;
    }

    public boolean hasAttachment() {
        return this.b_attachment;
    }

    public Buffer getAttachment() {
        return this.f_attachment;
    }

    public T setAttachment(Buffer attachment) {
        this.loadAndClear();
        this.b_attachment = true;
        this.f_attachment = attachment;
        return (T)this;
    }

    public void clearAttachment() {
        this.loadAndClear();
        this.b_attachment = false;
        this.f_attachment = null;
    }

    public boolean hasRedeliveries() {
        return this.b_redeliveries;
    }

    public int getRedeliveries() {
        return this.f_redeliveries;
    }

    public T setRedeliveries(int redeliveries) {
        this.loadAndClear();
        this.b_redeliveries = true;
        this.f_redeliveries = redeliveries;
        return (T)this;
    }

    public void clearRedeliveries() {
        this.loadAndClear();
        this.b_redeliveries = false;
        this.f_redeliveries = 0;
    }

    public boolean hasExpiration() {
        return this.b_expiration;
    }

    public long getExpiration() {
        return this.f_expiration;
    }

    public T setExpiration(long expiration) {
        this.loadAndClear();
        this.b_expiration = true;
        this.f_expiration = expiration;
        return (T)this;
    }

    public void clearExpiration() {
        this.loadAndClear();
        this.b_expiration = false;
        this.f_expiration = 0L;
    }

    public boolean hasMessageLocator() {
        return this.b_messageLocator;
    }

    public Buffer getMessageLocator() {
        return this.f_messageLocator;
    }

    public T setMessageLocator(Buffer messageLocator) {
        this.loadAndClear();
        this.b_messageLocator = true;
        this.f_messageLocator = messageLocator;
        return (T)this;
    }

    public void clearMessageLocator() {
        this.loadAndClear();
        this.b_messageLocator = false;
        this.f_messageLocator = null;
    }

    public boolean hasSender() {
        return this.f_sender != null && !this.f_sender.isEmpty();
    }

    public List<Buffer> getSenderList() {
        if (this.f_sender == null) {
            this.f_sender = new ArrayList<Buffer>();
        }
        return this.f_sender;
    }

    public T setSenderList(List<Buffer> sender) {
        this.loadAndClear();
        this.f_sender = sender;
        return (T)this;
    }

    public int getSenderCount() {
        if (this.f_sender == null) {
            return 0;
        }
        return this.f_sender.size();
    }

    public Buffer getSender(int index) {
        if (this.f_sender == null) {
            return null;
        }
        return this.f_sender.get(index);
    }

    public T setSender(int index, Buffer value) {
        this.loadAndClear();
        this.getSenderList().set(index, value);
        return (T)this;
    }

    public T addSender(Buffer value) {
        this.loadAndClear();
        this.getSenderList().add(value);
        return (T)this;
    }

    public T addAllSender(Iterable<? extends Buffer> collection) {
        this.loadAndClear();
        BaseMessage.addAll(collection, this.getSenderList());
        return (T)this;
    }

    public void clearSender() {
        this.loadAndClear();
        this.f_sender = null;
    }
}

