/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.replay.ReplayManager;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.json.JsonArrayBuilder;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressControlImpl
extends AbstractControl
implements AddressControl {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private AddressInfo addressInfo;
    private final ActiveMQServer server;
    private final PagingManager pagingManager;
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private final SecurityStore securityStore;
    private final ManagementService managementService;

    public AddressControlImpl(AddressInfo addressInfo, ActiveMQServer server, PagingManager pagingManager, StorageManager storageManager, HierarchicalRepository<Set<Role>> securityRepository, SecurityStore securityStore, ManagementService managementService) throws Exception {
        super(AddressControl.class, storageManager);
        this.server = server;
        this.addressInfo = addressInfo;
        this.pagingManager = pagingManager;
        this.securityRepository = securityRepository;
        this.securityStore = securityStore;
        this.managementService = managementService;
    }

    public long getId() {
        return this.addressInfo.getId();
    }

    public String getAddress() {
        return this.addressInfo.getName().toString();
    }

    public String[] getRoutingTypes() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRoutingTypes((Object)this.addressInfo);
        }
        EnumSet<RoutingType> routingTypes = this.addressInfo.getRoutingTypes();
        String[] result = new String[routingTypes.size()];
        int i = 0;
        for (RoutingType routingType : routingTypes) {
            result[i++] = routingType.toString();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRoutingTypesAsJSON() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRoutingTypesAsJSON((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            String[] routingTypes;
            JsonArrayBuilder json = JsonLoader.createArrayBuilder();
            for (String routingType : routingTypes = this.getRoutingTypes()) {
                json.add(routingType);
            }
            String string = json.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getRemoteQueueNames() {
        return this.getQueueNames(SearchType.REMOTE);
    }

    public String[] getQueueNames() {
        return this.getQueueNames(SearchType.LOCAL);
    }

    public String[] getAllQueueNames() {
        return this.getQueueNames(SearchType.ALL);
    }

    private String[] getQueueNames(SearchType searchType) {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getQueueNames((Object)this.addressInfo, (Object[])new Object[]{searchType});
        }
        this.clearIO();
        try {
            Bindings bindings = this.server.getPostOffice().lookupBindingsForAddress(this.addressInfo.getName());
            if (bindings != null) {
                ArrayList<String> queueNames = new ArrayList<String>();
                for (Binding binding : bindings.getBindings()) {
                    if (!(binding instanceof QueueBinding) || searchType != SearchType.ALL && (searchType != SearchType.LOCAL || !binding.isLocal()) && (searchType != SearchType.REMOTE || !(binding instanceof RemoteQueueBinding))) continue;
                    queueNames.add(binding.getUniqueName().toString());
                }
                String[] stringArray = queueNames.toArray(new String[queueNames.size()]);
                return stringArray;
            }
            String[] stringArray = new String[]{};
            return stringArray;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getBindingNames() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getBindingNames((Object)this.addressInfo);
        }
        try {
            this.clearIO();
            Bindings bindings = this.server.getPostOffice().lookupBindingsForAddress(this.addressInfo.getName());
            if (bindings != null) {
                String[] bindingNames = new String[bindings.getBindings().size()];
                int i = 0;
                for (Binding binding : bindings.getBindings()) {
                    bindingNames[i++] = binding.getUniqueName().toString();
                }
                String[] stringArray = bindingNames;
                return stringArray;
            }
            String[] stringArray = new String[]{};
            return stringArray;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getRoles() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRoles((Object)this.addressInfo, (Object[])new Object[0]);
        }
        this.clearIO();
        try {
            Set<Role> roles = this.securityRepository.getMatch(this.addressInfo.getName().toString());
            Object[] objRoles = new Object[roles.size()];
            int i = 0;
            for (Role role : roles) {
                objRoles[i++] = CheckType.asObjectArray(role);
            }
            Object[] objectArray = objRoles;
            return objectArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRolesAsJSON() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRolesAsJSON((Object)this.addressInfo, (Object[])new Object[0]);
        }
        this.clearIO();
        try {
            JsonArrayBuilder json = JsonLoader.createArrayBuilder();
            Set<Role> roles = this.securityRepository.getMatch(this.addressInfo.getName().toString());
            for (Role role : roles) {
                json.add((JsonValue)role.toJson());
            }
            String string = json.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumberOfBytesPerPage() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getNumberOfBytesPerPage((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore == null) {
                long l = 0L;
                return l;
            }
            long l = pagingStore.getPageSizeBytes();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    private PagingStore getPagingStore() throws Exception {
        return this.pagingManager.getPageStore(this.addressInfo.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAddressSize() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getAddressSize((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore == null) {
                long l = 0L;
                return l;
            }
            long l = pagingStore.getAddressSize();
            return l;
        }
        catch (Exception e) {
            logger.debug("Failed to get address size", (Throwable)e);
            long l = -1L;
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getMaxPageReadBytes() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMaxPageReadBytes((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore == null) {
                int n = 0;
                return n;
            }
            int n = pagingStore.getMaxPageReadBytes();
            return n;
        }
        catch (Exception e) {
            logger.debug("Failed to get attribute value", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getMaxPageReadMessages() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMaxPageReadMessages((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore == null) {
                int n = 0;
                return n;
            }
            int n = pagingStore.getMaxPageReadMessages();
            return n;
        }
        catch (Exception e) {
            logger.debug("Failed to get attribute value", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getPrefetchPageBytes() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getPrefetchPageBytes((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore == null) {
                int n = 0;
                return n;
            }
            int n = pagingStore.getPrefetchPageBytes();
            return n;
        }
        catch (Exception e) {
            logger.debug("Failed to get attribute value", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getPrefetchPageMessages() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getPrefetchPageMessages((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore == null) {
                int n = 0;
                return n;
            }
            int n = pagingStore.getPrefetchPageMessages();
            return n;
        }
        catch (Exception e) {
            logger.debug("Failed to get attribute value", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void schedulePageCleanup() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.schedulePageCleanup((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore == null) {
                return;
            }
            pagingStore.getCursorProvider().scheduleCleanup();
        }
        catch (Exception e) {
            logger.debug("Failed to schedule pageCleanup", (Throwable)e);
            throw e;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Deprecated
    public long getNumberOfMessages() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getNumberOfMessages((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            long l = this.getMessageCount();
            return l;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isPaging() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isPaging((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = pagingStore.isPaging();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getAddressLimitPercent() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getAddressLimitPercent((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore == null) {
                int n = 0;
                return n;
            }
            int n = pagingStore.getAddressLimitPercent();
            return n;
        }
        catch (Exception e) {
            logger.debug("Failed to get address limit %", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean block() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.block((Object)this.addressInfo);
        }
        this.clearIO();
        boolean result = false;
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore != null) {
                pagingStore.block();
                result = true;
            }
        }
        catch (Exception e) {
            logger.debug("Failed to block", (Throwable)e);
        }
        finally {
            this.blockOnIO();
        }
        return result;
    }

    public void unblock() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.unBlock((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore != null) {
                pagingStore.unblock();
            }
        }
        catch (Exception e) {
            logger.debug("Failed to unblock", (Throwable)e);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumberOfPages() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getNumberOfPages((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pageStore = this.getPagingStore();
            if (pageStore == null || !pageStore.isStorePaging()) {
                long l = 0L;
                return l;
            }
            long l = pageStore.getNumberOfPages();
            return l;
        }
        catch (Exception e) {
            logger.debug("Failed to get number of pages", (Throwable)e);
            long l = -1L;
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getMessageCount() {
        long l;
        block9: {
            AutoCloseable lock = this.server.managementLock();
            try {
                if (AuditLogger.isBaseLoggingEnabled()) {
                    AuditLogger.getMessageCount((Object)this.addressInfo);
                }
                l = this.getMessageCount(DurabilityType.ALL);
                if (lock == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            lock.close();
        }
        return l;
    }

    public long getQueueCount() {
        long l;
        block9: {
            AutoCloseable lock = this.server.managementLock();
            try {
                if (AuditLogger.isBaseLoggingEnabled()) {
                    AuditLogger.getQueueCount((Object)this.addressInfo);
                }
                l = this.getQueueNames(SearchType.LOCAL).length;
                if (lock == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            lock.close();
        }
        return l;
    }

    public long getRoutedMessageCount() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRoutedMessageCount((Object)this.addressInfo);
        }
        return this.addressInfo.getRoutedMessageCount();
    }

    public long getUnRoutedMessageCount() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getUnRoutedMessageCount((Object)this.addressInfo);
        }
        return this.addressInfo.getUnRoutedMessageCount();
    }

    public String sendMessage(Map<String, String> headers, int type, String body, boolean durable, String user, String password) throws Exception {
        return this.sendMessage(headers, type, body, durable, user, password, false);
    }

    public String sendMessage(Map<String, String> headers, int type, String body, boolean durable, String user, String password, boolean createMessageId) throws Exception {
        try (AutoCloseable lock = this.server.managementLock();){
            if (AuditLogger.isBaseLoggingEnabled()) {
                AuditLogger.sendMessageThroughManagement((Object)this, (Object[])new Object[]{headers, type, body, durable, user, "****"});
            }
            try {
                String string = this.sendMessage(this.addressInfo.getName(), this.server, headers, type, body, durable, user, password, createMessageId);
                return string;
            }
            catch (Exception e) {
                logger.debug("Failed to sendMessage", (Throwable)e);
                throw new IllegalStateException(e.getMessage());
            }
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AddressControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(AddressControl.class);
    }

    public void pause() {
        this.pause(false);
    }

    public void pause(boolean persist) {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.pause((Object)this.addressInfo, (Object[])new Object[0]);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.addressInfo.setPostOffice(this.server.getPostOffice());
            this.addressInfo.setStorageManager(this.server.getStorageManager());
            this.addressInfo.pause(persist);
            if (AuditLogger.isResourceLoggingEnabled()) {
                AuditLogger.pauseAddressSuccess((String)this.addressInfo.getName().toString());
            }
        }
        catch (Exception e) {
            if (AuditLogger.isResourceLoggingEnabled()) {
                AuditLogger.pauseAddressFailure((String)this.addressInfo.getName().toString());
            }
            throw e;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resume() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.resume((Object)this.addressInfo);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.addressInfo.setPostOffice(this.server.getPostOffice());
            this.addressInfo.setStorageManager(this.server.getStorageManager());
            this.addressInfo.resume();
            if (AuditLogger.isResourceLoggingEnabled()) {
                AuditLogger.resumeAddressSuccess((String)this.addressInfo.getName().toString());
            }
        }
        catch (Exception e) {
            if (AuditLogger.isResourceLoggingEnabled()) {
                AuditLogger.resumeAddressFailure((String)this.addressInfo.getName().toString());
            }
            throw e;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isPaused() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isPaused((Object)this.addressInfo);
        }
        return this.addressInfo.isPaused();
    }

    public boolean isRetroactiveResource() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isRetroactiveResource((Object)this.addressInfo);
        }
        return ResourceNames.isRetroactiveResource((String)this.server.getInternalNamingPrefix(), (SimpleString)this.addressInfo.getName());
    }

    public long getCurrentDuplicateIdCacheSize() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getCurrentDuplicateIdCacheSize((Object)this.addressInfo);
        }
        DuplicateIDCache cache = (DuplicateIDCache)((PostOfficeImpl)this.server.getPostOffice()).getDuplicateIDCaches().get(this.addressInfo.getName());
        try {
            if (cache != null) {
                return cache.getMap().size();
            }
        }
        catch (Exception e) {
            logger.debug("Failed to get duplicate ID cache size", (Throwable)e);
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean clearDuplicateIdCache() {
        try (AutoCloseable lock = this.server.managementLock();){
            if (AuditLogger.isBaseLoggingEnabled()) {
                AuditLogger.clearDuplicateIdCache((Object)this.addressInfo);
            }
            DuplicateIDCache cache = (DuplicateIDCache)((PostOfficeImpl)this.server.getPostOffice()).getDuplicateIDCaches().get(this.addressInfo.getName());
            try {
                if (cache != null) {
                    cache.clear();
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                logger.debug("Failed to clear duplicate ID cache", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean isAutoCreated() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isAutoCreated((Object)this.addressInfo);
        }
        return this.addressInfo.isAutoCreated();
    }

    public boolean isInternal() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isInternal((Object)this.addressInfo);
        }
        return this.addressInfo.isInternal();
    }

    public boolean isTemporary() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isTemporary((Object)this.addressInfo);
        }
        return this.addressInfo.isTemporary();
    }

    public long purge() throws Exception {
        try (AutoCloseable lock = this.server.managementLock();){
            if (AuditLogger.isBaseLoggingEnabled()) {
                AuditLogger.purge((Object)this.addressInfo);
            }
            this.clearIO();
            long totalMsgs = 0L;
            try {
                Bindings bindings = this.server.getPostOffice().lookupBindingsForAddress(this.addressInfo.getName());
                if (bindings != null) {
                    for (Binding binding : bindings.getBindings()) {
                        if (!(binding instanceof QueueBinding)) continue;
                        QueueBinding queueBinding = (QueueBinding)binding;
                        totalMsgs += (long)queueBinding.getQueue().deleteMatchingReferences(500, null, AckReason.KILLED);
                    }
                }
                if (AuditLogger.isResourceLoggingEnabled()) {
                    AuditLogger.purgeAddressSuccess((String)this.addressInfo.getName().toString());
                }
            }
            catch (Throwable t) {
                if (AuditLogger.isResourceLoggingEnabled()) {
                    AuditLogger.purgeAddressFailure((String)this.addressInfo.getName().toString());
                }
                throw new IllegalStateException(t.getMessage());
            }
            finally {
                this.blockOnIO();
            }
            long l = totalMsgs;
            return l;
        }
    }

    public void replay(String target, String filter) throws Exception {
        this.server.replay(null, null, this.getAddress(), target, filter);
    }

    public void replay(String startScan, String endScan, String target, String filter) throws Exception {
        SimpleDateFormat format = ReplayManager.newRetentionSimpleDateFormat();
        Date startScanDate = format.parse(startScan);
        Date endScanDate = format.parse(endScan);
        this.server.replay(startScanDate, endScanDate, this.getAddress(), target, filter);
    }

    private long getMessageCount(DurabilityType durability) {
        long l;
        block9: {
            AutoCloseable lock = this.server.managementLock();
            try {
                long count = 0L;
                for (String queueName : this.getQueueNames()) {
                    Queue queue = this.server.locateQueue(queueName);
                    if (queue == null || durability != DurabilityType.ALL && (durability != DurabilityType.DURABLE || !queue.isDurable()) && (durability != DurabilityType.NON_DURABLE || queue.isDurable())) continue;
                    count += queue.getMessageCount();
                }
                l = count;
                if (lock == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            lock.close();
        }
        return l;
    }

    private void checkStarted() {
        if (!this.server.getPostOffice().isStarted()) {
            throw new IllegalStateException("Broker is not started. Queues can not be managed yet");
        }
    }

    static enum SearchType {
        LOCAL,
        REMOTE,
        ALL;

    }

    private static enum DurabilityType {
        ALL,
        DURABLE,
        NON_DURABLE;

    }
}

