/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.codegentest;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class CustomDecimal
implements Comparable<CustomDecimal> {
    private final BigDecimal internalValue;

    public CustomDecimal(BigInteger value, int scale) {
        this.internalValue = new BigDecimal(value, scale);
    }

    public byte[] toByteArray(int scale) {
        BigDecimal correctlyScaledValue = scale != this.internalValue.scale() ? this.internalValue.setScale(scale, RoundingMode.HALF_UP) : this.internalValue;
        return correctlyScaledValue.unscaledValue().toByteArray();
    }

    int signum() {
        return this.internalValue.signum();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomDecimal that = (CustomDecimal)o;
        return this.internalValue.equals(that.internalValue);
    }

    public int hashCode() {
        return this.internalValue.hashCode();
    }

    @Override
    public int compareTo(CustomDecimal o) {
        return this.internalValue.compareTo(o.internalValue);
    }
}

