/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.map.DefaultEntityResultSegment;
import org.apache.cayenne.map.DefaultScalarResultSegment;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ObjectSelectMetadata;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.ScalarResultSegment;

class ColumnSelectMetadata
extends ObjectSelectMetadata {
    private static final long serialVersionUID = -3622675304651257963L;
    private static final ScalarResultSegment SCALAR_RESULT_SEGMENT = new DefaultScalarResultSegment(null, -1);
    private static final EntityResultSegment ENTITY_RESULT_SEGMENT = new DefaultEntityResultSegment(null, null, -1);
    private boolean isSingleResultSetMapping;
    private boolean suppressingDistinct;
    private Function<?, ?> resultMapper;

    ColumnSelectMetadata() {
    }

    boolean resolve(Object root, EntityResolver resolver, ColumnSelect<?> query) {
        if (super.resolve(root, resolver)) {
            if (this.cacheStrategy != null && this.cacheStrategy != QueryCacheStrategy.NO_CACHE) {
                this.cacheKey = this.makeCacheKey(query, resolver);
            }
            this.resolveAutoAliases(query);
            this.buildResultSetMappingForColumns(query);
            this.isSingleResultSetMapping = query.isSingleColumn();
            return true;
        }
        return false;
    }

    @Override
    protected void resolveAutoAliases(FluentSelect<?> query) {
        super.resolveAutoAliases(query);
        this.resolveColumnsAliases(query);
    }

    protected void resolveColumnsAliases(FluentSelect<?> query) {
        Collection<Property<?>> columns = query.getColumns();
        if (columns != null) {
            for (Property<?> property : columns) {
                Expression propertyExpression = property.getExpression();
                if (propertyExpression == null) continue;
                this.resolveAutoAliases(propertyExpression);
            }
        }
    }

    @Override
    public Map<String, String> getPathSplitAliases() {
        return this.pathSplitAliases != null ? this.pathSplitAliases : Collections.emptyMap();
    }

    private void buildResultSetMappingForColumns(ColumnSelect<?> query) {
        if (query.getColumns() == null || query.getColumns().isEmpty()) {
            return;
        }
        this.resultSetMapping = new ArrayList(query.getColumns().size());
        for (Property<?> column : query.getColumns()) {
            Expression exp = column.getExpression();
            boolean fullObject = false;
            if (exp.getType() == 26) {
                Object rel = exp.evaluate(this.getObjEntity());
                fullObject = rel instanceof ObjRelationship && !((ObjRelationship)rel).isToMany();
            } else if (exp.getType() == 47) {
                fullObject = true;
            }
            if (fullObject) {
                this.resultSetMapping.add(ENTITY_RESULT_SEGMENT);
                continue;
            }
            this.resultSetMapping.add(SCALAR_RESULT_SEGMENT);
        }
    }

    @Override
    public boolean isSingleResultSetMapping() {
        return this.isSingleResultSetMapping;
    }

    @Override
    public boolean isSuppressingDistinct() {
        return this.suppressingDistinct;
    }

    public void setSuppressingDistinct(boolean suppressingDistinct) {
        this.suppressingDistinct = suppressingDistinct;
    }

    void setResultMapper(Function<?, ?> resultMapper) {
        this.resultMapper = this.resultMapper != null ? this.resultMapper.andThen(resultMapper) : resultMapper;
    }

    @Override
    public Function<?, ?> getResultMapper() {
        return this.resultMapper;
    }
}

