/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.generic;

import org.apache.cayenne.Fault;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.generic.DataObjectBaseProperty;

class DataObjectToManyProperty
extends DataObjectBaseProperty
implements ToManyProperty {
    protected ObjRelationship relationship;
    protected String reverseName;
    protected String reverseDbPath;
    protected ClassDescriptor targetDescriptor;
    protected Fault fault;

    DataObjectToManyProperty(ObjRelationship relationship, ClassDescriptor targetDescriptor, Fault fault) {
        this.relationship = relationship;
        this.targetDescriptor = targetDescriptor;
        this.reverseName = relationship.getReverseRelationshipName();
        this.fault = fault;
    }

    @Override
    public ArcProperty getComplimentaryReverseArc() {
        return this.reverseName != null ? (ArcProperty)this.targetDescriptor.getProperty(this.reverseName) : null;
    }

    @Override
    public ClassDescriptor getTargetDescriptor() {
        return this.targetDescriptor;
    }

    @Override
    public String getComplimentaryReverseDbRelationshipPath() {
        if (this.reverseDbPath == null) {
            this.reverseDbPath = this.relationship.getReverseDbRelationshipPath();
        }
        return this.reverseDbPath;
    }

    @Override
    public String getName() {
        return this.relationship.getName();
    }

    @Override
    public ObjRelationship getRelationship() {
        return this.relationship;
    }

    @Override
    public void addTarget(Object source, Object target, boolean setReverse) throws PropertyException {
        try {
            this.toDataObject(source).addToManyTarget(this.getName(), this.toDataObject(target), setReverse);
        }
        catch (Throwable th) {
            throw new PropertyException("Error setting to-many DataObject property: " + this.getName(), (PropertyDescriptor)this, source, th, new Object[0]);
        }
    }

    @Override
    public void removeTarget(Object source, Object target, boolean setReverse) throws PropertyException {
        try {
            this.toDataObject(source).removeToManyTarget(this.getName(), this.toDataObject(target), setReverse);
        }
        catch (Throwable th) {
            throw new PropertyException("Error unsetting to-many DataObject property: " + this.getName(), (PropertyDescriptor)this, source, th, new Object[0]);
        }
    }

    @Override
    public void injectValueHolder(Object object) throws PropertyException {
        if (this.readPropertyDirectly(object) == null) {
            this.writePropertyDirectly(object, null, this.fault.resolveFault((Persistent)object, this.getName()));
        }
    }

    @Override
    public boolean isFault(Object source) {
        return this.readPropertyDirectly(source) instanceof Fault;
    }

    @Override
    public boolean visit(PropertyVisitor visitor) {
        return visitor.visitToMany(this);
    }

    @Override
    public void invalidate(Object object) {
        Object value = this.readPropertyDirectly(object);
        if (!(value instanceof Fault)) {
            if (value instanceof ValueHolder) {
                ((ValueHolder)value).invalidate();
            } else {
                this.writePropertyDirectly(object, null, this.fault);
            }
        }
    }

    @Override
    public void addTargetDirectly(Object source, Object target) throws PropertyException {
        this.addTarget(source, target, false);
    }

    @Override
    public void removeTargetDirectly(Object source, Object target) throws PropertyException {
        this.removeTarget(source, target, false);
    }
}

