/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action.dbimport;

import java.awt.event.ActionEvent;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.dbimport.TreeManipulationAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;

public class AddCatalogAction
extends TreeManipulationAction {
    private static final String ACTION_NAME = "Add Catalog";
    private static final String ICON_NAME = "icon-dbi-catalog.png";

    public AddCatalogAction(Application application) {
        super(ACTION_NAME, application);
        this.insertableNodeClass = Catalog.class;
    }

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    @Override
    public void performAction(ActionEvent e) {
        ReverseEngineering reverseEngineeringOld = this.prepareElements();
        Catalog newCatalog = new Catalog(this.name);
        if (this.canBeInserted(this.selectedElement)) {
            ((ReverseEngineering)this.selectedElement.getUserObject()).addCatalog(newCatalog);
            this.selectedElement.add(new DbImportTreeNode(newCatalog));
            this.updateSelected = true;
        } else if (this.canInsert()) {
            ((ReverseEngineering)this.parentElement.getUserObject()).addCatalog(newCatalog);
            this.parentElement.add(new DbImportTreeNode(newCatalog));
            this.updateSelected = false;
        }
        this.completeInserting(reverseEngineeringOld);
    }
}

