/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.util.LocalizedStringsHandler;
import org.apache.cayenne.util.Util;

public class AboutDialog
extends JFrame
implements FocusListener,
KeyListener,
MouseListener {
    private static String infoString;
    private static ImageIcon logoImage;

    static ImageIcon getLogoImage() {
        if (logoImage == null) {
            logoImage = ModelerUtil.buildIcon("logo.jpg");
        }
        return logoImage;
    }

    static String getInfoString() {
        if (infoString == null) {
            double maxMemory = (double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0;
            double totalMemory = (double)Runtime.getRuntime().totalMemory() / 1024.0 / 1024.0;
            double freeMemory = (double)Runtime.getRuntime().freeMemory() / 1024.0 / 1024.0;
            StringBuilder buffer = new StringBuilder();
            buffer.append("<html>");
            buffer.append("<font size='-1' face='Arial,Helvetica'>");
            buffer.append(String.format(ModelerUtil.getProperty("cayenne.modeler.about.info"), LocalDate.now().getYear()));
            buffer.append("</font>");
            buffer.append("<font size='-2' face='Arial,Helvetica'>");
            buffer.append("<br>JVM: ").append(System.getProperty("java.vm.name")).append(" ").append(System.getProperty("java.version"));
            buffer.append(String.format("<br>Memory: used %.2f MB, max %.2f MB", totalMemory - freeMemory, maxMemory));
            String version = LocalizedStringsHandler.getString("cayenne.version");
            buffer.append("<br>Version: ").append(version);
            String buildDate = LocalizedStringsHandler.getString("cayenne.build.date");
            if (!Util.isEmptyString(buildDate)) {
                buffer.append(" (").append(buildDate).append(")");
            }
            buffer.append("</font>");
            buffer.append("</html>");
            infoString = buffer.toString();
        }
        return infoString;
    }

    public AboutDialog() {
        FlowLayout flowLayout = new FlowLayout();
        this.getContentPane().setLayout(flowLayout);
        this.getContentPane().setBackground(Color.WHITE);
        this.setUndecorated(true);
        this.setDefaultCloseOperation(2);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.setLocationRelativeTo(null);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBackground(Color.WHITE);
        this.getContentPane().add(panel);
        JLabel image = new JLabel(AboutDialog.getLogoImage());
        panel.add((Component)image, new GridBagConstraints());
        JLabel license = new JLabel();
        GridBagConstraints gridBagConstraints_1 = new GridBagConstraints();
        gridBagConstraints_1.fill = 2;
        gridBagConstraints_1.anchor = 18;
        gridBagConstraints_1.gridx = 0;
        gridBagConstraints_1.gridy = 1;
        gridBagConstraints_1.insets = new Insets(0, 12, 0, 0);
        panel.add((Component)license, gridBagConstraints_1);
        license.setText("<html><font size='-1' face='Arial,Helvetica'>Available under the Apache license.</font></html>");
        JLabel info = new JLabel();
        GridBagConstraints gridBagConstraints_2 = new GridBagConstraints();
        gridBagConstraints_2.fill = 2;
        gridBagConstraints_2.anchor = 18;
        gridBagConstraints_2.gridx = 0;
        gridBagConstraints_2.gridy = 2;
        gridBagConstraints_2.insets = new Insets(6, 12, 12, 12);
        panel.add((Component)info, gridBagConstraints_2);
        info.setText(AboutDialog.getInfoString());
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.dispose();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.dispose();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.dispose();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

