/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db.load;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.dbsync.reverse.dbload.DefaultDbLoaderDelegate;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.db.load.DbLoaderContext;

final class LoaderDelegate
extends DefaultDbLoaderDelegate {
    private DbLoaderContext context;

    LoaderDelegate(DbLoaderContext dbLoaderContext) {
        this.context = dbLoaderContext;
    }

    @Override
    public void dbEntityAdded(DbEntity entity) {
        this.checkCanceled();
        this.context.setStatusNote("Importing table '" + entity.getName() + "'...");
    }

    @Override
    public void dbEntityRemoved(DbEntity entity) {
        this.checkCanceled();
        if (this.context.isExistingDataMap()) {
            this.context.getProjectController().fireDbEntityEvent(new EntityEvent((Object)Application.getFrame(), (Entity)entity, 3));
        }
    }

    @Override
    public boolean dbRelationship(DbEntity entity) {
        this.checkCanceled();
        this.context.setStatusNote("Load relationships for '" + entity.getName() + "'...");
        return true;
    }

    @Override
    public boolean dbRelationshipLoaded(DbEntity entity, DbRelationship relationship) {
        this.checkCanceled();
        this.context.setStatusNote("Load relationship: '" + entity.getName() + "'; '" + relationship.getName() + "'...");
        return true;
    }

    private void checkCanceled() {
        if (this.context.isStopping()) {
            throw new CayenneRuntimeException("Reengineering was canceled.", new Object[0]);
        }
    }
}

