/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class RelationshipUndoableEdit
extends CayenneUndoableEdit {
    private static final long serialVersionUID = -1864303176024098961L;
    private Relationship relationship;
    private Relationship prevRelationship;
    private ProjectController projectController = Application.getInstance().getFrameController().getProjectController();
    private boolean useDb;

    public RelationshipUndoableEdit(Relationship relationship) {
        this.relationship = relationship;
        this.useDb = relationship instanceof DbRelationship;
        this.prevRelationship = this.copyRelationship(relationship);
    }

    @Override
    public void redo() throws CannotRedoException {
        this.fireRelationshipEvent(this.relationship, this.prevRelationship);
    }

    @Override
    public void undo() throws CannotUndoException {
        this.fireRelationshipEvent(this.prevRelationship, this.relationship);
    }

    private void fireRelationshipEvent(Relationship relToFire, Relationship currRel) {
        if (this.useDb) {
            this.fireDbRelationshipEvent(relToFire, currRel);
        } else {
            this.fireObjRelationshipEvent(relToFire, currRel);
        }
    }

    private void fireDbRelationshipEvent(Relationship relToFire, Relationship currRel) {
        DbEntity dbEntity = ((DbRelationship)currRel).getSourceEntity();
        dbEntity.removeRelationship(currRel.getName());
        dbEntity.addRelationship(relToFire);
        this.projectController.fireDbRelationshipEvent(new RelationshipEvent((Object)this, relToFire, relToFire.getSourceEntity(), 2));
    }

    private void fireObjRelationshipEvent(Relationship relToFire, Relationship currRel) {
        ObjEntity objEntity = ((ObjRelationship)currRel).getSourceEntity();
        objEntity.removeRelationship(currRel.getName());
        objEntity.addRelationship(relToFire);
        this.projectController.fireObjRelationshipEvent(new RelationshipEvent((Object)this, relToFire, relToFire.getSourceEntity(), 2));
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo Edit relationship";
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo Edit relationship";
    }

    private Relationship copyRelationship(Relationship relationship) {
        return this.useDb ? this.getDbRelationship(relationship) : this.getObjRelationship(relationship);
    }

    private DbRelationship getDbRelationship(Relationship dbRelationship) {
        DbRelationship rel = new DbRelationship();
        rel.setName(dbRelationship.getName());
        rel.setToDependentPK(((DbRelationship)dbRelationship).isToDependentPK());
        rel.setToMany(dbRelationship.isToMany());
        rel.setTargetEntityName(dbRelationship.getTargetEntityName());
        rel.setSourceEntity(dbRelationship.getSourceEntity());
        rel.setJoins(rel.getJoins());
        return rel;
    }

    private ObjRelationship getObjRelationship(Relationship objRelationship) {
        ObjRelationship rel = new ObjRelationship();
        rel.setName(objRelationship.getName());
        rel.setTargetEntityName(objRelationship.getTargetEntityName());
        rel.setSourceEntity(objRelationship.getSourceEntity());
        rel.setDeleteRule(((ObjRelationship)objRelationship).getDeleteRule());
        rel.setUsedForLocking(((ObjRelationship)objRelationship).isUsedForLocking());
        rel.setDbRelationshipPath(((ObjRelationship)objRelationship).getDbRelationshipPath());
        rel.setCollectionType(((ObjRelationship)objRelationship).getCollectionType());
        rel.setMapKey(((ObjRelationship)objRelationship).getMapKey());
        return rel;
    }
}

