/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.AbstractConfigurationProvider;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.JarConfigurationProvider;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.configuration.paths.TorqueGeneratorPaths;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathConfigurationProvider
extends AbstractConfigurationProvider {
    private static Log log = LogFactory.getLog(ClasspathConfigurationProvider.class);
    private ProjectPaths projectPaths;
    private TorqueGeneratorPaths configurationPaths;
    private static final String FILE_URL_PREFIX = "file:";

    public ClasspathConfigurationProvider(ProjectPaths projectPaths, TorqueGeneratorPaths configurationPaths) {
        super(configurationPaths);
        if (projectPaths == null) {
            throw new NullPointerException("projectPaths is null");
        }
        this.projectPaths = projectPaths;
        this.configurationPaths = configurationPaths;
    }

    @Override
    public String getControlConfigurationLocation() {
        return this.getFileName(this.configurationPaths.getControlConfigurationFile(), this.configurationPaths.getConfigurationDirectory());
    }

    protected String getFileName(String name, String directory) {
        String fileName = this.getConfigResourceBase() + "/" + directory + "/" + name;
        fileName = FilenameUtils.normalizeNoEndSeparator((String)fileName);
        fileName = FilenameUtils.separatorsToUnix((String)fileName);
        return fileName;
    }

    @Override
    protected InputStream getInputStream(String name, String directory, String fileDescription) throws ConfigurationException {
        String fileName = this.getFileName(name, directory);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new ConfigurationException("Could not read " + fileDescription + " file " + fileName + " in classpath");
        }
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading " + fileDescription + " file: '" + fileName + "' in classpath"));
        }
        return bis;
    }

    @Override
    public Collection<String> getOutletConfigurationNames() throws ConfigurationException {
        String outletConfigurationSubdir = this.getConfigResourceBase() + "/" + this.configurationPaths.getOutletDirectory();
        outletConfigurationSubdir = outletConfigurationSubdir.replace('\\', '/');
        URL dirUrl = this.getClass().getClassLoader().getResource(outletConfigurationSubdir);
        if (dirUrl == null) {
            log.error((Object)("Could not open Directory " + outletConfigurationSubdir + " in classpath"));
            throw new ConfigurationException("outletConfigurationSubdir not found");
        }
        String dirUrlString = dirUrl.toExternalForm();
        if (dirUrlString.startsWith("jar")) {
            JarFile jarFile;
            String jarFilePath = dirUrl.getFile();
            if (jarFilePath.startsWith(FILE_URL_PREFIX)) {
                jarFilePath = jarFilePath.substring(FILE_URL_PREFIX.length());
            }
            jarFilePath = jarFilePath.substring(0, jarFilePath.indexOf("!"));
            if (log.isDebugEnabled()) {
                log.debug((Object)("outlet configuration located in jar file" + jarFilePath));
            }
            try {
                jarFile = new JarFile(jarFilePath);
            }
            catch (IOException e) {
                log.error((Object)("Could not open jar File " + jarFilePath));
                throw new ConfigurationException(e);
            }
            String outletConfigurationDirectory = dirUrlString.substring(dirUrlString.lastIndexOf("!") + 1);
            if (outletConfigurationDirectory.startsWith("/")) {
                outletConfigurationDirectory = outletConfigurationDirectory.substring(1);
            }
            return JarConfigurationProvider.getOutletConfigurationNames(jarFile, outletConfigurationDirectory);
        }
        File directory = new File(dirUrl.getFile());
        if (!directory.exists()) {
            throw new ConfigurationException("Could not read outlet directory " + outletConfigurationSubdir + " in classpath; directory URL is " + dirUrl + " file is " + dirUrl.getFile());
        }
        String[] filenames = directory.list();
        ArrayList<String> result = new ArrayList<String>();
        for (String filename : filenames) {
            String rawName;
            File file = new File(filename);
            if (file.isDirectory() || !(rawName = file.getName()).endsWith(".xml")) continue;
            result.add(filename);
        }
        return result;
    }

    private String getConfigResourceBase() {
        String configResourceBase = this.projectPaths.getConfigurationPackage().replace('.', '/');
        return configResourceBase;
    }
}

