/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.annotations.CustomAttribute;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.log4testng.Logger;
import org.testng.reporters.RuntimeBehavior;
import org.testng.xml.XmlSuite;

public class EmailableReporter2
implements IReporter {
    private static final Logger LOG = Logger.getLogger(EmailableReporter2.class);
    protected PrintWriter writer;
    protected final List<SuiteResult> suiteResults = Lists.newArrayList();
    private final StringBuilder buffer = new StringBuilder();
    private String fileName = "emailable-report.html";

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        try {
            this.writer = this.createWriter(outputDirectory);
        }
        catch (IOException e) {
            LOG.error("Unable to create output file", e);
            return;
        }
        for (ISuite suite : suites) {
            this.suiteResults.add(new SuiteResult(suite));
        }
        this.writeDocumentStart();
        this.writeHead();
        this.writeBody();
        this.writeDocumentEnd();
        this.writer.close();
    }

    protected PrintWriter createWriter(String outdir) throws IOException {
        boolean ignored = new File(outdir).mkdirs();
        String jvmArg = RuntimeBehavior.getDefaultEmailableReport2Name();
        if (jvmArg != null && !jvmArg.trim().isEmpty()) {
            this.fileName = jvmArg;
        }
        return new PrintWriter(Files.newBufferedWriter(new File(outdir, this.fileName).toPath(), StandardCharsets.UTF_8, new OpenOption[0]));
    }

    protected void writeDocumentStart() {
        this.writer.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"https://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
        this.writer.println("<html xmlns=\"https://www.w3.org/1999/xhtml\">");
    }

    protected void writeHead() {
        this.writer.println("<head>");
        this.writer.println("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/>");
        this.writer.println("<title>TestNG Report</title>");
        this.writeStylesheet();
        this.writer.println("</head>");
    }

    protected void writeStylesheet() {
        this.writer.print("<style type=\"text/css\">");
        this.writer.print("table {margin-bottom:10px;border-collapse:collapse;empty-cells:show}");
        this.writer.print("th,td {border:1px solid #009;padding:.25em .5em}");
        this.writer.print("th {vertical-align:bottom}");
        this.writer.print("td {vertical-align:top}");
        this.writer.print("table a {font-weight:bold}");
        this.writer.print(".stripe td {background-color: #E6EBF9}");
        this.writer.print(".num {text-align:right}");
        this.writer.print(".passedodd td {background-color: #3F3}");
        this.writer.print(".passedeven td {background-color: #0A0}");
        this.writer.print(".skippedodd td {background-color: #DDD}");
        this.writer.print(".skippedeven td {background-color: #CCC}");
        this.writer.print(".failedodd td,.attn {background-color: #F33}");
        this.writer.print(".failedeven td,.stripe .attn {background-color: #D00}");
        this.writer.print(".stacktrace {white-space:pre;font-family:monospace}");
        this.writer.print(".totop {font-size:85%;text-align:center;border-bottom:2px solid #000}");
        this.writer.print(".invisible {display:none}");
        this.writer.println("</style>");
    }

    protected void writeBody() {
        this.writer.println("<body>");
        this.writeSuiteSummary();
        this.writeScenarioSummary();
        this.writeScenarioDetails();
        this.writer.println("</body>");
    }

    protected void writeDocumentEnd() {
        this.writer.println("</html>");
    }

    protected void writeSuiteSummary() {
        NumberFormat integerFormat = NumberFormat.getIntegerInstance();
        NumberFormat decimalFormat = NumberFormat.getNumberInstance();
        int totalPassedTests = 0;
        int totalSkippedTests = 0;
        int totalFailedTests = 0;
        int totalRetriedTests = 0;
        long totalDuration = 0L;
        this.writer.println("<table>");
        this.writer.print("<tr>");
        this.writer.print("<th>Test</th>");
        this.writer.print("<th># Passed</th>");
        this.writer.print("<th># Skipped</th>");
        this.writer.print("<th># Retried</th>");
        this.writer.print("<th># Failed</th>");
        this.writer.print("<th>Time (ms)</th>");
        this.writer.print("<th>Included Groups</th>");
        this.writer.print("<th>Excluded Groups</th>");
        this.writer.println("</tr>");
        int testIndex = 0;
        for (SuiteResult suiteResult : this.suiteResults) {
            Optional<TestResult> maxValue;
            this.writer.print("<tr><th colspan=\"8\">");
            this.writer.print(Utils.escapeHtml(suiteResult.getSuiteName()));
            this.writer.println("</th></tr>");
            for (TestResult testResult : suiteResult.getTestResults()) {
                int passedTests = testResult.getPassedTestCount();
                int skippedTests = testResult.getSkippedTestCount();
                int failedTests = testResult.getFailedTestCount();
                int retriedTests = testResult.getRetriedTestCount();
                long duration = testResult.getDuration();
                this.writer.print("<tr");
                if (testIndex % 2 == 1) {
                    this.writer.print(" class=\"stripe\"");
                }
                this.writer.print(">");
                this.buffer.setLength(0);
                this.writeTableData(this.buffer.append("<a href=\"#t").append(testIndex).append("\">").append(Utils.escapeHtml(testResult.getTestName())).append("</a>").toString());
                this.writeTableData(integerFormat.format(passedTests), "num");
                this.writeTableData(integerFormat.format(skippedTests), skippedTests > 0 ? "num attn" : "num");
                this.writeTableData(integerFormat.format(retriedTests), retriedTests > 0 ? "num attn" : "num");
                this.writeTableData(integerFormat.format(failedTests), failedTests > 0 ? "num attn" : "num");
                this.writeTableData(decimalFormat.format(duration), "num");
                this.writeTableData(testResult.getIncludedGroups());
                this.writeTableData(testResult.getExcludedGroups());
                this.writer.println("</tr>");
                totalPassedTests += passedTests;
                totalSkippedTests += skippedTests;
                totalFailedTests += failedTests;
                totalRetriedTests += retriedTests;
                totalDuration += duration;
                ++testIndex;
            }
            boolean testsInParallel = XmlSuite.ParallelMode.TESTS.equals((Object)suiteResult.getParallelMode());
            if (!testsInParallel || !(maxValue = suiteResult.testResults.stream().max(Comparator.comparing(TestResult::getDuration))).isPresent()) continue;
            totalDuration = Math.max(totalDuration, maxValue.get().duration);
        }
        if (testIndex > 1) {
            this.writer.print("<tr>");
            this.writer.print("<th>Total</th>");
            this.writeTableHeader(integerFormat.format(totalPassedTests), "num");
            this.writeTableHeader(integerFormat.format(totalSkippedTests), totalSkippedTests > 0 ? "num attn" : "num");
            this.writeTableHeader(integerFormat.format(totalRetriedTests), totalRetriedTests > 0 ? "num attn" : "num");
            this.writeTableHeader(integerFormat.format(totalFailedTests), totalFailedTests > 0 ? "num attn" : "num");
            this.writeTableHeader(decimalFormat.format(totalDuration), "num");
            this.writer.print("<th colspan=\"2\"></th>");
            this.writer.println("</tr>");
        }
        this.writer.println("</table>");
    }

    protected void writeScenarioSummary() {
        this.writer.print("<table id='summary'>");
        this.writer.print("<thead>");
        this.writer.print("<tr>");
        this.writer.print("<th>Class</th>");
        this.writer.print("<th>Method</th>");
        this.writer.print("<th>Start</th>");
        this.writer.print("<th>Time (ms)</th>");
        this.writer.print("</tr>");
        this.writer.print("</thead>");
        int testIndex = 0;
        int scenarioIndex = 0;
        for (SuiteResult suiteResult : this.suiteResults) {
            this.writer.print("<tbody><tr><th colspan=\"4\">");
            this.writer.print(Utils.escapeHtml(suiteResult.getSuiteName()));
            this.writer.print("</th></tr></tbody>");
            for (TestResult testResult : suiteResult.getTestResults()) {
                this.writer.printf("<tbody id=\"t%d\">", testIndex);
                String testName = Utils.escapeHtml(testResult.getTestName());
                int startIndex = scenarioIndex;
                scenarioIndex += this.writeScenarioSummary(testName + " &#8212; failed (configuration methods)", testResult.getFailedConfigurationResults(), "failed", scenarioIndex);
                scenarioIndex += this.writeScenarioSummary(testName + " &#8212; failed", testResult.getFailedTestResults(), "failed", scenarioIndex);
                scenarioIndex += this.writeScenarioSummary(testName + " &#8212; skipped (configuration methods)", testResult.getSkippedConfigurationResults(), "skipped", scenarioIndex);
                scenarioIndex += this.writeScenarioSummary(testName + " &#8212; skipped", testResult.getSkippedTestResults(), "skipped", scenarioIndex);
                scenarioIndex += this.writeScenarioSummary(testName + " &#8212; retried", testResult.getRetriedTestResults(), "retried", scenarioIndex);
                scenarioIndex += this.writeScenarioSummary(testName + " &#8212; passed", testResult.getPassedTestResults(), "passed", scenarioIndex);
                if (scenarioIndex == startIndex) {
                    this.writer.print("<tr><th colspan=\"4\" class=\"invisible\"/></tr>");
                }
                this.writer.println("</tbody>");
                ++testIndex;
            }
        }
        this.writer.println("</table>");
    }

    private int writeScenarioSummary(String description, List<ClassResult> classResults, String cssClassPrefix, int startingScenarioIndex) {
        int scenarioCount = 0;
        if (!classResults.isEmpty()) {
            this.writer.print("<tr><th colspan=\"4\">");
            this.writer.print(description);
            this.writer.print("</th></tr>");
            int scenarioIndex = startingScenarioIndex;
            int classIndex = 0;
            for (ClassResult classResult : classResults) {
                String cssClass = cssClassPrefix + (classIndex % 2 == 0 ? "even" : "odd");
                this.buffer.setLength(0);
                int scenariosPerClass = 0;
                int methodIndex = 0;
                for (MethodResult methodResult : classResult.getMethodResults()) {
                    List<ITestResult> results = methodResult.getResults();
                    if (results.isEmpty()) {
                        throw new IllegalArgumentException("Should have found atleast 1 result");
                    }
                    int resultsCount = results.size();
                    ITestResult firstResult = results.iterator().next();
                    String methodName = Utils.escapeHtml(firstResult.getMethod().getMethodName());
                    long start = firstResult.getStartMillis();
                    long duration = firstResult.getEndMillis() - start;
                    if (methodIndex > 0) {
                        this.buffer.append("<tr class=\"").append(cssClass).append("\">");
                    }
                    this.buffer.append("<td><a href=\"#m").append(scenarioIndex).append("\">").append(methodName).append("</a></td>").append("<td rowspan=\"").append(resultsCount).append("\">").append(this.getFormattedStartTime(start)).append("</td>").append("<td rowspan=\"").append(resultsCount).append("\">").append(duration).append("</td></tr>");
                    ++scenarioIndex;
                    for (int i = 1; i < resultsCount; ++i) {
                        this.buffer.append("<tr class=\"").append(cssClass).append("\">").append("<td><a href=\"#m").append(scenarioIndex).append("\">").append(methodName).append("</a></td></tr>");
                        ++scenarioIndex;
                    }
                    scenariosPerClass += resultsCount;
                    ++methodIndex;
                }
                this.writer.print("<tr class=\"");
                this.writer.print(cssClass);
                this.writer.print("\">");
                this.writer.print("<td rowspan=\"");
                this.writer.print(scenariosPerClass);
                this.writer.print("\">");
                this.writer.print(Utils.escapeHtml(classResult.getClassName()));
                this.writer.print("</td>");
                this.writer.print(this.buffer);
                ++classIndex;
            }
            scenarioCount = scenarioIndex - startingScenarioIndex;
        }
        return scenarioCount;
    }

    protected String getFormattedStartTime(long startTimeInMillisFromEpoch) {
        return String.valueOf(startTimeInMillisFromEpoch);
    }

    protected void writeScenarioDetails() {
        int scenarioIndex = 0;
        for (SuiteResult suiteResult : this.suiteResults) {
            for (TestResult testResult : suiteResult.getTestResults()) {
                this.writer.print("<h2>");
                this.writer.print(Utils.escapeHtml(testResult.getTestName()));
                this.writer.print("</h2>");
                scenarioIndex += this.writeScenarioDetails(testResult.getFailedConfigurationResults(), scenarioIndex);
                scenarioIndex += this.writeScenarioDetails(testResult.getFailedTestResults(), scenarioIndex);
                scenarioIndex += this.writeScenarioDetails(testResult.getSkippedConfigurationResults(), scenarioIndex);
                scenarioIndex += this.writeScenarioDetails(testResult.getSkippedTestResults(), scenarioIndex);
                scenarioIndex += this.writeScenarioDetails(testResult.getRetriedTestResults(), scenarioIndex);
                scenarioIndex += this.writeScenarioDetails(testResult.getPassedTestResults(), scenarioIndex);
            }
        }
    }

    private int writeScenarioDetails(List<ClassResult> classResults, int startingScenarioIndex) {
        int scenarioIndex = startingScenarioIndex;
        for (ClassResult classResult : classResults) {
            String className = classResult.getClassName();
            for (MethodResult methodResult : classResult.getMethodResults()) {
                List<ITestResult> results = methodResult.getResults();
                if (results.isEmpty()) {
                    throw new IllegalStateException("There should have been at-least 1 test result");
                }
                String label = Utils.escapeHtml(className + "#" + results.iterator().next().getMethod().getMethodName());
                for (ITestResult result : results) {
                    this.writeScenario(scenarioIndex, label, result);
                    ++scenarioIndex;
                }
            }
        }
        return scenarioIndex - startingScenarioIndex;
    }

    private void writeScenario(int scenarioIndex, String label, ITestResult result) {
        Throwable throwable;
        this.writer.print("<h3 id=\"m");
        this.writer.print(scenarioIndex);
        this.writer.print("\">");
        this.writer.print(label);
        this.writer.print("</h3>");
        this.writer.print("<table class=\"result\">");
        Object[] parameters = result.getParameters();
        boolean hasRows = this.dumpParametersInfo("Factory Parameter", result.getFactoryParameters());
        int parameterCount = parameters == null ? 0 : parameters.length;
        hasRows = this.dumpParametersInfo("Parameter", result.getParameters());
        this.dumpAttributesInfo(result.getMethod().getAttributes());
        List<String> reporterMessages = Reporter.getOutput(result);
        if (!reporterMessages.isEmpty()) {
            this.writer.print("<tr><th");
            if (parameterCount > 1) {
                this.writer.printf(" colspan=\"%d\"", parameterCount);
            }
            this.writer.print(">Messages</th></tr>");
            this.writer.print("<tr><td");
            if (parameterCount > 1) {
                this.writer.printf(" colspan=\"%d\"", parameterCount);
            }
            this.writer.print(">");
            this.writeReporterMessages(reporterMessages);
            this.writer.print("</td></tr>");
            hasRows = true;
        }
        if ((throwable = result.getThrowable()) != null) {
            this.writer.print("<tr><th");
            if (parameterCount > 1) {
                this.writer.printf(" colspan=\"%d\"", parameterCount);
            }
            this.writer.print(">");
            this.writer.print(result.getStatus() == 1 ? "Expected Exception" : "Exception");
            this.writer.print("</th></tr>");
            this.writer.print("<tr><td");
            if (parameterCount > 1) {
                this.writer.printf(" colspan=\"%d\"", parameterCount);
            }
            this.writer.print(">");
            this.writeStackTrace(throwable);
            this.writer.print("</td></tr>");
            hasRows = true;
        }
        if (!hasRows) {
            this.writer.print("<tr><th");
            if (parameterCount > 1) {
                this.writer.printf(" colspan=\"%d\"", parameterCount);
            }
            this.writer.print(" class=\"invisible\"/></tr>");
        }
        this.writer.print("</table>");
        this.writer.println("<p class=\"totop\"><a href=\"#summary\">back to summary</a></p>");
    }

    private boolean dumpParametersInfo(String prefix, Object[] parameters) {
        int parameterCount;
        int n = parameterCount = parameters == null ? 0 : parameters.length;
        if (parameterCount == 0) {
            return false;
        }
        this.writer.print("<tr class=\"param\">");
        for (int i = 1; i <= parameterCount; ++i) {
            this.writer.print(String.format("<th>%s #", prefix));
            this.writer.print(i);
            this.writer.print("</th>");
        }
        this.writer.print("</tr><tr class=\"param stripe\">");
        for (Object parameter : parameters) {
            this.writer.print("<td>");
            this.writer.print(Utils.escapeHtml(Utils.toString(parameter)));
            this.writer.print("</td>");
        }
        this.writer.print("</tr>");
        return true;
    }

    private void dumpAttributesInfo(CustomAttribute[] attributes) {
        int parameterCount;
        int n = parameterCount = attributes == null ? 0 : attributes.length;
        if (parameterCount == 0) {
            return;
        }
        this.writer.print("<tr class=\"param\">");
        this.writer.print(String.format("<th colspan=3>%s</th>", "Attribute(s)"));
        this.writer.print("</tr>");
        this.writer.print("<tr class=\"param stripe\">");
        this.writer.print("<th>#</th><th>Name</th><th>Value(s)</th>");
        this.writer.print("</tr>");
        int i = 1;
        for (CustomAttribute attribute : attributes) {
            this.writer.print("<tr>");
            this.writer.print("<td>" + String.format("%02d.", i++) + "</td>");
            this.writer.print("<td>" + attribute.name() + "</td>");
            this.writer.print("<td>" + Utils.escapeHtml(Arrays.toString(attribute.values())) + "</td>");
            this.writer.print("</tr>");
        }
    }

    protected void writeReporterMessages(List<String> reporterMessages) {
        this.writer.print("<div class=\"messages\">");
        Iterator<String> iterator = reporterMessages.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("There should have been at-least 1 message.");
        }
        if (Reporter.getEscapeHtml()) {
            this.writer.print(Utils.escapeHtml(iterator.next()));
        } else {
            this.writer.print(iterator.next());
        }
        while (iterator.hasNext()) {
            this.writer.print("<br/>");
            if (Reporter.getEscapeHtml()) {
                this.writer.print(Utils.escapeHtml(iterator.next()));
                continue;
            }
            this.writer.print(iterator.next());
        }
        this.writer.print("</div>");
    }

    protected void writeStackTrace(Throwable throwable) {
        this.writer.print("<div class=\"stacktrace\">");
        this.writer.print(Utils.shortStackTrace(throwable, true));
        this.writer.print("</div>");
    }

    protected void writeTableHeader(String html, String cssClasses) {
        this.writeTag("th", html, cssClasses);
    }

    protected void writeTableData(String html) {
        this.writeTableData(html, null);
    }

    protected void writeTableData(String html, String cssClasses) {
        this.writeTag("td", html, cssClasses);
    }

    protected void writeTag(String tag, String html, String cssClasses) {
        this.writer.print("<");
        this.writer.print(tag);
        if (cssClasses != null) {
            this.writer.print(" class=\"");
            this.writer.print(cssClasses);
            this.writer.print("\"");
        }
        this.writer.print(">");
        this.writer.print(html);
        this.writer.print("</");
        this.writer.print(tag);
        this.writer.print(">");
    }

    protected static class SuiteResult {
        private final String suiteName;
        private final List<TestResult> testResults = Lists.newArrayList();
        private final XmlSuite.ParallelMode mode;

        public SuiteResult(ISuite suite) {
            this.suiteName = suite.getName();
            this.mode = suite.getXmlSuite().getParallel();
            for (ISuiteResult suiteResult : suite.getResults().values()) {
                this.testResults.add(new TestResult(suiteResult.getTestContext()));
            }
        }

        public String getSuiteName() {
            return this.suiteName;
        }

        public List<TestResult> getTestResults() {
            return this.testResults;
        }

        public XmlSuite.ParallelMode getParallelMode() {
            return this.mode;
        }
    }

    protected static class TestResult {
        protected static final Comparator<ITestResult> RESULT_COMPARATOR = Comparator.comparing(o -> o.getTestClass().getName()).thenComparing(o -> o.getMethod().getMethodName());
        private final String testName;
        private final List<ClassResult> failedConfigurationResults;
        private final List<ClassResult> failedTestResults;
        private final List<ClassResult> skippedConfigurationResults;
        private final List<ClassResult> skippedTestResults;
        private final List<ClassResult> retriedTestResults;
        private final List<ClassResult> passedTestResults;
        private final int failedTestCount;
        private final int retriedTestCount;
        private final int skippedTestCount;
        private final int passedTestCount;
        private final long duration;
        private final String includedGroups;
        private final String excludedGroups;

        public TestResult(ITestContext context) {
            this.testName = context.getName();
            Set<ITestResult> failedConfigurations = context.getFailedConfigurations().getAllResults();
            Set<ITestResult> failedTests = context.getFailedTests().getAllResults();
            Set<ITestResult> skippedConfigurations = context.getSkippedConfigurations().getAllResults();
            Set<ITestResult> rawSkipped = context.getSkippedTests().getAllResults();
            Set<ITestResult> skippedTests = TestResult.pruneSkipped(rawSkipped);
            Set<ITestResult> retriedTests = TestResult.pruneRetried(rawSkipped);
            Set<ITestResult> passedTests = context.getPassedTests().getAllResults();
            this.failedConfigurationResults = this.groupResults(failedConfigurations);
            this.failedTestResults = this.groupResults(failedTests);
            this.skippedConfigurationResults = this.groupResults(skippedConfigurations);
            this.skippedTestResults = this.groupResults(skippedTests);
            this.retriedTestResults = this.groupResults(retriedTests);
            this.passedTestResults = this.groupResults(passedTests);
            this.failedTestCount = failedTests.size();
            this.retriedTestCount = retriedTests.size();
            this.skippedTestCount = skippedTests.size();
            this.passedTestCount = passedTests.size();
            this.duration = context.getEndDate().getTime() - context.getStartDate().getTime();
            this.includedGroups = this.formatGroups(context.getIncludedGroups());
            this.excludedGroups = this.formatGroups(context.getExcludedGroups());
        }

        private static Set<ITestResult> pruneSkipped(Set<ITestResult> results) {
            return results.stream().filter(result -> !result.wasRetried()).collect(Collectors.toSet());
        }

        private static Set<ITestResult> pruneRetried(Set<ITestResult> results) {
            return results.stream().filter(ITestResult::wasRetried).collect(Collectors.toSet());
        }

        protected List<ClassResult> groupResults(Set<ITestResult> results) {
            List<ClassResult> classResults = Lists.newArrayList();
            if (!results.isEmpty()) {
                List<MethodResult> resultsPerClass = Lists.newArrayList();
                List<ITestResult> resultsPerMethod = Lists.newArrayList();
                List<ITestResult> resultsList = Lists.newArrayList(results);
                resultsList.sort(RESULT_COMPARATOR);
                Iterator<ITestResult> resultsIterator = resultsList.iterator();
                if (!resultsIterator.hasNext()) {
                    throw new IllegalStateException("There should have been at-least 1 result");
                }
                ITestResult result = resultsIterator.next();
                resultsPerMethod.add(result);
                String previousClassName = result.getTestClass().getName();
                String previousMethodName = result.getMethod().getMethodName();
                while (resultsIterator.hasNext()) {
                    result = resultsIterator.next();
                    String className = result.getTestClass().getName();
                    if (!previousClassName.equals(className)) {
                        if (resultsPerMethod.isEmpty()) {
                            throw new IllegalStateException("Results per method should NOT have been empty");
                        }
                        resultsPerClass.add(new MethodResult(resultsPerMethod));
                        resultsPerMethod = Lists.newArrayList();
                        classResults.add(new ClassResult(previousClassName, resultsPerClass));
                        resultsPerClass = Lists.newArrayList();
                        previousClassName = className;
                        previousMethodName = result.getMethod().getMethodName();
                    } else {
                        String methodName = result.getMethod().getMethodName();
                        if (!previousMethodName.equals(methodName)) {
                            if (resultsPerMethod.isEmpty()) {
                                throw new IllegalStateException("Results per method should NOT have been empty");
                            }
                            resultsPerClass.add(new MethodResult(resultsPerMethod));
                            resultsPerMethod = Lists.newArrayList();
                            previousMethodName = methodName;
                        }
                    }
                    resultsPerMethod.add(result);
                }
                if (resultsPerMethod.isEmpty()) {
                    throw new IllegalStateException("Results per method should NOT have been empty");
                }
                resultsPerClass.add(new MethodResult(resultsPerMethod));
                classResults.add(new ClassResult(previousClassName, resultsPerClass));
            }
            return classResults;
        }

        public String getTestName() {
            return this.testName;
        }

        public List<ClassResult> getFailedConfigurationResults() {
            return this.failedConfigurationResults;
        }

        public List<ClassResult> getFailedTestResults() {
            return this.failedTestResults;
        }

        public List<ClassResult> getSkippedConfigurationResults() {
            return this.skippedConfigurationResults;
        }

        public List<ClassResult> getSkippedTestResults() {
            return this.skippedTestResults;
        }

        public List<ClassResult> getRetriedTestResults() {
            return this.retriedTestResults;
        }

        public List<ClassResult> getPassedTestResults() {
            return this.passedTestResults;
        }

        public int getFailedTestCount() {
            return this.failedTestCount;
        }

        public int getSkippedTestCount() {
            return this.skippedTestCount;
        }

        public int getRetriedTestCount() {
            return this.retriedTestCount;
        }

        public int getPassedTestCount() {
            return this.passedTestCount;
        }

        public long getDuration() {
            return this.duration;
        }

        public String getIncludedGroups() {
            return this.includedGroups;
        }

        public String getExcludedGroups() {
            return this.excludedGroups;
        }

        protected String formatGroups(String[] groups) {
            if (groups.length == 0) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            builder.append(groups[0]);
            for (int i = 1; i < groups.length; ++i) {
                builder.append(", ").append(groups[i]);
            }
            return builder.toString();
        }
    }

    protected static class ClassResult {
        private final String className;
        private final List<MethodResult> methodResults;

        public ClassResult(String className, List<MethodResult> methodResults) {
            this.className = className;
            this.methodResults = methodResults;
        }

        public String getClassName() {
            return this.className;
        }

        public List<MethodResult> getMethodResults() {
            return this.methodResults;
        }
    }

    protected static class MethodResult {
        private final List<ITestResult> results;

        public MethodResult(List<ITestResult> results) {
            this.results = results;
        }

        public List<ITestResult> getResults() {
            return this.results;
        }
    }
}

