/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dorisbulkloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dorisbulkloader.DorisBulkLoaderMeta;
import org.apache.hop.pipeline.transforms.dorisbulkloader.DorisHeader;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DorisBulkLoaderDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = DorisBulkLoaderMeta.class;
    private TextVar wFeHost;
    private TextVar wFeHttpPort;
    private TextVar wDatabaseName;
    private TextVar wTableName;
    private TextVar wHttpLogin;
    private TextVar wHttpPassword;
    private ComboVar wDataField;
    private ComboVar wFormat;
    private TextVar wLineDelimiter;
    private TextVar wColumnDelimiter;
    private TextVar wBufferSize;
    private TextVar wBufferCount;
    private TableView wHeaders;
    private final DorisBulkLoaderMeta input;
    private String[] inputFieldNames;

    public DorisBulkLoaderDialog(Shell parent, IVariables variables, DorisBulkLoaderMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.GeneralTab.Title", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)fileLayout);
        Group gConnections = new Group(wGeneralComp, 16);
        gConnections.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.ConnectionsGroup.Label", (String[])new String[0]));
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 3;
        settingsLayout.marginHeight = 3;
        gConnections.setLayout((Layout)settingsLayout);
        PropsUi.setLook((Widget)gConnections);
        Label wlFeHost = new Label((Composite)gConnections, 131072);
        wlFeHost.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.FeHost.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFeHost);
        FormData fdlFeHost = new FormData();
        fdlFeHost.left = new FormAttachment(0, 0);
        fdlFeHost.right = new FormAttachment(middle, -margin);
        fdlFeHost.top = new FormAttachment((Control)wGeneralComp, margin * 2);
        wlFeHost.setLayoutData((Object)fdlFeHost);
        this.wFeHost = new TextVar(this.variables, (Composite)gConnections, 18436);
        this.wFeHost.setToolTipText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.FeHost.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFeHost);
        this.wFeHost.addModifyListener(lsMod);
        FormData fdFeHost = new FormData();
        fdFeHost.left = new FormAttachment(middle, 0);
        fdFeHost.top = new FormAttachment((Control)wGeneralComp, margin * 2);
        fdFeHost.right = new FormAttachment(100, 0);
        this.wFeHost.setLayoutData((Object)fdFeHost);
        Label wlFeHttpPort = new Label((Composite)gConnections, 131072);
        wlFeHttpPort.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.FeRestPort.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFeHttpPort);
        FormData fdlFeHttpPort = new FormData();
        fdlFeHttpPort.left = new FormAttachment(0, 0);
        fdlFeHttpPort.right = new FormAttachment(middle, -margin);
        fdlFeHttpPort.top = new FormAttachment((Control)this.wFeHost, margin);
        wlFeHttpPort.setLayoutData((Object)fdlFeHttpPort);
        this.wFeHttpPort = new TextVar(this.variables, (Composite)gConnections, 18436);
        this.wFeHttpPort.setToolTipText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.FeRestPort.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFeHttpPort);
        this.wFeHttpPort.addModifyListener(lsMod);
        FormData fdFeHttpPort = new FormData();
        fdFeHttpPort.left = new FormAttachment(middle, 0);
        fdFeHttpPort.top = new FormAttachment((Control)this.wFeHost, margin);
        fdFeHttpPort.right = new FormAttachment(100, 0);
        this.wFeHttpPort.setLayoutData((Object)fdFeHttpPort);
        Label wlDatabaseName = new Label((Composite)gConnections, 131072);
        wlDatabaseName.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.DatabaseName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDatabaseName);
        FormData fdLblDatabaseName = new FormData();
        fdLblDatabaseName.left = new FormAttachment(0, 0);
        fdLblDatabaseName.right = new FormAttachment(middle, -margin);
        fdLblDatabaseName.top = new FormAttachment((Control)this.wFeHttpPort, margin);
        wlDatabaseName.setLayoutData((Object)fdLblDatabaseName);
        this.wDatabaseName = new TextVar(this.variables, (Composite)gConnections, 18436);
        this.wDatabaseName.setToolTipText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.DatabaseName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wDatabaseName);
        this.wDatabaseName.addModifyListener(lsMod);
        FormData fdDatabaseName = new FormData();
        fdDatabaseName.left = new FormAttachment(middle, 0);
        fdDatabaseName.top = new FormAttachment((Control)this.wFeHttpPort, margin);
        fdDatabaseName.right = new FormAttachment(100, 0);
        this.wDatabaseName.setLayoutData((Object)fdDatabaseName);
        Label wlTableName = new Label((Composite)gConnections, 131072);
        wlTableName.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.TableName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTableName);
        FormData fdlTableName = new FormData();
        fdlTableName.left = new FormAttachment(0, 0);
        fdlTableName.right = new FormAttachment(middle, -margin);
        fdlTableName.top = new FormAttachment((Control)this.wDatabaseName, margin);
        wlTableName.setLayoutData((Object)fdlTableName);
        this.wTableName = new TextVar(this.variables, (Composite)gConnections, 18436);
        this.wTableName.setToolTipText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.TableName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTableName);
        this.wTableName.addModifyListener(lsMod);
        FormData fdTableName = new FormData();
        fdTableName.left = new FormAttachment(middle, 0);
        fdTableName.top = new FormAttachment((Control)this.wDatabaseName, margin);
        fdTableName.right = new FormAttachment(100, 0);
        this.wTableName.setLayoutData((Object)fdTableName);
        Label wlHttpLogin = new Label((Composite)gConnections, 131072);
        wlHttpLogin.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.HttpLogin.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHttpLogin);
        FormData fdlHttpLogin = new FormData();
        fdlHttpLogin.top = new FormAttachment((Control)this.wTableName, margin);
        fdlHttpLogin.left = new FormAttachment(0, 0);
        fdlHttpLogin.right = new FormAttachment(middle, -margin);
        wlHttpLogin.setLayoutData((Object)fdlHttpLogin);
        this.wHttpLogin = new TextVar(this.variables, (Composite)gConnections, 18436);
        this.wHttpLogin.addModifyListener(lsMod);
        this.wHttpLogin.setToolTipText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.HttpLogin.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wHttpLogin);
        FormData fdHttpLogin = new FormData();
        fdHttpLogin.top = new FormAttachment((Control)this.wTableName, margin);
        fdHttpLogin.left = new FormAttachment(middle, 0);
        fdHttpLogin.right = new FormAttachment(100, 0);
        this.wHttpLogin.setLayoutData((Object)fdHttpLogin);
        Label wlHttpPassword = new Label((Composite)gConnections, 131072);
        wlHttpPassword.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.HttpPassword.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHttpPassword);
        FormData fdLblHttpPassword = new FormData();
        fdLblHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdLblHttpPassword.left = new FormAttachment(0, 0);
        fdLblHttpPassword.right = new FormAttachment(middle, -margin);
        wlHttpPassword.setLayoutData((Object)fdLblHttpPassword);
        this.wHttpPassword = new PasswordTextVar(this.variables, (Composite)gConnections, 18436);
        this.wHttpPassword.addModifyListener(lsMod);
        this.wHttpPassword.setToolTipText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.HttpPassword.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wHttpPassword);
        FormData fdHttpPassword = new FormData();
        fdHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdHttpPassword.left = new FormAttachment(middle, 0);
        fdHttpPassword.right = new FormAttachment(100, 0);
        this.wHttpPassword.setLayoutData((Object)fdHttpPassword);
        FormData fdConnections = new FormData();
        fdConnections.left = new FormAttachment(0, 0);
        fdConnections.right = new FormAttachment(100, 0);
        fdConnections.top = new FormAttachment((Control)this.wTransformName, margin);
        gConnections.setLayoutData((Object)fdConnections);
        Group gBulkData = new Group(wGeneralComp, 16);
        gBulkData.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.BulkDataGroup.Label", (String[])new String[0]));
        FormLayout bulkDataLayout = new FormLayout();
        bulkDataLayout.marginWidth = 3;
        bulkDataLayout.marginHeight = 3;
        gBulkData.setLayout((Layout)bulkDataLayout);
        PropsUi.setLook((Widget)gBulkData);
        Label wlDataField = new Label((Composite)gBulkData, 131072);
        wlDataField.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.BulkData.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDataField);
        FormData fdlBody = new FormData();
        fdlBody.top = new FormAttachment((Control)this.wHttpPassword, margin);
        fdlBody.left = new FormAttachment(0, 0);
        fdlBody.right = new FormAttachment(middle, -margin);
        wlDataField.setLayoutData((Object)fdlBody);
        this.wDataField = new ComboVar(this.variables, (Composite)gBulkData, 2056);
        this.wDataField.setToolTipText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.BulkData.Tooltip", (String[])new String[0]));
        this.wDataField.setEditable(true);
        PropsUi.setLook((Widget)this.wDataField);
        this.wDataField.addModifyListener(lsMod);
        FormData fdDataField = new FormData();
        fdDataField.top = new FormAttachment((Control)this.wHttpPassword, margin);
        fdDataField.left = new FormAttachment(middle, 0);
        fdDataField.right = new FormAttachment(100, 0);
        this.wDataField.setLayoutData((Object)fdDataField);
        this.wDataField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)DorisBulkLoaderDialog.this.shell.getDisplay(), 1);
                DorisBulkLoaderDialog.this.shell.setCursor(busy);
                String bodyField = DorisBulkLoaderDialog.this.wDataField.getText();
                DorisBulkLoaderDialog.this.wDataField.setItems(DorisBulkLoaderDialog.this.inputFieldNames);
                DorisBulkLoaderDialog.this.wDataField.setText(bodyField);
                DorisBulkLoaderDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlFormat = new Label((Composite)gBulkData, 131072);
        wlFormat.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.Format.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFormat);
        FormData fdlFormat = new FormData();
        fdlFormat.top = new FormAttachment((Control)this.wDataField, margin);
        fdlFormat.left = new FormAttachment(0, 0);
        fdlFormat.right = new FormAttachment(middle, -margin);
        wlFormat.setLayoutData((Object)fdlFormat);
        this.wFormat = new ComboVar(this.variables, (Composite)gBulkData, 2056);
        this.wFormat.addModifyListener(lsMod);
        this.wFormat.setToolTipText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.Format.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFormat);
        FormData fdFormat = new FormData();
        fdFormat.top = new FormAttachment((Control)this.wDataField, margin);
        fdFormat.left = new FormAttachment(middle, 0);
        fdFormat.right = new FormAttachment(100, 0);
        this.wFormat.setLayoutData((Object)fdFormat);
        this.wFormat.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)DorisBulkLoaderDialog.this.shell.getDisplay(), 1);
                DorisBulkLoaderDialog.this.shell.setCursor(busy);
                String format = DorisBulkLoaderDialog.this.wFormat.getText();
                DorisBulkLoaderDialog.this.wFormat.setItems(new String[]{"json", "csv"});
                DorisBulkLoaderDialog.this.wFormat.setText(format);
                DorisBulkLoaderDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wFormat.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if ("json".equals(DorisBulkLoaderDialog.this.wFormat.getText())) {
                    DorisBulkLoaderDialog.this.wLineDelimiter.setText(",");
                    DorisBulkLoaderDialog.this.wLineDelimiter.setEnabled(false);
                    DorisBulkLoaderDialog.this.wColumnDelimiter.setText(",");
                    DorisBulkLoaderDialog.this.wColumnDelimiter.setEnabled(false);
                } else {
                    DorisBulkLoaderDialog.this.wLineDelimiter.setEnabled(true);
                    DorisBulkLoaderDialog.this.wLineDelimiter.setText("\\n");
                    DorisBulkLoaderDialog.this.wColumnDelimiter.setEnabled(true);
                    DorisBulkLoaderDialog.this.wColumnDelimiter.setText(",");
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Label wlLineDelimiter = new Label((Composite)gBulkData, 131072);
        wlLineDelimiter.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.LineDelimiter.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLineDelimiter);
        FormData fdlLineDelimiter = new FormData();
        fdlLineDelimiter.top = new FormAttachment((Control)this.wFormat, margin);
        fdlLineDelimiter.left = new FormAttachment(0, 0);
        fdlLineDelimiter.right = new FormAttachment(middle, -margin);
        wlLineDelimiter.setLayoutData((Object)fdlLineDelimiter);
        this.wLineDelimiter = new TextVar(this.variables, (Composite)gBulkData, 18436);
        this.wLineDelimiter.addModifyListener(lsMod);
        this.wLineDelimiter.setToolTipText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.LineDelimiter.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wLineDelimiter);
        FormData fdLineDelimiter = new FormData();
        fdLineDelimiter.top = new FormAttachment((Control)this.wFormat, margin);
        fdLineDelimiter.left = new FormAttachment(middle, 0);
        fdLineDelimiter.right = new FormAttachment(100, 0);
        this.wLineDelimiter.setLayoutData((Object)fdLineDelimiter);
        Label wlColumnDelimiter = new Label((Composite)gBulkData, 131072);
        wlColumnDelimiter.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.ColumnDelimiter.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlColumnDelimiter);
        FormData fdlColumnDelimiter = new FormData();
        fdlColumnDelimiter.top = new FormAttachment((Control)this.wLineDelimiter, margin);
        fdlColumnDelimiter.left = new FormAttachment(0, 0);
        fdlColumnDelimiter.right = new FormAttachment(middle, -margin);
        wlColumnDelimiter.setLayoutData((Object)fdlColumnDelimiter);
        this.wColumnDelimiter = new TextVar(this.variables, (Composite)gBulkData, 18436);
        this.wColumnDelimiter.addModifyListener(lsMod);
        this.wColumnDelimiter.setToolTipText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.ColumnDelimiter.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wColumnDelimiter);
        FormData fdColumnDelimiter = new FormData();
        fdColumnDelimiter.top = new FormAttachment((Control)this.wLineDelimiter, margin);
        fdColumnDelimiter.left = new FormAttachment(middle, 0);
        fdColumnDelimiter.right = new FormAttachment(100, 0);
        this.wColumnDelimiter.setLayoutData((Object)fdColumnDelimiter);
        Label wlBufferSize = new Label((Composite)gBulkData, 131072);
        wlBufferSize.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.BufferSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBufferSize);
        FormData fdlBufferSize = new FormData();
        fdlBufferSize.top = new FormAttachment((Control)this.wColumnDelimiter, margin);
        fdlBufferSize.left = new FormAttachment(0, 0);
        fdlBufferSize.right = new FormAttachment(middle, -margin);
        wlBufferSize.setLayoutData((Object)fdlBufferSize);
        this.wBufferSize = new TextVar(this.variables, (Composite)gBulkData, 18436);
        this.wBufferSize.addModifyListener(lsMod);
        this.wBufferSize.setToolTipText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.BufferSize.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wBufferSize);
        FormData fdBufferSize = new FormData();
        fdBufferSize.top = new FormAttachment((Control)this.wColumnDelimiter, margin);
        fdBufferSize.left = new FormAttachment(middle, 0);
        fdBufferSize.right = new FormAttachment(100, 0);
        this.wBufferSize.setLayoutData((Object)fdBufferSize);
        Label wlBufferCount = new Label((Composite)gBulkData, 131072);
        wlBufferCount.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.BufferCount.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBufferCount);
        FormData fdlBufferCount = new FormData();
        fdlBufferCount.top = new FormAttachment((Control)this.wBufferSize, margin);
        fdlBufferCount.left = new FormAttachment(0, 0);
        fdlBufferCount.right = new FormAttachment(middle, -margin);
        wlBufferCount.setLayoutData((Object)fdlBufferCount);
        this.wBufferCount = new TextVar(this.variables, (Composite)gBulkData, 18436);
        this.wBufferCount.addModifyListener(lsMod);
        this.wBufferCount.setToolTipText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.BufferCount.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wBufferCount);
        FormData fdBufferCount = new FormData();
        fdBufferCount.top = new FormAttachment((Control)this.wBufferSize, margin);
        fdBufferCount.left = new FormAttachment(middle, 0);
        fdBufferCount.right = new FormAttachment(100, 0);
        this.wBufferCount.setLayoutData((Object)fdBufferCount);
        FormData fdBulkData = new FormData();
        fdBulkData.left = new FormAttachment(0, 0);
        fdBulkData.right = new FormAttachment(100, 0);
        fdBulkData.top = new FormAttachment((Control)gConnections, margin);
        gBulkData.setLayoutData((Object)fdBulkData);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        CTabItem wAdditionalTab = new CTabItem(wTabFolder, 0);
        wAdditionalTab.setFont(GuiResource.getInstance().getFontDefault());
        wAdditionalTab.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.Headers.Title", (String[])new String[0]));
        Composite wAdditionalComp = new Composite((Composite)wTabFolder, 0);
        FormLayout addLayout = new FormLayout();
        addLayout.marginWidth = PropsUi.getFormMargin();
        addLayout.marginHeight = PropsUi.getFormMargin();
        wAdditionalComp.setLayout((Layout)addLayout);
        PropsUi.setLook((Widget)wAdditionalComp);
        Label wlFields = new Label(wAdditionalComp, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.Headers.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int nrHeaders = this.input.getHeaders().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.ColumnInfo.Header", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.ColumnInfo.Value", (String[])new String[0]), 1, false)};
        colinf[1].setUsingVariables(true);
        this.wHeaders = new TableView(this.variables, wAdditionalComp, 67586, colinf, nrHeaders, lsMod, this.props);
        FormData fdHeaders = new FormData();
        fdHeaders.left = new FormAttachment(0, 0);
        fdHeaders.top = new FormAttachment((Control)wlFields, margin);
        fdHeaders.right = new FormAttachment(100, -margin);
        fdHeaders.bottom = new FormAttachment(100, -margin);
        this.wHeaders.setLayoutData((Object)fdHeaders);
        FormData fdAdditionalComp = new FormData();
        fdAdditionalComp.left = new FormAttachment(0, 0);
        fdAdditionalComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdAdditionalComp.right = new FormAttachment(100, -margin);
        fdAdditionalComp.bottom = new FormAttachment(100, 0);
        wAdditionalComp.setLayoutData((Object)fdAdditionalComp);
        wAdditionalComp.layout();
        wAdditionalTab.setControl((Control)wAdditionalComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        wTabFolder.setSelection(0);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TransformMeta transformMeta = DorisBulkLoaderDialog.this.pipelineMeta.findTransform(DorisBulkLoaderDialog.this.transformName);
                if (transformMeta != null) {
                    try {
                        IRowMeta row = DorisBulkLoaderDialog.this.pipelineMeta.getPrevTransformFields(DorisBulkLoaderDialog.this.variables, transformMeta);
                        HashMap<String, Integer> inputFields = new HashMap<String, Integer>();
                        for (int i = 0; i < row.size(); ++i) {
                            inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        Set keySet = inputFields.keySet();
                        ArrayList entries = new ArrayList(keySet);
                        DorisBulkLoaderDialog.this.inputFieldNames = entries.toArray(new String[entries.size()]);
                        Const.sortStrings((String[])DorisBulkLoaderDialog.this.inputFieldNames);
                    }
                    catch (HopException e) {
                        DorisBulkLoaderDialog.this.log.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0])});
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DorisBulkLoaderDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getFeHost() != null) {
            this.wFeHost.setText(this.input.getFeHost());
        }
        if (this.input.getFeHttpPort() != null) {
            this.wFeHttpPort.setText(this.input.getFeHttpPort());
        }
        if (this.input.getDatabaseName() != null) {
            this.wDatabaseName.setText(this.input.getDatabaseName());
        }
        if (this.input.getTableName() != null) {
            this.wTableName.setText(this.input.getTableName());
        }
        if (this.input.getLoginUser() != null) {
            this.wHttpLogin.setText(this.input.getLoginUser());
        }
        if (this.input.getLoginPassword() != null) {
            this.wHttpPassword.setText(this.input.getLoginPassword());
        }
        if (this.input.getDataField() != null) {
            this.wDataField.setText(this.input.getDataField());
        }
        if (this.input.getFormat() != null) {
            this.wFormat.setText(this.input.getFormat());
            if ("json".equals(this.wFormat.getText())) {
                this.wLineDelimiter.setText(",");
                this.wLineDelimiter.setEnabled(false);
                this.wColumnDelimiter.setText(",");
                this.wColumnDelimiter.setEnabled(false);
            }
        }
        if (this.input.getLineDelimiter() != null) {
            this.wLineDelimiter.setText(this.input.getLineDelimiter());
        }
        if (this.input.getColumnDelimiter() != null) {
            this.wColumnDelimiter.setText(this.input.getColumnDelimiter());
        }
        for (int i = 0; i < this.input.getHeaders().size(); ++i) {
            DorisHeader header = this.input.getHeaders().get(i);
            TableItem item = this.wHeaders.table.getItem(i);
            item.setText(1, Const.NVL((String)header.getName(), (String)""));
            item.setText(2, Const.NVL((String)header.getValue(), (String)""));
        }
        this.wBufferSize.setText(Integer.toString(this.input.getBufferSize()));
        this.wBufferCount.setText(Integer.toString(this.input.getBufferCount()));
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
        this.input.setChanged(this.changed);
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setFeHost(this.wFeHost.getText());
        this.input.setFeHttpPort(this.wFeHttpPort.getText());
        this.input.setDatabaseName(this.wDatabaseName.getText());
        this.input.setTableName(this.wTableName.getText());
        this.input.setDataField(this.wDataField.getText());
        this.input.setLoginUser(this.wHttpLogin.getText());
        this.input.setLoginPassword(this.wHttpPassword.getText());
        this.input.setFormat(this.wFormat.getText());
        this.input.setLineDelimiter(this.wLineDelimiter.getText());
        this.input.setColumnDelimiter(this.wColumnDelimiter.getText());
        int headerCount = this.wHeaders.nrNonEmpty();
        this.input.getHeaders().clear();
        for (TableItem item : this.wHeaders.getNonEmptyItems()) {
            DorisHeader header = new DorisHeader(item.getText(1), item.getText(2));
            this.input.getHeaders().add(header);
        }
        this.input.setBufferSize(Integer.parseInt(this.wBufferSize.getText()));
        this.input.setBufferCount(Integer.parseInt(this.wBufferCount.getText()));
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }
}

