/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.anthropic.AnthropicChatModelName;
import dev.langchain4j.model.anthropic.AnthropicClient;
import dev.langchain4j.model.anthropic.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.AnthropicMapper;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import java.time.Duration;
import java.util.List;

public class AnthropicStreamingChatModel
implements StreamingChatLanguageModel {
    private final AnthropicClient client;
    private final String modelName;
    private final Double temperature;
    private final Double topP;
    private final Integer topK;
    private final int maxTokens;
    private final List<String> stopSequences;

    private AnthropicStreamingChatModel(String baseUrl, String apiKey, String version, String modelName, Double temperature, Double topP, Integer topK, Integer maxTokens, List<String> stopSequences, Duration timeout, Boolean logRequests, Boolean logResponses) {
        this.client = ((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)AnthropicClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.anthropic.com/v1/"))).apiKey(apiKey)).version((String)Utils.getOrDefault((Object)version, (Object)"2023-06-01"))).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L)))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false))).build();
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)AnthropicChatModelName.CLAUDE_3_HAIKU_20240307.toString());
        this.temperature = temperature;
        this.topP = topP;
        this.topK = topK;
        this.maxTokens = (Integer)Utils.getOrDefault((Object)maxTokens, (Object)1024);
        this.stopSequences = stopSequences;
    }

    public static AnthropicStreamingChatModel withApiKey(String apiKey) {
        return AnthropicStreamingChatModel.builder().apiKey(apiKey).build();
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        ValidationUtils.ensureNotNull(handler, (String)"handler");
        AnthropicCreateMessageRequest request = AnthropicCreateMessageRequest.builder().model(this.modelName).messages(AnthropicMapper.toAnthropicMessages(messages)).system(AnthropicMapper.toAnthropicSystemPrompt(messages)).maxTokens(this.maxTokens).stopSequences(this.stopSequences).stream(true).temperature(this.temperature).topP(this.topP).topK(this.topK).build();
        this.client.createMessage(request, handler);
    }

    public static AnthropicStreamingChatModelBuilder builder() {
        return new AnthropicStreamingChatModelBuilder();
    }

    public static class AnthropicStreamingChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String version;
        private String modelName;
        private Double temperature;
        private Double topP;
        private Integer topK;
        private Integer maxTokens;
        private List<String> stopSequences;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;

        public AnthropicStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public AnthropicStreamingChatModelBuilder modelName(AnthropicChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        AnthropicStreamingChatModelBuilder() {
        }

        public AnthropicStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public AnthropicStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public AnthropicStreamingChatModelBuilder version(String version) {
            this.version = version;
            return this;
        }

        public AnthropicStreamingChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AnthropicStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public AnthropicStreamingChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public AnthropicStreamingChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public AnthropicStreamingChatModelBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        public AnthropicStreamingChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public AnthropicStreamingChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public AnthropicStreamingChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public AnthropicStreamingChatModel build() {
            return new AnthropicStreamingChatModel(this.baseUrl, this.apiKey, this.version, this.modelName, this.temperature, this.topP, this.topK, this.maxTokens, this.stopSequences, this.timeout, this.logRequests, this.logResponses);
        }

        public String toString() {
            return "AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", version=" + this.version + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", topP=" + this.topP + ", topK=" + this.topK + ", maxTokens=" + this.maxTokens + ", stopSequences=" + this.stopSequences + ", timeout=" + this.timeout + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

