/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

abstract class CredentialVault
implements Cloneable,
Serializable {
    static final boolean PASSWORD_TRACE = false;
    static Random rng = new Random();
    protected byte[] encodedCredential_;
    private boolean externalSeedsWereUsed_;

    protected CredentialVault() {
        this(null);
    }

    protected CredentialVault(byte[] credential) {
        if (Trace.traceOn_) {
            Trace.log(3, "CredentialVault(byte[] credential) called");
        }
        this.encodedCredential_ = (byte[])(credential == null ? null : this.store(credential));
        this.externalSeedsWereUsed_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CredentialVault clone() {
        CredentialVault vaultClone;
        if (Trace.traceOn_) {
            Trace.log(3, "CredentialVault clone called");
        }
        try {
            vaultClone = (CredentialVault)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, e);
            throw new InternalErrorException(10, (Throwable)e);
        }
        CredentialVault credentialVault = this;
        synchronized (credentialVault) {
            if (this.encodedCredential_ != null) {
                byte[] credentialCopy = new byte[this.encodedCredential_.length];
                System.arraycopy(this.encodedCredential_, 0, credentialCopy, 0, credentialCopy.length);
                vaultClone.encodedCredential_ = credentialCopy;
            }
            vaultClone.externalSeedsWereUsed_ = this.externalSeedsWereUsed_;
        }
        return vaultClone;
    }

    protected abstract int getType();

    protected synchronized void empty() {
        this.disposeOfCredential();
    }

    protected void finalize() throws Throwable {
        try {
            this.empty();
        }
        finally {
            super.finalize();
        }
    }

    protected boolean isEmpty() {
        return this.encodedCredential_ == null;
    }

    protected synchronized byte[] getClearCredential() {
        if (Trace.traceOn_) {
            Trace.log(3, "CredentialVault.getClearCredential called");
        }
        if (this.isEmpty()) {
            Trace.log(2, "Credential vault is empty");
            throw new ExtendedIllegalStateException("credential", 4);
        }
        return this.resolve(this.encodedCredential_);
    }

    protected synchronized void storeEncodedUsingExternalSeeds(byte[] firstSeed, byte[] secondSeed) {
        if (Trace.traceOn_) {
            Trace.log(3, "CredentialVault.storedEncodedUsingExternalSeeds called");
        }
        if (this.externalSeedsWereUsed_) {
            Trace.log(2, "Called storeEncodedUsingExternalSeeds() when credential was already encoded using external seeds.");
            throw new InternalErrorException(6);
        }
        this.externalSeedsWereUsed_ = true;
        if (!this.isEmpty()) {
            byte[] clearCredential = this.getClearCredential();
            this.encodedCredential_ = CredentialVault.encode(firstSeed, secondSeed, clearCredential);
            CredentialVault.clearArray(clearCredential);
        }
    }

    protected synchronized void storeEncodedUsingInternalSeeds(byte[] firstSeed, byte[] secondSeed) {
        if (Trace.traceOn_) {
            Trace.log(3, "CredentialVault.storedEncodedUsingInternalSeeds called");
        }
        if (!this.externalSeedsWereUsed_) {
            Trace.log(2, "Called storeEncodedUsingInternalSeeds() when credential was not previously encoded using external seeds.");
            throw new InternalErrorException(6);
        }
        this.externalSeedsWereUsed_ = false;
        if (!this.isEmpty()) {
            byte[] decodedBytes = CredentialVault.decode(firstSeed, secondSeed, this.encodedCredential_);
            this.encodedCredential_ = this.store(decodedBytes);
            CredentialVault.clearArray(decodedBytes);
        }
    }

    protected void disposeOfCredential() {
        if (Trace.traceOn_) {
            Trace.log(3, "CredentialVault.disposeOfCredential called");
        }
        this.encodedCredential_ = null;
    }

    protected byte[] store(byte[] credential) {
        byte[] newAdder = new byte[9];
        rng.nextBytes(newAdder);
        byte[] newMask = new byte[7];
        rng.nextBytes(newMask);
        byte[] infoBytes = CredentialVault.encode(newAdder, newMask, credential);
        byte[] returnBytes = new byte[infoBytes.length + 16];
        System.arraycopy(newAdder, 0, returnBytes, 0, 9);
        System.arraycopy(newMask, 0, returnBytes, 9, 7);
        System.arraycopy(infoBytes, 0, returnBytes, 16, infoBytes.length);
        return returnBytes;
    }

    protected synchronized byte[] resolve(byte[] encodedBytes) {
        if (encodedBytes == null) {
            return null;
        }
        byte[] adder = new byte[9];
        System.arraycopy(encodedBytes, 0, adder, 0, 9);
        byte[] mask = new byte[7];
        System.arraycopy(encodedBytes, 9, mask, 0, 7);
        byte[] infoBytes = new byte[encodedBytes.length - 16];
        System.arraycopy(encodedBytes, 16, infoBytes, 0, encodedBytes.length - 16);
        return CredentialVault.decode(adder, mask, infoBytes);
    }

    protected static byte[] encode(byte[] adder, byte[] mask, byte[] credential) {
        int i;
        if (credential == null) {
            return null;
        }
        int length = credential.length;
        byte[] buf = new byte[length];
        for (i = 0; i < length; ++i) {
            buf[i] = (byte)(credential[i] + adder[i % 9]);
        }
        for (i = 0; i < length; ++i) {
            buf[i] = (byte)(buf[i] ^ mask[i % 7]);
        }
        return buf;
    }

    protected static byte[] decode(byte[] adder, byte[] mask, byte[] credential) {
        int i;
        int length = credential.length;
        byte[] buf = new byte[length];
        for (i = 0; i < length; ++i) {
            buf[i] = (byte)(mask[i % 7] ^ credential[i]);
        }
        for (i = 0; i < length; ++i) {
            buf[i] = (byte)(buf[i] - adder[i % 9]);
        }
        return buf;
    }

    protected byte[] decode(byte[] adder, byte[] mask) {
        return CredentialVault.decode(adder, mask, this.encodedCredential_);
    }

    protected String trace() {
        StringBuffer sb = new StringBuffer();
        sb.append("type=");
        sb.append(this.getType());
        sb.append(" : bytes=");
        Trace.printByteArray(sb, this.encodedCredential_);
        return sb.toString();
    }

    public static void clearArray(char[] passwordChars) {
        if (passwordChars != null && passwordChars.length > 0) {
            Arrays.fill(passwordChars, '\u0000');
        }
    }

    public static void clearArray(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = 0;
            }
        }
    }

    public static boolean isStarCurrent(char[] password) {
        return !(password.length != 8 || password[0] != '*' || password[1] != 'C' && password[1] != 'c' || password[2] != 'U' && password[2] != 'u' || password[3] != 'R' && password[3] != 'r' || password[4] != 'R' && password[4] != 'r' || password[5] != 'E' && password[5] != 'e' || password[6] != 'N' && password[6] != 'n' || password[7] != 'T' && password[7] != 't');
    }

    public static int getHashCode(char[] password) {
        int len = password.length;
        int hashcode = 0;
        for (int i = 0; i < len; ++i) {
            hashcode = password[i] * 31 ^ len - 1;
        }
        return hashcode;
    }
}

