/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.AS400TreeModel;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PopupMenuAdapter;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.TreeSelectionEventSupport;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VEmptyNode;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellEditor;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VPane;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class AS400TreePane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static VNode dummyRoot_ = new VEmptyNode();
    boolean allowActions_ = true;
    boolean confirm_ = true;
    AS400TreeModel model_ = new AS400TreeModel(dummyRoot_);
    JTree tree_ = new JTree(this.model_);
    private transient VActionContext actionContext_;
    private transient PopupMenuAdapter popupMenuAdapter_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient TreeSelectionEventSupport treeSelectionEventSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;

    public AS400TreePane() {
        this.tree_.setCellEditor(new VObjectCellEditor());
        this.tree_.setCellRenderer(new VObjectCellRenderer());
        this.tree_.setEditable(true);
        this.tree_.setRootVisible(true);
        this.tree_.setShowsRootHandles(true);
        this.tree_.getSelectionModel().setSelectionMode(1);
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.tree_));
        this.initializeTransient();
    }

    public AS400TreePane(VNode root) {
        this();
        if (root == null) {
            throw new NullPointerException("root");
        }
        try {
            this.model_.setRoot(root);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.expand(root);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.treeSelectionEventSupport_.addTreeSelectionListener(listener);
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void collapse(VNode object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        int row = this.findRow(object);
        if (row >= 0) {
            this.tree_.collapseRow(row);
        }
    }

    public void expand(VNode object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        int row = this.findRow(object);
        if (row >= 0) {
            this.tree_.expandRow(row);
        }
    }

    private int findRow(VNode object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        TreePath path = this.getPath(object);
        if (path != null) {
            return this.tree_.getRowForPath(path);
        }
        return -1;
    }

    public VActionContext getActionContext() {
        return this.actionContext_;
    }

    public boolean getAllowActions() {
        return this.allowActions_;
    }

    public boolean getConfirm() {
        return this.confirm_;
    }

    public TreeModel getModel() {
        return this.model_;
    }

    public TreePath getPath(VNode object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        return this.model_.getPath(object);
    }

    public VNode getRoot() {
        VNode root = (VNode)this.model_.getRoot();
        if (root == dummyRoot_) {
            return null;
        }
        return root;
    }

    public VNode getSelectedObject() {
        VNode selectedObject = null;
        TreePath selectedPath = this.tree_.getSelectionPath();
        if (selectedPath != null) {
            selectedObject = (VNode)selectedPath.getLastPathComponent();
        }
        return selectedObject;
    }

    public VNode[] getSelectedObjects() {
        VNode[] selectedObjects = null;
        TreePath[] selectedPaths = this.tree_.getSelectionPaths();
        if (selectedPaths != null) {
            selectedObjects = new VNode[selectedPaths.length];
            for (int i = 0; i < selectedPaths.length; ++i) {
                selectedObjects[i] = (VNode)selectedPaths[i].getLastPathComponent();
            }
        } else {
            selectedObjects = new VNode[]{};
        }
        return selectedObjects;
    }

    public TreeSelectionModel getSelectionModel() {
        return this.tree_.getSelectionModel();
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.treeSelectionEventSupport_ = new TreeSelectionEventSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.model_.addErrorListener(this.errorEventSupport_);
        this.model_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.model_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.tree_.addTreeSelectionListener(this.treeSelectionEventSupport_);
        this.actionContext_ = new VActionContext_();
        this.model_.addWorkingListener(new WorkingCursorAdapter(this.tree_));
        VPane_ pane = new VPane_();
        this.popupMenuAdapter_ = new PopupMenuAdapter(pane, this.actionContext_);
        if (this.allowActions_) {
            this.tree_.addMouseListener(this.popupMenuAdapter_);
        }
    }

    public boolean isCollapsed(VNode object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        int row = this.findRow(object);
        if (row >= 0) {
            return this.tree_.isCollapsed(row);
        }
        return false;
    }

    public boolean isExpanded(VNode object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        int row = this.findRow(object);
        if (row >= 0) {
            return this.tree_.isExpanded(row);
        }
        return false;
    }

    public boolean isSelected(VNode object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        int row = this.findRow(object);
        if (row > 0) {
            return this.tree_.isRowSelected(row);
        }
        return false;
    }

    public boolean isVisible(VNode object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        TreePath path = this.getPath(object);
        if (path != null) {
            if (this.tree_.getPathBounds(this.model_.getPath(object)) == null) {
                return false;
            }
            return this.tree_.isVisible(path);
        }
        return false;
    }

    public void load() {
        this.model_.load();
        this.expand((VNode)this.model_.getRoot());
    }

    public void makeVisible(VNode object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        TreePath path = this.getPath(object);
        if (path != null) {
            this.tree_.makeVisible(path);
        }
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener listener) {
        this.treeSelectionEventSupport_.removeTreeSelectionListener(listener);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void setAllowActions(boolean allowActions) {
        if (this.allowActions_ != allowActions) {
            this.allowActions_ = allowActions;
            if (this.allowActions_) {
                this.tree_.addMouseListener(this.popupMenuAdapter_);
            } else {
                this.tree_.removeMouseListener(this.popupMenuAdapter_);
            }
        }
    }

    public void setConfirm(boolean confirm) {
        this.confirm_ = confirm;
    }

    public void setRoot(VNode root) throws PropertyVetoException {
        if (root == null) {
            throw new NullPointerException("root");
        }
        this.tree_.clearSelection();
        this.model_.setRoot(root);
        this.expand(root);
    }

    public void setSelectionModel(TreeSelectionModel selectionModel) {
        TreeSelectionModel oldSelectionModel = this.tree_.getSelectionModel();
        if (oldSelectionModel != null) {
            oldSelectionModel.removeTreeSelectionListener(this.treeSelectionEventSupport_);
        }
        this.tree_.setSelectionModel(selectionModel);
        if (selectionModel != null) {
            selectionModel.addTreeSelectionListener(this.treeSelectionEventSupport_);
        }
    }

    private class VPane_
    implements VPane,
    Serializable {
        private VPane_() {
        }

        @Override
        public VNode getRoot() {
            return AS400TreePane.this.getRoot();
        }

        @Override
        public VObject getObjectAt(Point point) {
            VObject object = null;
            TreePath treePath = AS400TreePane.this.tree_.getClosestPathForLocation(point.x, point.y);
            Rectangle pathBounds = AS400TreePane.this.tree_.getPathBounds(treePath);
            if (pathBounds.contains(point)) {
                object = (VObject)treePath.getLastPathComponent();
            }
            return object;
        }

        @Override
        public void setRoot(VNode root) throws PropertyVetoException {
            AS400TreePane.this.setRoot(root);
        }
    }

    private class VActionContext_
    implements VActionContext,
    Serializable {
        private VActionContext_() {
        }

        @Override
        public boolean getConfirm() {
            return AS400TreePane.this.confirm_;
        }

        @Override
        public Frame getFrame() {
            return VUtilities.getFrame(AS400TreePane.this);
        }

        @Override
        public CellEditor startEditing(VObject object, Object propertyIdentifier) {
            if (object == null) {
                throw new NullPointerException("object");
            }
            if (propertyIdentifier == null) {
                throw new NullPointerException("propertyIdentifier");
            }
            if (!AS400TreePane.this.allowActions_) {
                return null;
            }
            if (AS400TreePane.this.tree_.getPathBounds(AS400TreePane.this.model_.getPath(object)) != null) {
                AS400TreePane.this.tree_.startEditingAtPath(AS400TreePane.this.model_.getPath(object));
            }
            return AS400TreePane.this.tree_.getCellEditor();
        }
    }
}

